/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Balu
 * @copyright Copyright (c) 2015 - 2019 Baluart.COM
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link http://easyforms.baluart.com/ Easy Forms
 */

// Rule Builder Url
var ruleBuilderURL = FormSettings.ruleBuilderURL;
// Preview URL
var previewURL = FormSettings.previewURL;
// Set form id
var formID = FormSettings.formID;
// Set iframe id
var iID = FormSettings.iframe;
// Set iframe height
var iH = FormSettings.iHeight;
// Boolean iframe is in the DOM
var iExists = false;

/**
 * When a no one theme is selected
 *
 * @param e
 * @returns {boolean}
 */
var previewUnselected = function (e) {
    e.preventDefault();
    // Hide container
    $("#preview-container").hide();
    // Remove iframe
    $('#'+iID).remove();
    return iExists = false;
};

/**
 * When a theme is selected
 *
 * @param e
 * @returns {boolean}
 */
var previewSelected = function(e) {
    e.preventDefault();
    // Show container
    $("#preview-container").show();

    // Load iframe
    var themeID = $(e.currentTarget).val();
    var prefix = ( previewURL.indexOf('?') >= 0 ? '&' : '?' );
    var src = previewURL + prefix + $.param({
            id: formID,
            theme_id: themeID
        }, true );
    if( iExists === true ) {
        // If iframe exists, only change its src
        $('#'+iID).attr("src", src);
    } else {
        // Create iframe
        var i = $('<iframe></iframe>').attr({
            src: src,
            id: iID,
            frameborder: 0,
            width: '100%',
            height: iH
        });
        // Add iframe to div preview
        $("#preview").html(i);
        // Flag to true
        return iExists = true;
    }
};

/**
 * Resize iframe
 */
$("#resizeFull").click(function(e) {
    e.preventDefault();
    if(iExists) {
        // To expand
        var iEl = $("#"+iID);
        iEl.height( iEl.contents().find("html").height() );
        $(".toogleButton").toggle();
    }
});
$("#resizeSmall").click(function(e) {
    e.preventDefault();
    if(iExists) {
        // To contract
        $("#"+iID).height( iH );
        $(".toogleButton").toggle();
    }
});

$( document ).ready(function() {

    /**
     * Show Wysiwyg editor
     */
    if (typeof tinymce !== 'undefined') {
        tinymce.init({
            selector: '#formconfirmation-mail_message, #formemail-message',
            height: 300,
            plugins: 'advlist autolink link image lists charmap print preview hr anchor ' +
                'searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime nonbreaking ' +
                'save table directionality paste',
            toolbar: 'insertfile undo redo | styleselect | bold italic forecolor backcolor | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image table | preview fullscreen code',
            convert_urls: false
        });
    }

    /**
     * Show/Hide Forms fields Events Handlers
     */

    // Handlers
    toggleSchedule = function (e) {
        if(e.val() === "0") {
            $('.field-form-schedule_start_date').hide();
            $('.field-form-schedule_end_date').hide();
        } else {
            $('.field-form-schedule_start_date').show();
            $('.field-form-schedule_end_date').show();
        }
    };
    togglePassword = function (e) {
        if($("#form-use_password").is(":checked") === false) {
            $('.field-form-password').hide();
        } else {
            $('.field-form-password').show();
        }
    };
    toggleUrls = function (e) {
        if($("#form-authorized_urls").is(":checked") === false) {
            $('.field-form-urls').hide();
        } else {
            $('.field-form-urls').show();
        }
    };
    toggleTotalLimit = function (e) {
        if(e.val() === "0") {
            $('.field-form-total_limit_number').hide();
            $('.field-form-total_limit_period').hide();
        } else {
            $('.field-form-total_limit_number').show();
            $('.field-form-total_limit_period').show();
        }
    };
    toggleIPLimit = function (e) {
        if(e.val() === "0") {
            $('.field-form-ip_limit_number').hide();
            $('.field-form-ip_limit_period').hide();
        } else {
            $('.field-form-ip_limit_number').show();
            $('.field-form-ip_limit_period').show();
        }
    };
    toggleFormConfirmationFields = function (e) {
        if(e.val() === "0" || e.val() === "1") {
            $('.field-formconfirmation-message').show();
            $('.field-formconfirmation-url').hide();
            $('.field-formconfirmation-seconds').hide();
            $('.field-formconfirmation-append').hide();
            $('.field-formconfirmation-alias').hide();
        } else if (e.val() === "2") {
            $('.field-formconfirmation-message').hide();
            $('.field-formconfirmation-url').show();
            $('.field-formconfirmation-seconds').show();
            $('.field-formconfirmation-append').show();
            $('.field-formconfirmation-alias').show();
        }
    };
    toggleFormConfirmationRuleFields = function (e) {
        if(e.val() === "0" || e.val() === "1") {
            e.parents('.item').find('.message').show();
            e.parents('.item').find('.url').hide();
        } else if (e.val() === "2") {
            e.parents('.item').find('.message').hide();
            e.parents('.item').find('.url').show();
        }
    };
    toggleFormConfirmationEmailFields = function (e) {
        if(e.val() === "0") {
            $('.field-formconfirmation-mail_to').hide();
            $('.field-formconfirmation-mail_from').hide();
            $('.field-formconfirmation-mail_from_name').hide();
            $('.field-formconfirmation-mail_cc').hide();
            $('.field-formconfirmation-mail_bcc').hide();
            $('.field-formconfirmation-mail_subject').hide();
            $('.field-formconfirmation-mail_message').hide();
            $('.field-formconfirmation-mail_receipt_copy').hide();
            $('.field-formconfirmation-opt_in').hide();
            $('.field-formconfirmation-opt_in_type').hide();
            $('.field-formconfirmation-opt_in_message').hide();
            $('.field-formconfirmation-opt_in_url').hide();
        } else if (e.val() === "1") {
            $('.field-formconfirmation-mail_to').show();
            $('.field-formconfirmation-mail_from').show();
            $('.field-formconfirmation-mail_from_name').show();
            $('.field-formconfirmation-mail_cc').show();
            $('.field-formconfirmation-mail_bcc').show();
            $('.field-formconfirmation-mail_subject').show();
            $('.field-formconfirmation-mail_message').show();
            $('.field-formconfirmation-mail_receipt_copy').show();
            $('.field-formconfirmation-opt_in').show();
            toggleFormConfirmationOptInFields($("#formconfirmation-opt_in").is(":checked"));
        }
    };
    toggleFormConfirmationOptInFields = function (isChecked) {
        if (isChecked) {
            $('.field-formconfirmation-opt_in_type').show();
            toggleFormConfirmationOptInTypeFields($('[name$="FormConfirmation[opt_in_type]"]:checked'))
        } else {
            $('.field-formconfirmation-opt_in_type').hide();
            $('.field-formconfirmation-opt_in_message').hide();
            $('.field-formconfirmation-opt_in_url').hide();
        }
    };
    toggleFormConfirmationOptInTypeFields = function (e) {
        if (e.val() === "1") {
            $('.field-formconfirmation-opt_in_message').hide();
            $('.field-formconfirmation-opt_in_url').show();
        } else {
            $('.field-formconfirmation-opt_in_message').show();
            $('.field-formconfirmation-opt_in_url').hide();
        }
    };
    toggleFormEmailFields = function (e) {
        if(e.val() === "2") {
            $('.field-formemail-message').show();
        } else {
            $('.field-formemail-message').hide();
        }
    };

    // Events
    $('#form-schedule').find( ".btn" ).on('click', function(e) {
        toggleSchedule($(this).children());
    });
    $('#form-total_limit').find( ".btn" ).on('click', function(e) {
        toggleTotalLimit($(this).children());
    });
    $('#form-ip_limit').find( ".btn" ).on('click', function(e) {
        toggleIPLimit($(this).children());
    });
    $('#formconfirmation-type').find( ".btn" ).on('click', function(e) {
        toggleFormConfirmationFields($(this).children());
    });
    $('#formconfirmation-rules').on('click', '.btn-group .btn', function(e) {
        toggleFormConfirmationRuleFields($(this).children());
    });
    $('#formconfirmation-send_email').find( ".btn" ).on('click', function(e) {
        toggleFormConfirmationEmailFields($(this).children());
    });
    $('#formconfirmation-opt_in').on('click', function(e) {
        toggleFormConfirmationOptInFields($(this).is(':checked'));
    });
    $('#formconfirmation-opt_in_type').find( ".btn" ).on('click', function(e) {
        toggleFormConfirmationOptInTypeFields($(this).children());
    });
    $('#formemail-type').find( ".btn" ).on('click', function(e) {
        toggleFormEmailFields($(this).children());
    });

    // Init
    toggleSchedule($('[name$="Form[schedule]"]:checked'));
    togglePassword();
    toggleUrls();
    toggleTotalLimit($('[name$="Form[total_limit]"]:checked'));
    toggleIPLimit($('[name$="Form[ip_limit]"]:checked'));
    toggleFormConfirmationFields($('[name$="FormConfirmation[type]"]:checked'));
    toggleFormConfirmationEmailFields($('[name$="FormConfirmation[send_email]"]:checked'));
    toggleFormEmailFields($('[name$="FormEmail[type]"]:checked'));

    /**
     * Conditional Logic
     */

    var regexID = /^(.+?)([-\d-]{1,})(.+)$/i;
    var regexName = /(^.+?)([\[\d{1,}\]]{1,})(\[.+\]$)/i;

    var _updateAttrID = function(element, index) {
        var id            = element.attr('id');
        var newID         = id;

        if (id !== undefined) {
            var matches = id.match(regexID);
            if (matches && matches.length === 4) {
                matches[2] = matches[2].substring(1, matches[2].length - 1);
                var identifiers = matches[2].split('-');
                identifiers[0] = index;

                if (identifiers.length > 1) {
                    for (var i = identifiers.length - 1; i >= 1; i--) {
                        identifiers[i] = element.closest('.item').index();
                    }
                }

                newID = matches[1] + '-' + identifiers.join('-') + '-' + matches[3];
                element.attr('id', newID);
            } else {
                newID = id + index;
                element.attr('id', newID);
            }
        }

        if (id !== newID) {
            element.closest('.item').find("label[for='" + id + "']").attr('for', newID);
        }

        return newID;
    };

    var _updateAttrName = function(element, index) {
        var name = element.attr('name');

        if (name !== undefined) {
            var matches = name.match(regexName);

            if (matches && matches.length === 4) {
                matches[2] = matches[2].replace(/\]\[/g, "-").replace(/\]|\[/g, '');
                var identifiers = matches[2].split('-');
                identifiers[0] = index;

                if (identifiers.length > 1) {
                    for (var i = identifiers.length - 1; i >= 1; i--) {
                        identifiers[i] = element.closest('.item').index();
                    }
                }

                name = matches[1] + '[' + identifiers.join('][') + ']' + matches[3];
                element.attr('name', name);
            }
        }

        return name;
    };

    var _removeAttrDisabled = function(element, index) {
        element.removeAttr('disabled');
    };

    var _updateAttributes = function() {
        $('.item').each(function(index) {
            var item = $(this);
            $(this).find('*').each(function() {
                // update "id" attribute
                _updateAttrID($(this), index);

                // update "name" attribute
                _updateAttrName($(this), index);

                // remove "disabled" attribute
                _removeAttrDisabled($(this), index);
            });
        });
    };

    _updateAttributes();

    $('.item').each(function(index) {
        // Toggle Action fields
        toggleFormConfirmationRuleFields($(this).find('[name$="FormConfirmationRule['+index+'][action]"]:checked'));
        // Load Conditions Widget
        $(this)
            .find('.rule-builder-conditions')
            .attr('id', 'conditions-builder-' + index)
            .conditionsWidget({
                'field': '#formconfirmationrule-' + index + '-conditions',
                'url': ruleBuilderURL
            })
            .end()
    });

    $('form')
        // Add button click handler
        .on('click', '.add-item', function() {
            var item = $('.item').size();

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('hide')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);

            cloned
                .find('[name="FormConfirmationRule[action]"]')
                    .attr('name', 'FormConfirmationRule[' + item + '][action]')
                    .attr('id', 'formconfirmationrule-' + item + '-action')
                    .removeAttr('disabled')
                    .end()
                .find('[name="FormConfirmationRule[conditions]"]')
                    .attr('name', 'FormConfirmationRule[' + item + '][conditions]')
                    .attr('id', 'formconfirmationrule-' + item + '-conditions')
                    .removeAttr('disabled')
                    .end()
                .find('[name="FormConfirmationRule[message]"]')
                    .attr('name', 'FormConfirmationRule[' + item + '][message]')
                    .attr('id', 'formconfirmationrule-' + item + '-message')
                    .removeAttr('disabled')
                    .end()
                .find('[name="FormConfirmationRule[url]"]')
                    .attr('name', 'FormConfirmationRule[' + item + '][url]')
                    .attr('id', 'formconfirmationrule-' + item + '-url')
                    .removeAttr('disabled')
                    .end()
                .find('label[for="formconfirmationrule-append"]')
                    .attr('for', 'formconfirmationrule-' + item + '-append')
                    .end()
                .find('[name="FormConfirmationRule[append]"]')
                    .attr('name', 'FormConfirmationRule[' + item + '][append]')
                    .attr('id', 'formconfirmationrule-' + item + '-append')
                    .removeAttr('disabled')
                    .end()
                .find('label[for="formconfirmationrule-alias"]')
                    .attr('for', 'formconfirmationrule-' + item + '-alias')
                    .end()
                .find('[name="FormConfirmationRule[alias]"]')
                    .attr('name', 'FormConfirmationRule[' + item + '][alias]')
                    .attr('id', 'formconfirmationrule-' + item + '-alias')
                    .removeAttr('disabled')
                    .end()
                .find('[name="FormConfirmationRule[seconds]"]')
                    .attr('name', 'FormConfirmationRule[' + item + '][seconds]')
                    .attr('id', 'formconfirmationrule-' + item + '-seconds')
                    .removeAttr('disabled')
                    .end()
                .find('.rule-builder-conditions')
                    .attr('id', 'conditions-builder-' + item)
                    .conditionsWidget({
                        'field': '#formconfirmationrule-' + item + '-conditions',
                        'url': ruleBuilderURL
                    })
                    .end();

            item++;
        })
        // Remove button click handler
        .on('click', '.copy-item', function() {
            var fieldset = $(this).closest('fieldset'),
                cloned = fieldset
                    .clone()
                    .removeAttr('id')
                    .insertAfter(fieldset);
            _updateAttributes();
            var item = cloned.index();
            cloned
                .find('.rule-builder-conditions')
                .attr('id', 'conditions-builder-' + item)
                .conditionsWidget({
                    'field': '#formconfirmationrule-' + item + '-conditions',
                    'url': ruleBuilderURL
                })
                .end()
        })
        // Remove button click handler
        .on('click', '.remove-item', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
            _updateAttributes();
        });

});
