/*
 Date: 12/12/2019 16:25:52
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for addon
-- ----------------------------
DROP TABLE IF EXISTS `addon`;
CREATE TABLE `addon`  (
  `id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `class` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `description` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `version` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `status` tinyint(1) NULL DEFAULT 0,
  `installed` tinyint(1) NULL DEFAULT 0,
  UNIQUE INDEX `id`(`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for event
-- ----------------------------
DROP TABLE IF EXISTS `event`;
CREATE TABLE `event`  (
  `app_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `platform` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `etl_tstamp` int(11) NULL DEFAULT NULL,
  `collector_tstamp` int(11) NOT NULL,
  `dvce_tstamp` bigint(20) NULL DEFAULT NULL,
  `event` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `event_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `txn_id` int(11) NULL DEFAULT NULL,
  `name_tracker` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `v_tracker` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `v_collector` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `v_etl` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `user_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `user_ipaddress` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `user_fingerprint` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `domain_userid` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `domain_sessionidx` smallint(6) NULL DEFAULT NULL,
  `network_userid` varchar(38) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `geo_country` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `geo_region` varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `geo_city` varchar(75) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `geo_zipcode` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `geo_latitude` double NULL DEFAULT NULL,
  `geo_longitude` double NULL DEFAULT NULL,
  `geo_region_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `page_url` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `page_title` varchar(2000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `page_referrer` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `page_urlscheme` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `page_urlhost` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `page_urlport` int(11) NULL DEFAULT NULL,
  `page_urlpath` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `page_urlquery` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `page_urlfragment` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `refr_urlscheme` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `refr_urlhost` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `refr_urlport` int(11) NULL DEFAULT NULL,
  `refr_urlpath` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `refr_urlquery` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `refr_urlfragment` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `refr_medium` varchar(25) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `refr_source` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `refr_term` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `mkt_medium` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `mkt_source` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `mkt_term` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `mkt_content` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `mkt_campaign` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `contexts` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `se_category` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `se_action` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `se_label` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `se_property` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `se_value` double NULL DEFAULT NULL,
  `unstruct_event` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `tr_orderid` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `tr_affiliation` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `tr_total` decimal(18, 2) NULL DEFAULT NULL,
  `tr_tax` decimal(18, 2) NULL DEFAULT NULL,
  `tr_shipping` decimal(18, 2) NULL DEFAULT NULL,
  `tr_city` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `tr_state` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `tr_country` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ti_orderid` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ti_sku` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ti_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ti_category` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ti_price` decimal(18, 2) NULL DEFAULT NULL,
  `ti_quantity` int(11) NULL DEFAULT NULL,
  `pp_xoffset_min` int(11) NULL DEFAULT NULL,
  `pp_xoffset_max` int(11) NULL DEFAULT NULL,
  `pp_yoffset_min` int(11) NULL DEFAULT NULL,
  `pp_yoffset_max` int(11) NULL DEFAULT NULL,
  `useragent` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `br_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `br_family` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `br_version` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `br_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `br_renderengine` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `br_lang` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `br_features_pdf` tinyint(1) NULL DEFAULT NULL,
  `br_features_flash` tinyint(1) NULL DEFAULT NULL,
  `br_features_java` tinyint(1) NULL DEFAULT NULL,
  `br_features_director` tinyint(1) NULL DEFAULT NULL,
  `br_features_quicktime` tinyint(1) NULL DEFAULT NULL,
  `br_features_realplayer` tinyint(1) NULL DEFAULT NULL,
  `br_features_windowsmedia` tinyint(1) NULL DEFAULT NULL,
  `br_features_gears` tinyint(1) NULL DEFAULT NULL,
  `br_features_silverlight` tinyint(1) NULL DEFAULT NULL,
  `br_cookies` tinyint(1) NULL DEFAULT NULL,
  `br_colordepth` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `br_viewwidth` int(11) NULL DEFAULT NULL,
  `br_viewheight` int(11) NULL DEFAULT NULL,
  `os_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `os_family` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `os_manufacturer` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `os_timezone` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `dvce_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `dvce_ismobile` tinyint(1) NULL DEFAULT NULL,
  `dvce_screenwidth` int(11) NULL DEFAULT NULL,
  `dvce_screenheight` int(11) NULL DEFAULT NULL,
  `doc_charset` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `doc_width` int(11) NULL DEFAULT NULL,
  `doc_height` int(11) NULL DEFAULT NULL,
  `geo_timezone` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `mkt_clickid` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `mkt_network` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `etl_tags` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `dvce_sent_tstamp` bigint(20) NULL DEFAULT NULL,
  `domain_sessionid` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for form
-- ----------------------------
DROP TABLE IF EXISTS `form`;
CREATE TABLE `form`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `slug` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `use_password` tinyint(1) NOT NULL DEFAULT 0,
  `password` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `authorized_urls` tinyint(1) NOT NULL DEFAULT 0,
  `urls` varchar(2555) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `schedule` tinyint(1) NOT NULL DEFAULT 0,
  `schedule_start_date` int(11) NULL DEFAULT NULL,
  `schedule_end_date` int(11) NULL DEFAULT NULL,
  `total_limit` tinyint(1) NOT NULL DEFAULT 0,
  `total_limit_number` int(11) NULL DEFAULT NULL,
  `total_limit_period` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ip_limit` tinyint(1) NOT NULL DEFAULT 0,
  `ip_limit_number` int(11) NULL DEFAULT NULL,
  `ip_limit_period` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `submission_number` int(11) NULL DEFAULT 1,
  `submission_number_prefix` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `submission_number_suffix` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `submission_number_width` int(11) NULL DEFAULT NULL,
  `save` tinyint(1) NOT NULL DEFAULT 1,
  `resume` tinyint(1) NOT NULL DEFAULT 0,
  `autocomplete` tinyint(1) NOT NULL DEFAULT 1,
  `novalidate` tinyint(1) NOT NULL DEFAULT 0,
  `analytics` tinyint(1) NOT NULL DEFAULT 1,
  `honeypot` tinyint(1) NOT NULL DEFAULT 1,
  `recaptcha` tinyint(1) NOT NULL DEFAULT 0,
  `language` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'en-US',
  `message` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `created_by` int(11) NOT NULL,
  `updated_by` int(11) NOT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for form_chart
-- ----------------------------
DROP TABLE IF EXISTS `form_chart`;
CREATE TABLE `form_chart`  (
  `form_id` int(11) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `label` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `title` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `type` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `width` int(11) NULL DEFAULT NULL,
  `height` int(11) NULL DEFAULT NULL,
  `gsX` int(11) NULL DEFAULT NULL,
  `gsY` int(11) NULL DEFAULT NULL,
  `gsW` int(11) NULL DEFAULT NULL,
  `gsH` int(11) NULL DEFAULT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  UNIQUE INDEX `form_chart_form_id_name`(`form_id`, `name`) USING BTREE,
  INDEX `form_chart_form_id`(`form_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for form_confirmation
-- ----------------------------
DROP TABLE IF EXISTS `form_confirmation`;
CREATE TABLE `form_confirmation`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_id` int(11) NOT NULL,
  `type` int(1) NOT NULL DEFAULT 0,
  `message` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `url` varchar(2555) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `append` int(11) NOT NULL DEFAULT 0,
  `alias` int(11) NOT NULL DEFAULT 0,
  `seconds` int(11) NULL DEFAULT NULL,
  `send_email` tinyint(1) NOT NULL DEFAULT 0,
  `mail_to` varchar(2555) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `mail_from` varchar(2555) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `mail_cc` varchar(2555) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `mail_bcc` varchar(2555) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `mail_subject` varchar(2555) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `mail_message` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `mail_from_name` varchar(2555) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `mail_receipt_copy` tinyint(1) NULL DEFAULT 0,
  `mail_attach` int(11) NOT NULL DEFAULT 1,
  `mail_attachments` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `opt_in` int(11) NULL DEFAULT NULL,
  `opt_in_type` int(11) NULL DEFAULT 0,
  `opt_in_message` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `opt_in_url` varchar(2555) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `opt_out` int(11) NULL DEFAULT NULL,
  `opt_out_type` int(11) NULL DEFAULT 0,
  `opt_out_message` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `opt_out_url` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `form_confirmation_form_id`(`form_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for form_confirmation_rule
-- ----------------------------
DROP TABLE IF EXISTS `form_confirmation_rule`;
CREATE TABLE `form_confirmation_rule`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_id` int(11) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `conditions` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `action` int(1) NOT NULL DEFAULT 0,
  `message` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `url` varchar(2555) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `append` int(1) NOT NULL DEFAULT 0,
  `alias` int(1) NOT NULL DEFAULT 0,
  `seconds` int(1) NULL DEFAULT NULL,
  `created_by` int(11) NULL DEFAULT NULL,
  `updated_by` int(11) NULL DEFAULT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for form_data
-- ----------------------------
DROP TABLE IF EXISTS `form_data`;
CREATE TABLE `form_data`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_id` int(11) NOT NULL,
  `builder` mediumtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `fields` mediumtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `html` mediumtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `height` int(5) NOT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `form_data_form_id`(`form_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for form_email
-- ----------------------------
DROP TABLE IF EXISTS `form_email`;
CREATE TABLE `form_email`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_id` int(11) NOT NULL,
  `field_to` varchar(2555) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `to` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `from` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `cc` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `bcc` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `subject` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `type` int(1) NOT NULL DEFAULT 0,
  `message` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `plain_text` tinyint(1) NOT NULL DEFAULT 0,
  `attach` tinyint(1) NOT NULL DEFAULT 1,
  `event` int(11) NOT NULL DEFAULT 1,
  `conditions` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `form_email_form_id`(`form_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for form_rule
-- ----------------------------
DROP TABLE IF EXISTS `form_rule`;
CREATE TABLE `form_rule`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_id` int(11) NOT NULL,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `opposite` tinyint(1) NOT NULL DEFAULT 1,
  `ordinal` int(11) NOT NULL DEFAULT 0,
  `conditions` mediumtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `actions` mediumtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `form_rule_form_id`(`form_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for form_submission
-- ----------------------------
DROP TABLE IF EXISTS `form_submission`;
CREATE TABLE `form_submission`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_id` int(11) NOT NULL,
  `number` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `new` tinyint(1) NOT NULL DEFAULT 1,
  `important` tinyint(1) NOT NULL DEFAULT 0,
  `sender` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `data` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `ip` tinytext CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `created_by` int(11) NULL DEFAULT NULL,
  `updated_by` int(11) NULL DEFAULT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `form_submission_form_id`(`form_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for form_submission_comment
-- ----------------------------
DROP TABLE IF EXISTS `form_submission_comment`;
CREATE TABLE `form_submission_comment`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `submission_id` int(11) NOT NULL,
  `form_id` int(11) NOT NULL,
  `content` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_by` int(11) NOT NULL,
  `updated_by` int(11) NOT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `form_submission_comment_submission_id`(`submission_id`) USING BTREE,
  INDEX `form_submission_comment_form_id`(`form_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for form_submission_file
-- ----------------------------
DROP TABLE IF EXISTS `form_submission_file`;
CREATE TABLE `form_submission_file`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `submission_id` int(11) NOT NULL,
  `form_id` int(11) NOT NULL,
  `field` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `label` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `extension` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `size` int(11) NULL DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `form_submission_file_submission_id`(`submission_id`) USING BTREE,
  INDEX `form_submission_file_form_id`(`form_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for form_ui
-- ----------------------------
DROP TABLE IF EXISTS `form_ui`;
CREATE TABLE `form_ui`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_id` int(11) NOT NULL,
  `theme_id` int(11) NULL DEFAULT NULL,
  `js_file` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `form_ui_form_id`(`form_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for form_user
-- ----------------------------
DROP TABLE IF EXISTS `form_user`;
CREATE TABLE `form_user`  (
  `form_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  UNIQUE INDEX `form_user_form_id_user_id`(`form_id`, `user_id`) USING BTREE,
  INDEX `form_user_form_id`(`form_id`) USING BTREE,
  INDEX `form_user_user_id`(`user_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for log_event
-- ----------------------------
DROP TABLE IF EXISTS `log_event`;
CREATE TABLE `log_event`  (
  `app_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `platform` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `etl_tstamp` int(11) NULL DEFAULT NULL,
  `collector_tstamp` int(11) NOT NULL,
  `dvce_tstamp` bigint(20) NULL DEFAULT NULL,
  `event` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `event_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `txn_id` int(11) NULL DEFAULT NULL,
  `name_tracker` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `v_tracker` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `v_collector` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `v_etl` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `user_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `user_ipaddress` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `user_fingerprint` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `domain_userid` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `domain_sessionidx` smallint(6) NULL DEFAULT NULL,
  `network_userid` varchar(38) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `geo_country` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `geo_region` varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `geo_city` varchar(75) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `geo_zipcode` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `geo_latitude` double NULL DEFAULT NULL,
  `geo_longitude` double NULL DEFAULT NULL,
  `geo_region_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `page_url` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `page_title` varchar(2000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `page_referrer` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `page_urlscheme` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `page_urlhost` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `page_urlport` int(11) NULL DEFAULT NULL,
  `page_urlpath` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `page_urlquery` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `page_urlfragment` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `refr_urlscheme` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `refr_urlhost` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `refr_urlport` int(11) NULL DEFAULT NULL,
  `refr_urlpath` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `refr_urlquery` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `refr_urlfragment` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `refr_medium` varchar(25) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `refr_source` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `refr_term` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `mkt_medium` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `mkt_source` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `mkt_term` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `mkt_content` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `mkt_campaign` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `contexts` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `se_category` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `se_action` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `se_label` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `se_property` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `se_value` double NULL DEFAULT NULL,
  `unstruct_event` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `tr_orderid` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `tr_affiliation` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `tr_total` decimal(18, 2) NULL DEFAULT NULL,
  `tr_tax` decimal(18, 2) NULL DEFAULT NULL,
  `tr_shipping` decimal(18, 2) NULL DEFAULT NULL,
  `tr_city` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `tr_state` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `tr_country` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ti_orderid` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ti_sku` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ti_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ti_category` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `ti_price` decimal(18, 2) NULL DEFAULT NULL,
  `ti_quantity` int(11) NULL DEFAULT NULL,
  `pp_xoffset_min` int(11) NULL DEFAULT NULL,
  `pp_xoffset_max` int(11) NULL DEFAULT NULL,
  `pp_yoffset_min` int(11) NULL DEFAULT NULL,
  `pp_yoffset_max` int(11) NULL DEFAULT NULL,
  `useragent` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `br_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `br_family` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `br_version` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `br_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `br_renderengine` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `br_lang` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `br_features_pdf` tinyint(1) NULL DEFAULT NULL,
  `br_features_flash` tinyint(1) NULL DEFAULT NULL,
  `br_features_java` tinyint(1) NULL DEFAULT NULL,
  `br_features_director` tinyint(1) NULL DEFAULT NULL,
  `br_features_quicktime` tinyint(1) NULL DEFAULT NULL,
  `br_features_realplayer` tinyint(1) NULL DEFAULT NULL,
  `br_features_windowsmedia` tinyint(1) NULL DEFAULT NULL,
  `br_features_gears` tinyint(1) NULL DEFAULT NULL,
  `br_features_silverlight` tinyint(1) NULL DEFAULT NULL,
  `br_cookies` tinyint(1) NULL DEFAULT NULL,
  `br_colordepth` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `br_viewwidth` int(11) NULL DEFAULT NULL,
  `br_viewheight` int(11) NULL DEFAULT NULL,
  `os_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `os_family` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `os_manufacturer` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `os_timezone` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `dvce_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `dvce_ismobile` tinyint(1) NULL DEFAULT NULL,
  `dvce_screenwidth` int(11) NULL DEFAULT NULL,
  `dvce_screenheight` int(11) NULL DEFAULT NULL,
  `doc_charset` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `doc_width` int(11) NULL DEFAULT NULL,
  `doc_height` int(11) NULL DEFAULT NULL,
  `geo_timezone` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `mkt_clickid` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `mkt_network` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `etl_tags` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `dvce_sent_tstamp` bigint(20) NULL DEFAULT NULL,
  `domain_sessionid` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for mail_queue
-- ----------------------------
DROP TABLE IF EXISTS `mail_queue`;
CREATE TABLE `mail_queue`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `from` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `to` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `cc` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `bcc` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `subject` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `html_body` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `text_body` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `reply_to` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `charset` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `attachments` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `created_at` datetime(0) NOT NULL,
  `attempts` int(11) NULL DEFAULT NULL,
  `last_attempt_time` datetime(0) NULL DEFAULT NULL,
  `sent_time` datetime(0) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for migration
-- ----------------------------
DROP TABLE IF EXISTS `migration`;
CREATE TABLE `migration`  (
  `version` varchar(180) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `apply_time` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`version`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of migration
-- ----------------------------
INSERT INTO `migration` VALUES ('m000000_000000_base', 1576185882);
INSERT INTO `migration` VALUES ('m150214_044830_init_user', 1576185890);
INSERT INTO `migration` VALUES ('m150410_183765_init_setting', 1576185890);
INSERT INTO `migration` VALUES ('m150412_184646_init_theme', 1576185890);
INSERT INTO `migration` VALUES ('m150415_183345_init_form', 1576185891);
INSERT INTO `migration` VALUES ('m150420_183546_init_stats', 1576185891);
INSERT INTO `migration` VALUES ('m150420_183547_init_template', 1576185892);
INSERT INTO `migration` VALUES ('m150420_183548_init_mailqueue', 1576185892);
INSERT INTO `migration` VALUES ('m150420_183550_init_addon', 1576185892);
INSERT INTO `migration` VALUES ('m160104_150526_add_slug_to_form', 1576185892);
INSERT INTO `migration` VALUES ('m160110_151514_add_password_novalidate_to_form', 1576185893);
INSERT INTO `migration` VALUES ('m160118_171459_upgrade_user_module', 1576185894);
INSERT INTO `migration` VALUES ('m160630_181205_upgrade_to_136', 1576185894);
INSERT INTO `migration` VALUES ('m160813_213103_upgrade_to_137', 1576185894);
INSERT INTO `migration` VALUES ('m160813_213105_upgrade_to_139', 1576185894);
INSERT INTO `migration` VALUES ('m190624_153537_upgrade_to_170', 1576185895);
INSERT INTO `migration` VALUES ('m190811_215815_upgrade_to_172', 1576185895);
INSERT INTO `migration` VALUES ('m191202_174827_upgrade_to_191', 1576185897);

-- ----------------------------
-- Table structure for profile
-- ----------------------------
DROP TABLE IF EXISTS `profile`;
CREATE TABLE `profile`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp(0) NULL DEFAULT NULL,
  `updated_at` timestamp(0) NULL DEFAULT NULL,
  `full_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `company` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `avatar` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `timezone` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `language` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `profile_user_id`(`user_id`) USING BTREE,
  CONSTRAINT `profile_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for role
-- ----------------------------
DROP TABLE IF EXISTS `role`;
CREATE TABLE `role`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `created_at` timestamp(0) NULL DEFAULT NULL,
  `updated_at` timestamp(0) NULL DEFAULT NULL,
  `can_admin` smallint(6) NOT NULL DEFAULT 0,
  `can_edit_own_content` smallint(6) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of role
-- ----------------------------
INSERT INTO `role` VALUES (1, 'Admin', '2019-12-12 21:24:50', NULL, 1, 1);
INSERT INTO `role` VALUES (2, 'Basic User', '2019-12-12 21:24:50', NULL, 0, 0);
INSERT INTO `role` VALUES (3, 'Advanced User', '2019-12-12 21:24:54', NULL, 0, 1);

-- ----------------------------
-- Table structure for setting
-- ----------------------------
DROP TABLE IF EXISTS `setting`;
CREATE TABLE `setting`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `category` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `key` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `value` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `setting_category_key`(`category`, `key`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 18 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of setting
-- ----------------------------
INSERT INTO `setting` VALUES (1, 'string', 'app', 'name', 'Easy Forms', 1, 1576185890, 1576185890);
INSERT INTO `setting` VALUES (2, 'string', 'app', 'description', '<p>Welcome to <span style=\"color: #c9d2db;\"> the easiest way </span> to build, design and manage <span style=\"color: #e8ebef; font-weight: bold;\"> your online forms</span>.</p>', 1, 1576185890, 1576185890);
INSERT INTO `setting` VALUES (3, 'string', 'app', 'adminEmail', 'admin@example.com', 1, 1576185890, 1576185890);
INSERT INTO `setting` VALUES (4, 'string', 'app', 'supportEmail', 'support@example.com', 1, 1576185890, 1576185890);
INSERT INTO `setting` VALUES (5, 'string', 'app', 'noreplyEmail', 'no-reply@example.com', 1, 1576185890, 1576185890);
INSERT INTO `setting` VALUES (6, 'string', 'app', 'reCaptchaVersion', '2', 1, 1576185890, 1576185890);
INSERT INTO `setting` VALUES (7, 'string', 'app', 'reCaptchaSecret', 'your_secret', 1, 1576185890, 1576185890);
INSERT INTO `setting` VALUES (8, 'string', 'app', 'reCaptchaSiteKey', 'your_site_key', 1, 1576185890, 1576185890);
INSERT INTO `setting` VALUES (9, 'string', 'smtp', 'host', 'localhost', 1, 1576185890, 1576185890);
INSERT INTO `setting` VALUES (10, 'string', 'smtp', 'port', '25', 1, 1576185890, 1576185890);
INSERT INTO `setting` VALUES (11, 'string', 'smtp', 'encryption', 'none', 1, 1576185890, 1576185890);
INSERT INTO `setting` VALUES (12, 'string', 'smtp', 'username', 'Username', 1, 1576185890, 1576185890);
INSERT INTO `setting` VALUES (13, 'string', 'smtp', 'password', 'Password', 1, 1576185890, 1576185890);
INSERT INTO `setting` VALUES (14, 'integer', 'app', 'anyoneCanRegister', '0', 1, 1576185894, 1576185894);
INSERT INTO `setting` VALUES (15, 'integer', 'app', 'loginWithoutPassword', '0', 1, 1576185894, 1576185894);
INSERT INTO `setting` VALUES (16, 'integer', 'app', 'useCaptcha', '0', 1, 1576185894, 1576185894);
INSERT INTO `setting` VALUES (17, 'integer', 'app', 'defaultUserRole', '2', 1, 1576185894, 1576185894);

-- ----------------------------
-- Table structure for stats_performance
-- ----------------------------
DROP TABLE IF EXISTS `stats_performance`;
CREATE TABLE `stats_performance`  (
  `day` date NOT NULL,
  `app_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `users` int(11) NULL DEFAULT NULL,
  `fills` int(11) NULL DEFAULT NULL,
  `conversions` int(11) NULL DEFAULT NULL,
  `conversionTime` bigint(20) UNSIGNED NULL DEFAULT NULL,
  UNIQUE INDEX `stats_performance_day_app_id`(`day`, `app_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for stats_submissions
-- ----------------------------
DROP TABLE IF EXISTS `stats_submissions`;
CREATE TABLE `stats_submissions`  (
  `app_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `collector_tstamp` int(11) NOT NULL,
  `domain_sessionidx` smallint(6) NULL DEFAULT NULL,
  `geo_country` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `geo_city` varchar(75) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `refr_urlhost` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `refr_medium` varchar(25) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `br_family` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `os_family` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `dvce_type` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `dvce_ismobile` tinyint(1) NULL DEFAULT NULL
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for template
-- ----------------------------
DROP TABLE IF EXISTS `template`;
CREATE TABLE `template`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NULL DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `description` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `builder` mediumtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `html` mediumtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `promoted` tinyint(1) NULL DEFAULT 0,
  `slug` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `updated_by` int(11) NOT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 13 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of template
-- ----------------------------
INSERT INTO `template` VALUES (1, 1, 'Basic Contact Form', 'Contact information is important for business owners, professionals, and other organizations. This form allows you to collect name, email addresses and other information so that you can reach personal or business contacts in the future.', '{\"settings\":{\"name\":\"Contact Form\",\"canvas\":\"#canvas\",\"disabledFieldset\":false,\"layoutSelected\":\"\",\"layouts\":[{\"id\":\"\",\"name\":\"Vertical\"},{\"id\":\"form-horizontal\",\"name\":\"Horizontal\"},{\"id\":\"form-inline\",\"name\":\"Inline\"}],\"formSteps\":{\"title\":\"formSteps.title\",\"fields\":{\"id\":{\"label\":\"formSteps.id\",\"type\":\"input\",\"value\":\"formSteps\",\"name\":\"id\"},\"steps\":{\"label\":\"formSteps.steps\",\"type\":\"textarea-split\",\"value\":[],\"name\":\"steps\"},\"progressBar\":{\"label\":\"formSteps.progressBar\",\"type\":\"checkbox\",\"value\":false,\"name\":\"progressBar\"},\"noTitles\":{\"label\":\"formSteps.noTitles\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noTitles\"},\"noStages\":{\"label\":\"formSteps.noStages\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noStages\"},\"noSteps\":{\"label\":\"formSteps.noSteps\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noSteps\"}}}},\"initForm\":[{\"name\":\"heading\",\"title\":\"heading.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"heading_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"input\",\"value\":\"Contact Us\",\"name\":\"text\"},\"type\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"h1\",\"selected\":false,\"label\":\"H1\"},{\"value\":\"h2\",\"selected\":false,\"label\":\"H2\"},{\"value\":\"h3\",\"selected\":true,\"label\":\"H3\"},{\"value\":\"h4\",\"selected\":false,\"label\":\"H4\"},{\"value\":\"h5\",\"selected\":false,\"label\":\"H5\"},{\"value\":\"h6\",\"selected\":false,\"label\":\"H6\"}],\"name\":\"heading\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"legend\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"paragraph\",\"title\":\"paragraph.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"paragraph_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"textarea\",\"value\":\"Let us know your questions, suggestions and concerns by filling out the contact form below.\",\"name\":\"text\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_0\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Name\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"email\",\"title\":\"email.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"email_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Email\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"checkdns\":{\"label\":\"component.checkDNS\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"checkdns\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"textarea\",\"title\":\"textarea.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"textarea_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Message\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"fieldSize\":{\"label\":\"component.fieldSize\",\"type\":\"input\",\"value\":\"3\",\"advanced\":true,\"name\":\"fieldSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"button\",\"title\":\"button.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"button_0\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"submit\",\"label\":\"Submit\",\"selected\":true},{\"value\":\"reset\",\"label\":\"Reset\",\"selected\":false},{\"value\":\"image\",\"label\":\"Image\",\"selected\":false}],\"name\":\"inputType\"},\"buttonText\":{\"label\":\"component.buttonText\",\"type\":\"input\",\"value\":\"Submit\",\"name\":\"buttonText\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"label\"},\"src\":{\"label\":\"component.src\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"src\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"btn btn-primary\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false}],\"height\":412}', '&lt;form id=&quot;form-app&quot;&gt;\r\n&lt;fieldset&gt;\r\n\r\n&lt;!-- Heading --&gt;\r\n&lt;h3 class=&quot;legend&quot;&gt;Contact Us&lt;/h3&gt;\r\n\r\n&lt;!-- Paragraph Text --&gt;\r\n&lt;p&gt;Let us know your questions, suggestions and concerns by filling out the contact form below.&lt;/p&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_0&quot;&gt;Name&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_0&quot; name=&quot;text_0&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Email --&gt;\r\n&lt;div class=&quot;form-group required-control&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;email_0&quot;&gt;Email&lt;/label&gt;\r\n    &lt;input type=&quot;email&quot; id=&quot;email_0&quot; name=&quot;email_0&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text Area --&gt;\r\n&lt;div class=&quot;form-group required-control&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;textarea_0&quot;&gt;Message&lt;/label&gt;\r\n    &lt;textarea id=&quot;textarea_0&quot; name=&quot;textarea_0&quot; rows=&quot;3&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;&lt;/textarea&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Button --&gt;\r\n&lt;div class=&quot;form-action&quot;&gt;\r\n    &lt;input type=&quot;submit&quot; id=&quot;button_0&quot; name=&quot;button_0&quot; class=&quot;btn btn-primary&quot; value=&quot;Submit&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;/fieldset&gt;\r\n&lt;/form&gt;', 1, 'basic-contact-form', 1, 1, 1576184991, 1576185892);
INSERT INTO `template` VALUES (2, 2, 'Customer Satisfaction Survey', 'You don\'t need an expensive marketing research team to gather detailed information about your customers. Instead, use this survey for a quick and easy way to get invaluable feedback from customers on the quality of your product or service.', '{\"settings\":{\"name\":\"Customer Satisfaction Survey\",\"canvas\":\"#canvas\",\"disabledFieldset\":false,\"layoutSelected\":\"\",\"layouts\":[{\"id\":\"\",\"name\":\"Vertical\"},{\"id\":\"form-horizontal\",\"name\":\"Horizontal\"},{\"id\":\"form-inline\",\"name\":\"Inline\"}],\"formSteps\":{\"title\":\"formSteps.title\",\"fields\":{\"id\":{\"label\":\"formSteps.id\",\"type\":\"input\",\"value\":\"formSteps\",\"name\":\"id\"},\"steps\":{\"label\":\"formSteps.steps\",\"type\":\"textarea-split\",\"value\":[],\"name\":\"steps\"},\"progressBar\":{\"label\":\"formSteps.progressBar\",\"type\":\"checkbox\",\"value\":false,\"name\":\"progressBar\"},\"noTitles\":{\"label\":\"formSteps.noTitles\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noTitles\"},\"noStages\":{\"label\":\"formSteps.noStages\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noStages\"},\"noSteps\":{\"label\":\"formSteps.noSteps\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noSteps\"}}}},\"initForm\":[{\"name\":\"heading\",\"title\":\"heading.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"heading_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"input\",\"value\":\"Customer Satisfaction Survey\",\"name\":\"text\"},\"type\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"h1\",\"selected\":false,\"label\":\"H1\"},{\"value\":\"h2\",\"selected\":false,\"label\":\"H2\"},{\"value\":\"h3\",\"selected\":true,\"label\":\"H3\"},{\"value\":\"h4\",\"selected\":false,\"label\":\"H4\"},{\"value\":\"h5\",\"selected\":false,\"label\":\"H5\"},{\"value\":\"h6\",\"selected\":false,\"label\":\"H6\"}],\"name\":\"heading\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"legend\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"paragraph\",\"title\":\"paragraph.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"paragraph_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"textarea\",\"value\":\"Please take a few moments to complete this satisfaction survey.\",\"name\":\"text\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Overall, how satisfied were you with the product \\/ service?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"textarea-split\",\"value\":[\"Very Satisfied\",\"Satisfied\",\"Neutral\",\"Unsatisfied\",\"Very Unsatisfied\",\"N\\/A\"],\"name\":\"radios\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"radio-inline\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Would you recommend our product \\/ service to colleagues or contacts within your industry?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"textarea-split\",\"value\":[\"Definitely\",\"Probably\",\"Not Sure\",\"Probably Not\",\"Definitely Not\"],\"name\":\"radios\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"radio-inline\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_2\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Would you use our product \\/ service in the future?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"textarea-split\",\"value\":[\"Less than a month\",\"1-6 months\",\"1-3 years\",\"Over 3 Years\",\"Never used\"],\"name\":\"radios\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"radio-inline\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_3\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"How often do you use product \\/ service?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"textarea-split\",\"value\":[\"Once a week\",\"2 to 3 times a month\",\"Once a month\",\"Less than once a month\"],\"name\":\"radios\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"radio-inline\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_4\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"What aspect of the product \\/ service were you most satisfied by?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"textarea-split\",\"value\":[\"Quality\",\"Price\",\"Purchase Experience\",\"Installation or First Use Experience\",\"Usage Experience\",\"Customer Service\",\"Repeat Purchase Experience\"],\"name\":\"radios\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"radio-inline\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"textarea\",\"title\":\"textarea.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"textarea_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"What do you like about the product \\/ service?\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"fieldSize\":{\"label\":\"component.fieldSize\",\"type\":\"input\",\"value\":\"3\",\"advanced\":true,\"name\":\"fieldSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"textarea\",\"title\":\"textarea.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"textarea_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"What do you dislike about the product \\/ service?\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"fieldSize\":{\"label\":\"component.fieldSize\",\"type\":\"input\",\"value\":\"3\",\"advanced\":true,\"name\":\"fieldSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_5\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Thinking of similar products \\/ services offered by other companies, how would you compare the product \\/ service offered by our company?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"textarea-split\",\"value\":[\"Much Better\",\"Somewhat Better\",\"About the Same\",\"Somewhat Worse\",\"Much Worse\",\"Don\\u0027t Know\"],\"name\":\"radios\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"radio-inline\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"button\",\"title\":\"button.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"button_0\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"submit\",\"label\":\"Submit\",\"selected\":true},{\"value\":\"reset\",\"label\":\"Reset\",\"selected\":false},{\"value\":\"image\",\"label\":\"Image\",\"selected\":false}],\"name\":\"inputType\"},\"buttonText\":{\"label\":\"component.buttonText\",\"type\":\"input\",\"value\":\"Submit\",\"name\":\"buttonText\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"label\"},\"src\":{\"label\":\"component.src\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"src\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"btn btn-primary\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false}],\"height\":1526}', '&lt;form id=&quot;form-app&quot;&gt;\r\n&lt;fieldset&gt;\r\n\r\n&lt;!-- Heading --&gt;\r\n&lt;h3 class=&quot;legend&quot;&gt;Customer Satisfaction Survey&lt;/h3&gt;\r\n\r\n&lt;!-- Paragraph Text --&gt;\r\n&lt;p&gt;Please take a few moments to complete this satisfaction survey.&lt;/p&gt;\r\n\r\n&lt;!-- Radio --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_0&quot;&gt;Overall, how satisfied were you with the product / service?&lt;/label&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_0_0&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_0&quot; value=&quot;Very Satisfied&quot;&gt; Very Satisfied &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_0_1&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_1&quot; value=&quot;Satisfied&quot;&gt; Satisfied &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_0_2&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_2&quot; value=&quot;Neutral&quot;&gt; Neutral &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_0_3&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_3&quot; value=&quot;Unsatisfied&quot;&gt; Unsatisfied &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_0_4&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_4&quot; value=&quot;Very Unsatisfied&quot;&gt; Very Unsatisfied &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_0_5&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_5&quot; value=&quot;N/A&quot;&gt; N/A &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;span id=&quot;radio_0&quot;&gt;&lt;/span&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Radio --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_1&quot;&gt;Would you recommend our product / service to colleagues or contacts within your industry?&lt;/label&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_1_0&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_0&quot; value=&quot;Definitely&quot;&gt; Definitely &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_1_1&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_1&quot; value=&quot;Probably&quot;&gt; Probably &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_1_2&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_2&quot; value=&quot;Not Sure&quot;&gt; Not Sure &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_1_3&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_3&quot; value=&quot;Probably Not&quot;&gt; Probably Not &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_1_4&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_4&quot; value=&quot;Definitely Not&quot;&gt; Definitely Not &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;span id=&quot;radio_1&quot;&gt;&lt;/span&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Radio --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_2&quot;&gt;Would you use our product / service in the future?&lt;/label&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_2_0&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_0&quot; value=&quot;Less than a month&quot;&gt; Less than a month &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_2_1&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_1&quot; value=&quot;1-6 months&quot;&gt; 1-6 months &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_2_2&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_2&quot; value=&quot;1-3 years&quot;&gt; 1-3 years &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_2_3&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_3&quot; value=&quot;Over 3 Years&quot;&gt; Over 3 Years &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_2_4&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_4&quot; value=&quot;Never used&quot;&gt; Never used &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;span id=&quot;radio_2&quot;&gt;&lt;/span&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Radio --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_3&quot;&gt;How often do you use product / service?&lt;/label&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_3_0&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_0&quot; value=&quot;Once a week&quot;&gt; Once a week &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_3_1&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_1&quot; value=&quot;2 to 3 times a month&quot;&gt; 2 to 3 times a month &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_3_2&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_2&quot; value=&quot;Once a month&quot;&gt; Once a month &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_3_3&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_3&quot; value=&quot;Less than once a month&quot;&gt; Less than once a month &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;span id=&quot;radio_3&quot;&gt;&lt;/span&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Radio --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_4&quot;&gt;What aspect of the product / service were you most satisfied by?&lt;/label&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_4_0&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_4&quot; id=&quot;radio_4_0&quot; value=&quot;Quality&quot;&gt; Quality &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_4_1&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_4&quot; id=&quot;radio_4_1&quot; value=&quot;Price&quot;&gt; Price &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_4_2&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_4&quot; id=&quot;radio_4_2&quot; value=&quot;Purchase Experience&quot;&gt; Purchase Experience &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_4_3&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_4&quot; id=&quot;radio_4_3&quot; value=&quot;Installation or First Use Experience&quot;&gt; Installation or First Use Experience &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_4_4&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_4&quot; id=&quot;radio_4_4&quot; value=&quot;Usage Experience&quot;&gt; Usage Experience &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_4_5&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_4&quot; id=&quot;radio_4_5&quot; value=&quot;Customer Service&quot;&gt; Customer Service &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_4_6&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_4&quot; id=&quot;radio_4_6&quot; value=&quot;Repeat Purchase Experience&quot;&gt; Repeat Purchase Experience &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;span id=&quot;radio_4&quot;&gt;&lt;/span&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text Area --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;textarea_0&quot;&gt;What do you like about the product / service?&lt;/label&gt;\r\n    &lt;textarea id=&quot;textarea_0&quot; name=&quot;textarea_0&quot; rows=&quot;3&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text Area --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;textarea_1&quot;&gt;What do you dislike about the product / service?&lt;/label&gt;\r\n    &lt;textarea id=&quot;textarea_1&quot; name=&quot;textarea_1&quot; rows=&quot;3&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Radio --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_5&quot;&gt;Thinking of similar products / services offered by other companies, how would you compare the product / service offered by our company?&lt;/label&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_5_0&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_0&quot; value=&quot;Much Better&quot;&gt; Much Better &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_5_1&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_1&quot; value=&quot;Somewhat Better&quot;&gt; Somewhat Better &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_5_2&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_2&quot; value=&quot;About the Same&quot;&gt; About the Same &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_5_3&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_3&quot; value=&quot;Somewhat Worse&quot;&gt; Somewhat Worse &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_5_4&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_4&quot; value=&quot;Much Worse&quot;&gt; Much Worse &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_5_5&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_5&quot; value=&quot;Don&#039;t Know&quot;&gt; Don&#039;t Know &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;span id=&quot;radio_5&quot;&gt;&lt;/span&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Button --&gt;\r\n&lt;div class=&quot;form-action&quot;&gt;\r\n    &lt;input type=&quot;submit&quot; id=&quot;button_0&quot; name=&quot;button_0&quot; class=&quot;btn btn-primary&quot; value=&quot;Submit&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;/fieldset&gt;\r\n&lt;/form&gt;', 1, 'customer-satisfaction-survey', 1, 1, 1576184991, 1576184991);
INSERT INTO `template` VALUES (3, 1, 'Job Application Form', 'Easy way to apply online. Gather information and upload resume using the form.', '{\"settings\":{\"name\":\"Job Application Form\",\"canvas\":\"#canvas\",\"disabledFieldset\":false,\"layoutSelected\":\"\",\"layouts\":[{\"id\":\"\",\"name\":\"Vertical\"},{\"id\":\"form-horizontal\",\"name\":\"Horizontal\"},{\"id\":\"form-inline\",\"name\":\"Inline\"}],\"formSteps\":{\"title\":\"formSteps.title\",\"fields\":{\"id\":{\"label\":\"formSteps.id\",\"type\":\"input\",\"value\":\"formSteps\",\"name\":\"id\"},\"steps\":{\"label\":\"formSteps.steps\",\"type\":\"textarea-split\",\"value\":[],\"name\":\"steps\"},\"progressBar\":{\"label\":\"formSteps.progressBar\",\"type\":\"checkbox\",\"value\":false,\"name\":\"progressBar\"},\"noTitles\":{\"label\":\"formSteps.noTitles\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noTitles\"},\"noStages\":{\"label\":\"formSteps.noStages\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noStages\"},\"noSteps\":{\"label\":\"formSteps.noSteps\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noSteps\"}}}},\"initForm\":[{\"name\":\"heading\",\"title\":\"heading.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"heading_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"input\",\"value\":\"Product Manager\",\"name\":\"text\"},\"type\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"h1\",\"selected\":false,\"label\":\"H1\"},{\"value\":\"h2\",\"selected\":false,\"label\":\"H2\"},{\"value\":\"h3\",\"selected\":true,\"label\":\"H3\"},{\"value\":\"h4\",\"selected\":false,\"label\":\"H4\"},{\"value\":\"h5\",\"selected\":false,\"label\":\"H5\"},{\"value\":\"h6\",\"selected\":false,\"label\":\"H6\"}],\"name\":\"heading\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"legend\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"paragraph\",\"title\":\"paragraph.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"paragraph_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"textarea\",\"value\":\"\\u003Cstrong\\u003EWill you be our next Product Manager?\\u003C\\/strong\\u003E\",\"name\":\"text\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"snippet\",\"title\":\"snippet.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"snippet_0\",\"name\":\"id\"},\"snippet\":{\"label\":\"component.htmlCode\",\"type\":\"textarea\",\"value\":\"\\u003Cdiv style=\\u0022border:1px solid #DDD;padding:10px;overflow-y: scroll;height: 200px;margin-bottom:20px\\u0022\\u003E\\n    \\u003Cp\\u003E\\u003Cstrong\\u003EAre you...\\u003C\\/strong\\u003E\\u003C\\/p\\u003E\\n    \\u003Cul\\u003E\\n        \\u003Cli\\u003EFascinated by software products and how they can impact the lives of their users?\\u003C\\/li\\u003E\\n        \\u003Cli\\u003ESomeone who enjoys collaborating with customers, developers and marketers to develop a roadmap for a product?\\u003C\\/li\\u003E\\n        \\u003Cli\\u003EA person that enjoys being a vital part of an organization?\\u003C\\/li\\u003E\\n        \\u003Cli\\u003EA believer that great software can provide significant savings of time and money?\\u003C\\/li\\u003E\\n    \\u003C\\/ul\\u003E\\n    \\u003Cp\\u003EIf so, you should consider applying to become our next Product Manager.\\u003C\\/p\\u003E\\n    \\u003Cp\\u003EWe are looking for a high energy and fun person to add to our team.\\u003C\\/p\\u003E\\n    \\u003Cp\\u003EThey will have the opportunity to significantly direct and impact the development path of our web application and the future of our product.\\u003C\\/p\\u003E\\n    \\u003Cp\\u003E\\u003Cstrong\\u003EResponsibilities:\\u003C\\/strong\\u003E\\u003C\\/p\\u003E\\n    \\u003Cul\\u003E\\n        \\u003Cli\\u003EDefining new improvements for our web application, gathering requirements \\u0026 documenting designs\\u003C\\/li\\u003E\\n        \\u003Cli\\u003ECollect and interpret customer feedback and needs but realize the customer might not always know what they need\\u003C\\/li\\u003E\\n        \\u003Cli\\u003EUtilize a healthy amount of intuition but balance that with the appropriate amount of \\u0027data\\u0027 to back your decisions\\u003C\\/li\\u003E\\n        \\u003Cli\\u003EAbility to prioritize\\u003C\\/li\\u003E\\n        \\u003Cli\\u003EManage usability testing of new features to understand the \\u0022how\\u0022 and \\u0022why\\u0022 for people who use the software\\u003C\\/li\\u003E\\n        \\u003Cli\\u003EProject management, seeing all projects from start to finish, new software every week\\u003C\\/li\\u003E\\n        \\u003Cli\\u003ECollaborate with Marketing to define the strategies and define use cases\\u003C\\/li\\u003E\\n        \\u003Cli\\u003EWork with the Customer Experience Team to analyze customer feedback and feature requests\\u003C\\/li\\u003E\\n        \\u003Cli\\u003EInsure the end product is meeting the goals set in the beginning\\u003C\\/li\\u003E\\n    \\u003C\\/ul\\u003E\\n    \\u003Cp\\u003E\\u003Cstrong\\u003ESkills:\\u003C\\/strong\\u003E\\u003C\\/p\\u003E\\n    \\u003Cul\\u003E\\n        \\u003Cli\\u003EKnowledge of Web Applications, SaaS companies and more than 4 years of experience guiding product development\\u003C\\/li\\u003E\\n        \\u003Cli\\u003EA background or passion for user experience and design\\u003C\\/li\\u003E\\n        \\u003Cli\\u003ETechnical understanding of the limitations and possibilities within the Web Applications space\\u003C\\/li\\u003E\\n        \\u003Cli\\u003EHighly organized with demonstrated effective verbal and written communication skills\\u003C\\/li\\u003E\\n        \\u003Cli\\u003EAbility to act as a liaison between departments and maintain lines of communication\\u003C\\/li\\u003E\\n        \\u003Cli\\u003EGoal-oriented but able to make changes and pivots when necessary\\u003C\\/li\\u003E\\n    \\u003C\\/ul\\u003E\\n    \\u003Cp\\u003E*we are an Indianapolis-based company but accept applications for remote team members\\u003C\\/p\\u003E\\n\\u003C\\/div\\u003E\",\"name\":\"snippet\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_0\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Name\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_1\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Last Name\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"email\",\"title\":\"email.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"email_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Email\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"checkdns\":{\"label\":\"component.checkDNS\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"checkdns\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_2\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Address\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"How did you find out about this position?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"textarea-split\",\"value\":[\"Current Employee\",\"Career Fair\",\"Newspaper Ad\",\"Radio\\/TV Ad\",\"Search Engine\",\"Other\"],\"name\":\"radios\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"radio-inline\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_3\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"If other, please specify\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"file\",\"title\":\"file.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"file_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Upload your resume\",\"name\":\"label\"},\"accept\":{\"label\":\"component.accept\",\"type\":\"input\",\"value\":\".pdf, .docx, .doc\",\"name\":\"accept\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"minSize\":{\"label\":\"component.minSize\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minSize\"},\"maxSize\":{\"label\":\"component.maxSize\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"file\",\"title\":\"file.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"file_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Upload a cover letter\",\"name\":\"label\"},\"accept\":{\"label\":\"component.accept\",\"type\":\"input\",\"value\":\".pdf, .docx, .doc\",\"name\":\"accept\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"minSize\":{\"label\":\"component.minSize\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minSize\"},\"maxSize\":{\"label\":\"component.maxSize\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"textarea\",\"title\":\"textarea.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"textarea_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Additional info\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"fieldSize\":{\"label\":\"component.fieldSize\",\"type\":\"input\",\"value\":\"3\",\"advanced\":true,\"name\":\"fieldSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"button\",\"title\":\"button.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"button_0\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"submit\",\"label\":\"Submit\",\"selected\":true},{\"value\":\"reset\",\"label\":\"Reset\",\"selected\":false},{\"value\":\"image\",\"label\":\"Image\",\"selected\":false}],\"name\":\"inputType\"},\"buttonText\":{\"label\":\"component.buttonText\",\"type\":\"input\",\"value\":\"Submit\",\"name\":\"buttonText\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"label\"},\"src\":{\"label\":\"component.src\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"src\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"btn btn-primary\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false}],\"height\":1175}', '&lt;form id=&quot;form-app&quot; enctype=&quot;multipart/form-data&quot;&gt;\r\n&lt;fieldset&gt;\r\n\r\n&lt;!-- Heading --&gt;\r\n&lt;h3 class=&quot;legend&quot;&gt;Product Manager&lt;/h3&gt;\r\n\r\n&lt;!-- Paragraph Text --&gt;\r\n&lt;p&gt;&lt;strong&gt;Will you be our next Product Manager?&lt;/strong&gt;&lt;/p&gt;\r\n\r\n&lt;!-- Snippet --&gt;\r\n&lt;div class=&quot;snippet&quot;&gt;&lt;div style=&quot;border:1px solid #DDD;padding:10px;overflow-y: scroll;height: 200px;margin-bottom:20px&quot;&gt;\r\n    &lt;p&gt;&lt;strong&gt;Are you...&lt;/strong&gt;&lt;/p&gt;\r\n    &lt;ul&gt;\r\n        &lt;li&gt;Fascinated by software products and how they can impact the lives of their users?&lt;/li&gt;\r\n        &lt;li&gt;Someone who enjoys collaborating with customers, developers and marketers to develop a roadmap for a product?&lt;/li&gt;\r\n        &lt;li&gt;A person that enjoys being a vital part of an organization?&lt;/li&gt;\r\n        &lt;li&gt;A believer that great software can provide significant savings of time and money?&lt;/li&gt;\r\n    &lt;/ul&gt;\r\n    &lt;p&gt;If so, you should consider applying to become our next Product Manager.&lt;/p&gt;\r\n    &lt;p&gt;We are looking for a high energy and fun person to add to our team.&lt;/p&gt;\r\n    &lt;p&gt;They will have the opportunity to significantly direct and impact the development path of our web application and the future of our product.&lt;/p&gt;\r\n    &lt;p&gt;&lt;strong&gt;Responsibilities:&lt;/strong&gt;&lt;/p&gt;\r\n    &lt;ul&gt;\r\n        &lt;li&gt;Defining new improvements for our web application, gathering requirements &amp;amp; documenting designs&lt;/li&gt;\r\n        &lt;li&gt;Collect and interpret customer feedback and needs but realize the customer might not always know what they need&lt;/li&gt;\r\n        &lt;li&gt;Utilize a healthy amount of intuition but balance that with the appropriate amount of &#039;data&#039; to back your decisions&lt;/li&gt;\r\n        &lt;li&gt;Ability to prioritize&lt;/li&gt;\r\n        &lt;li&gt;Manage usability testing of new features to understand the &quot;how&quot; and &quot;why&quot; for people who use the software&lt;/li&gt;\r\n        &lt;li&gt;Project management, seeing all projects from start to finish, new software every week&lt;/li&gt;\r\n        &lt;li&gt;Collaborate with Marketing to define the strategies and define use cases&lt;/li&gt;\r\n        &lt;li&gt;Work with the Customer Experience Team to analyze customer feedback and feature requests&lt;/li&gt;\r\n        &lt;li&gt;Insure the end product is meeting the goals set in the beginning&lt;/li&gt;\r\n    &lt;/ul&gt;\r\n    &lt;p&gt;&lt;strong&gt;Skills:&lt;/strong&gt;&lt;/p&gt;\r\n    &lt;ul&gt;\r\n        &lt;li&gt;Knowledge of Web Applications, SaaS companies and more than 4 years of experience guiding product development&lt;/li&gt;\r\n        &lt;li&gt;A background or passion for user experience and design&lt;/li&gt;\r\n        &lt;li&gt;Technical understanding of the limitations and possibilities within the Web Applications space&lt;/li&gt;\r\n        &lt;li&gt;Highly organized with demonstrated effective verbal and written communication skills&lt;/li&gt;\r\n        &lt;li&gt;Ability to act as a liaison between departments and maintain lines of communication&lt;/li&gt;\r\n        &lt;li&gt;Goal-oriented but able to make changes and pivots when necessary&lt;/li&gt;\r\n    &lt;/ul&gt;\r\n    &lt;p&gt;*we are an Indianapolis-based company but accept applications for remote team members&lt;/p&gt;\r\n&lt;/div&gt;&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group required-control&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_0&quot;&gt;Name&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_0&quot; name=&quot;text_0&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group required-control&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_1&quot;&gt;Last Name&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_1&quot; name=&quot;text_1&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Email --&gt;\r\n&lt;div class=&quot;form-group required-control&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;email_0&quot;&gt;Email&lt;/label&gt;\r\n    &lt;input type=&quot;email&quot; id=&quot;email_0&quot; name=&quot;email_0&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group required-control&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_2&quot;&gt;Address&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_2&quot; name=&quot;text_2&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Radio --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_0&quot;&gt;How did you find out about this position?&lt;/label&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_0_0&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_0&quot; value=&quot;Current Employee&quot;&gt; Current Employee &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_0_1&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_1&quot; value=&quot;Career Fair&quot;&gt; Career Fair &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_0_2&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_2&quot; value=&quot;Newspaper Ad&quot;&gt; Newspaper Ad &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_0_3&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_3&quot; value=&quot;Radio/TV Ad&quot;&gt; Radio/TV Ad &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_0_4&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_4&quot; value=&quot;Search Engine&quot;&gt; Search Engine &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_0_5&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_5&quot; value=&quot;Other&quot;&gt; Other &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;span id=&quot;radio_0&quot;&gt;&lt;/span&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_3&quot;&gt;If other, please specify&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_3&quot; name=&quot;text_3&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- File --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;file_0&quot;&gt;Upload your resume&lt;/label&gt;\r\n    &lt;input type=&quot;file&quot; id=&quot;file_0&quot; name=&quot;file_0&quot; accept=&quot;.pdf, .docx, .doc&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- File --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;file_1&quot;&gt;Upload a cover letter&lt;/label&gt;\r\n    &lt;input type=&quot;file&quot; id=&quot;file_1&quot; name=&quot;file_1&quot; accept=&quot;.pdf, .docx, .doc&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text Area --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;textarea_0&quot;&gt;Additional info&lt;/label&gt;\r\n    &lt;textarea id=&quot;textarea_0&quot; name=&quot;textarea_0&quot; rows=&quot;3&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Button --&gt;\r\n&lt;div class=&quot;form-action&quot;&gt;\r\n    &lt;input type=&quot;submit&quot; id=&quot;button_0&quot; name=&quot;button_0&quot; class=&quot;btn btn-primary&quot; value=&quot;Submit&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;/fieldset&gt;\r\n&lt;/form&gt;', 1, 'job-application-form', 1, 1, 1576184991, 1576184991);
INSERT INTO `template` VALUES (4, 7, 'Bug Tracker', 'Do you need to track bugs for an IT department or a group of developers? With this form, you can collect and track the information you need to quickly and effectively intake clients. ', '{\"settings\":{\"name\":\"Bug Tracker\",\"canvas\":\"#canvas\",\"disabledFieldset\":false,\"layoutSelected\":\"\",\"layouts\":[{\"id\":\"\",\"name\":\"Vertical\"},{\"id\":\"form-horizontal\",\"name\":\"Horizontal\"},{\"id\":\"form-inline\",\"name\":\"Inline\"}],\"formSteps\":{\"title\":\"formSteps.title\",\"fields\":{\"id\":{\"label\":\"formSteps.id\",\"type\":\"input\",\"value\":\"formSteps\",\"name\":\"id\"},\"steps\":{\"label\":\"formSteps.steps\",\"type\":\"textarea-split\",\"value\":[],\"name\":\"steps\"},\"progressBar\":{\"label\":\"formSteps.progressBar\",\"type\":\"checkbox\",\"value\":false,\"name\":\"progressBar\"},\"noTitles\":{\"label\":\"formSteps.noTitles\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noTitles\"},\"noStages\":{\"label\":\"formSteps.noStages\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noStages\"},\"noSteps\":{\"label\":\"formSteps.noSteps\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noSteps\"}}}},\"initForm\":[{\"name\":\"heading\",\"title\":\"heading.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"heading_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"input\",\"value\":\"Bug Tracker\",\"name\":\"text\"},\"type\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"h1\",\"selected\":false,\"label\":\"H1\"},{\"value\":\"h2\",\"selected\":false,\"label\":\"H2\"},{\"value\":\"h3\",\"selected\":true,\"label\":\"H3\"},{\"value\":\"h4\",\"selected\":false,\"label\":\"H4\"},{\"value\":\"h5\",\"selected\":false,\"label\":\"H5\"},{\"value\":\"h6\",\"selected\":false,\"label\":\"H6\"}],\"name\":\"heading\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"legend\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"paragraph\",\"title\":\"paragraph.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"paragraph_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"textarea\",\"value\":\"Report all bugs!\",\"name\":\"text\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_0\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Bug Title\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"textarea\",\"title\":\"textarea.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"textarea_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Issue Description\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"fieldSize\":{\"label\":\"component.fieldSize\",\"type\":\"input\",\"value\":\"3\",\"advanced\":true,\"name\":\"fieldSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"selectlist\",\"title\":\"selectlist.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"selectlist_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Operating System\",\"name\":\"label\"},\"options\":{\"label\":\"component.options\",\"type\":\"textarea-split\",\"value\":[\"Windows XP\",\"Windows Vista\",\"Mac OS X\",\"Linux\",\"Other\"],\"name\":\"options\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"-Select-\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-6\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"selectlist\",\"title\":\"selectlist.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"selectlist_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Browser\",\"name\":\"label\"},\"options\":{\"label\":\"component.options\",\"type\":\"textarea-split\",\"value\":[\"Internet Explorer\",\"Chrome\",\"Firefox\",\"Safari\",\"Opera\",\"Other\"],\"name\":\"options\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"-Select-\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-6\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"selectlist\",\"title\":\"selectlist.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"selectlist_3\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Assign To\",\"name\":\"label\"},\"options\":{\"label\":\"component.options\",\"type\":\"textarea-split\",\"value\":[\"Team Member #1\",\"Team Member #2\",\"Team Member #3\"],\"name\":\"options\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"-Select-\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-9\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"selectlist\",\"title\":\"selectlist.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"selectlist_8\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Priority\",\"name\":\"label\"},\"options\":{\"label\":\"component.options\",\"type\":\"textarea-split\",\"value\":[\"Low\",\"Medium\",\"High\"],\"name\":\"options\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"-Select-\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-3\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"file\",\"title\":\"file.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"file_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Upload a Screenshot\",\"name\":\"label\"},\"accept\":{\"label\":\"component.accept\",\"type\":\"input\",\"value\":\".gif, .jpg, .png\",\"name\":\"accept\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"minSize\":{\"label\":\"component.minSize\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minSize\"},\"maxSize\":{\"label\":\"component.maxSize\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"selectlist\",\"title\":\"selectlist.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"selectlist_9\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Status\",\"name\":\"label\"},\"options\":{\"label\":\"component.options\",\"type\":\"textarea-split\",\"value\":[\"New\",\"Acknowledged\",\"Confirmed\",\"Assigned\",\"Resolved\",\"Closed\"],\"name\":\"options\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"-Select-\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"button\",\"title\":\"button.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"button_0\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"submit\",\"label\":\"Submit\",\"selected\":true},{\"value\":\"reset\",\"label\":\"Reset\",\"selected\":false},{\"value\":\"image\",\"label\":\"Image\",\"selected\":false}],\"name\":\"inputType\"},\"buttonText\":{\"label\":\"component.buttonText\",\"type\":\"input\",\"value\":\"Submit\",\"name\":\"buttonText\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"label\"},\"src\":{\"label\":\"component.src\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"src\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"btn btn-primary\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false}],\"height\":600}', '&lt;form id=&quot;form-app&quot; enctype=&quot;multipart/form-data&quot;&gt;\r\n&lt;fieldset&gt;\r\n\r\n&lt;!-- Heading --&gt;\r\n&lt;h3 class=&quot;legend&quot;&gt;Bug Tracker&lt;/h3&gt;\r\n\r\n&lt;!-- Paragraph Text --&gt;\r\n&lt;p&gt;Report all bugs!&lt;/p&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group required-control&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_0&quot;&gt;Bug Title&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_0&quot; name=&quot;text_0&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text Area --&gt;\r\n&lt;div class=&quot;form-group required-control&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;textarea_0&quot;&gt;Issue Description&lt;/label&gt;\r\n    &lt;textarea id=&quot;textarea_0&quot; name=&quot;textarea_0&quot; rows=&quot;3&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;&lt;/textarea&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Select List --&gt;\r\n&lt;div class=&quot;form-group required-control col-xs-6&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_0&quot;&gt;Operating System&lt;/label&gt;\r\n    &lt;select id=&quot;selectlist_0&quot; name=&quot;selectlist_0[]&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\r\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\r\n        &lt;option value=&quot;Windows XP&quot;&gt;Windows XP&lt;/option&gt;\r\n        &lt;option value=&quot;Windows Vista&quot;&gt;Windows Vista&lt;/option&gt;\r\n        &lt;option value=&quot;Mac OS X&quot;&gt;Mac OS X&lt;/option&gt;\r\n        &lt;option value=&quot;Linux&quot;&gt;Linux&lt;/option&gt;\r\n        &lt;option value=&quot;Other&quot;&gt;Other&lt;/option&gt;\r\n    &lt;/select&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Select List --&gt;\r\n&lt;div class=&quot;form-group required-control col-xs-6&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_1&quot;&gt;Browser&lt;/label&gt;\r\n    &lt;select id=&quot;selectlist_1&quot; name=&quot;selectlist_1[]&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\r\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\r\n        &lt;option value=&quot;Internet Explorer&quot;&gt;Internet Explorer&lt;/option&gt;\r\n        &lt;option value=&quot;Chrome&quot;&gt;Chrome&lt;/option&gt;\r\n        &lt;option value=&quot;Firefox&quot;&gt;Firefox&lt;/option&gt;\r\n        &lt;option value=&quot;Safari&quot;&gt;Safari&lt;/option&gt;\r\n        &lt;option value=&quot;Opera&quot;&gt;Opera&lt;/option&gt;\r\n        &lt;option value=&quot;Other&quot;&gt;Other&lt;/option&gt;\r\n    &lt;/select&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Select List --&gt;\r\n&lt;div class=&quot;form-group required-control col-xs-9&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_3&quot;&gt;Assign To&lt;/label&gt;\r\n    &lt;select id=&quot;selectlist_3&quot; name=&quot;selectlist_3[]&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\r\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\r\n        &lt;option value=&quot;Team Member #1&quot;&gt;Team Member #1&lt;/option&gt;\r\n        &lt;option value=&quot;Team Member #2&quot;&gt;Team Member #2&lt;/option&gt;\r\n        &lt;option value=&quot;Team Member #3&quot;&gt;Team Member #3&lt;/option&gt;\r\n    &lt;/select&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Select List --&gt;\r\n&lt;div class=&quot;form-group required-control col-xs-3&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_8&quot;&gt;Priority&lt;/label&gt;\r\n    &lt;select id=&quot;selectlist_8&quot; name=&quot;selectlist_8[]&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\r\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\r\n        &lt;option value=&quot;Low&quot;&gt;Low&lt;/option&gt;\r\n        &lt;option value=&quot;Medium&quot;&gt;Medium&lt;/option&gt;\r\n        &lt;option value=&quot;High&quot;&gt;High&lt;/option&gt;\r\n    &lt;/select&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- File --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;file_0&quot;&gt;Upload a Screenshot&lt;/label&gt;\r\n    &lt;input type=&quot;file&quot; id=&quot;file_0&quot; name=&quot;file_0&quot; accept=&quot;.gif, .jpg, .png&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Select List --&gt;\r\n&lt;div class=&quot;form-group required-control&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_9&quot;&gt;Status&lt;/label&gt;\r\n    &lt;select id=&quot;selectlist_9&quot; name=&quot;selectlist_9[]&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\r\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\r\n        &lt;option value=&quot;New&quot;&gt;New&lt;/option&gt;\r\n        &lt;option value=&quot;Acknowledged&quot;&gt;Acknowledged&lt;/option&gt;\r\n        &lt;option value=&quot;Confirmed&quot;&gt;Confirmed&lt;/option&gt;\r\n        &lt;option value=&quot;Assigned&quot;&gt;Assigned&lt;/option&gt;\r\n        &lt;option value=&quot;Resolved&quot;&gt;Resolved&lt;/option&gt;\r\n        &lt;option value=&quot;Closed&quot;&gt;Closed&lt;/option&gt;\r\n    &lt;/select&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Button --&gt;\r\n&lt;div class=&quot;form-action&quot;&gt;\r\n    &lt;input type=&quot;submit&quot; id=&quot;button_0&quot; name=&quot;button_0&quot; class=&quot;btn btn-primary&quot; value=&quot;Submit&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;/fieldset&gt;\r\n&lt;/form&gt;', 0, 'bug-tracker', 1, 1, 1576184991, 1576184991);
INSERT INTO `template` VALUES (5, 6, 'Event Planner', 'Be it work or play, it is best planned well in advance. Here is an online form to bookmark upcoming events and to verify the checklist of to-do\'s. With this, you can be sure not to have left behind anything that adds to the fun.', '{\"settings\":{\"name\":\"Event Planner\",\"canvas\":\"#canvas\",\"disabledFieldset\":false,\"layoutSelected\":\"\",\"layouts\":[{\"id\":\"\",\"name\":\"Vertical\"},{\"id\":\"form-horizontal\",\"name\":\"Horizontal\"},{\"id\":\"form-inline\",\"name\":\"Inline\"}],\"formSteps\":{\"title\":\"formSteps.title\",\"fields\":{\"id\":{\"label\":\"formSteps.id\",\"type\":\"input\",\"value\":\"formSteps\",\"name\":\"id\"},\"steps\":{\"label\":\"formSteps.steps\",\"type\":\"textarea-split\",\"value\":[],\"name\":\"steps\"},\"progressBar\":{\"label\":\"formSteps.progressBar\",\"type\":\"checkbox\",\"value\":false,\"name\":\"progressBar\"},\"noTitles\":{\"label\":\"formSteps.noTitles\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noTitles\"},\"noStages\":{\"label\":\"formSteps.noStages\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noStages\"},\"noSteps\":{\"label\":\"formSteps.noSteps\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noSteps\"}}}},\"initForm\":[{\"name\":\"heading\",\"title\":\"heading.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"heading_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"input\",\"value\":\"Event Planner\",\"name\":\"text\"},\"type\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"h1\",\"selected\":false,\"label\":\"H1\"},{\"value\":\"h2\",\"selected\":false,\"label\":\"H2\"},{\"value\":\"h3\",\"selected\":true,\"label\":\"H3\"},{\"value\":\"h4\",\"selected\":false,\"label\":\"H4\"},{\"value\":\"h5\",\"selected\":false,\"label\":\"H5\"},{\"value\":\"h6\",\"selected\":false,\"label\":\"H6\"}],\"name\":\"heading\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"legend\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_0\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Event Name\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_1\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Event Coordinator\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"email\",\"title\":\"email.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"email_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Email\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"checkdns\":{\"label\":\"component.checkDNS\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"checkdns\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"selectlist\",\"title\":\"selectlist.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"selectlist_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Event Type\",\"name\":\"label\"},\"options\":{\"label\":\"component.options\",\"type\":\"textarea-split\",\"value\":[\"Banquet\",\"Dinner Party\",\"Wedding\"],\"name\":\"options\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"-Select-\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-6\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"selectlist\",\"title\":\"selectlist.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"selectlist_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Status\",\"name\":\"label\"},\"options\":{\"label\":\"component.options\",\"type\":\"textarea-split\",\"value\":[\"Planning\",\"In Progress\",\"Finished\"],\"name\":\"options\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"-Select-\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-6\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"textarea\",\"title\":\"textarea.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"textarea_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Event Description\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"fieldSize\":{\"label\":\"component.fieldSize\",\"type\":\"input\",\"value\":\"3\",\"advanced\":true,\"name\":\"fieldSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Does your program involve any type of outside activity?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"textarea-split\",\"value\":[\"Yes\",\"No\"],\"name\":\"radios\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"radio-inline\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"number\",\"title\":\"number.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"number_0\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"number\",\"selected\":true,\"label\":\"Number\"},{\"value\":\"range\",\"selected\":false,\"label\":\"Range\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Cost Per Person ($)\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"integerOnly\":{\"label\":\"component.integerOnly\",\"type\":\"checkbox\",\"value\":false,\"name\":\"integerOnly\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"min\":{\"label\":\"component.minNumber\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"min\"},\"max\":{\"label\":\"component.maxNumber\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"max\"},\"step\":{\"label\":\"component.stepNumber\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"step\"},\"integerPattern\":{\"label\":\"component.integerPattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"integerPattern\"},\"numberPattern\":{\"label\":\"component.numberPattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"numberPattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"checkbox\",\"title\":\"checkbox.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"checkbox_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Requirements\",\"name\":\"label\"},\"checkboxes\":{\"label\":\"component.checkboxes\",\"type\":\"textarea-split\",\"value\":[\"Staffing\",\"Catering\",\"Security\"],\"name\":\"checkboxes\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"checkbox-inline\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"date\",\"title\":\"date.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"date_0\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"date\",\"selected\":false,\"label\":\"Date\"},{\"value\":\"datetime-local\",\"selected\":true,\"label\":\"DateTime-Local\"},{\"value\":\"time\",\"selected\":false,\"label\":\"Time\"},{\"value\":\"month\",\"selected\":false,\"label\":\"Month\"},{\"value\":\"week\",\"selected\":false,\"label\":\"Week\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Event Start Date\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"min\":{\"label\":\"component.minDate\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"min\"},\"max\":{\"label\":\"component.maxDate\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"max\"},\"step\":{\"label\":\"component.stepNumber\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"step\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-6\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"date\",\"title\":\"date.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"date_1\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"date\",\"selected\":false,\"label\":\"Date\"},{\"value\":\"datetime-local\",\"selected\":true,\"label\":\"DateTime-Local\"},{\"value\":\"time\",\"selected\":false,\"label\":\"Time\"},{\"value\":\"month\",\"selected\":false,\"label\":\"Month\"},{\"value\":\"week\",\"selected\":false,\"label\":\"Week\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Event End Date\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"min\":{\"label\":\"component.minDate\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"min\"},\"max\":{\"label\":\"component.maxDate\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"max\"},\"step\":{\"label\":\"component.stepNumber\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"step\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-6\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"textarea\",\"title\":\"textarea.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"textarea_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Location\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"fieldSize\":{\"label\":\"component.fieldSize\",\"type\":\"input\",\"value\":\"3\",\"advanced\":true,\"name\":\"fieldSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_2\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"City\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-4\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_3\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"State\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-4\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"selectlist\",\"title\":\"selectlist.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"selectlist_2\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Country\",\"name\":\"label\"},\"options\":{\"label\":\"component.options\",\"type\":\"textarea-split\",\"value\":[\"United States\",\"United Kingdom\",\"Australia\",\"Canada\",\"France\",\"----\",\"Afghanistan\",\"Albania\",\"Algeria\",\"Andorra\",\"Angola\",\"Antigua \\u0026 Deps\",\"Argentina\",\"Armenia\",\"Austria\",\"Azerbaijan\",\"Bahamas\",\"Bahrain\",\"Bangladesh\",\"Barbados\",\"Belarus\",\"Belgium\",\"Belize\",\"Benin\",\"Bhutan\",\"Bolivia\",\"Bosnia Herzegovina\",\"Botswana\",\"Brazil\",\"Brunei\",\"Bulgaria\",\"Burkina\",\"Burundi\",\"Cambodia\",\"Cameroon\",\"Cape Verde\",\"Central African Rep\",\"Chad\",\"Chile\",\"China\",\"Colombia\",\"Comoros\",\"Congo\",\"Congo {Democratic Rep}\",\"Costa Rica\",\"Croatia\",\"Cuba\",\"Cyprus\",\"Czech Republic\",\"Denmark\",\"Djibouti\",\"Dominica\",\"Dominican Republic\",\"East Timor\",\"Ecuador\",\"Egypt\",\"El Salvador\",\"Equatorial Guinea\",\"Eritrea\",\"Estonia\",\"Ethiopia\",\"Fiji\",\"Finland\",\"Gabon\",\"Gambia\",\"Georgia\",\"Germany\",\"Ghana\",\"Greece\",\"Grenada\",\"Guatemala\",\"Guinea\",\"Guinea-Bissau\",\"Guyana\",\"Haiti\",\"Honduras\",\"Hungary\",\"Iceland\",\"India\",\"Indonesia\",\"Iran\",\"Iraq\",\"Ireland {Republic}\",\"Israel\",\"Italy\",\"Ivory Coast\",\"Jamaica\",\"Japan\",\"Jordan\",\"Kazakhstan\",\"Kenya\",\"Kiribati\",\"Korea North\",\"Korea South\",\"Kosovo\",\"Kuwait\",\"Kyrgyzstan\",\"Laos\",\"Latvia\",\"Lebanon\",\"Lesotho\",\"Liberia\",\"Libya\",\"Liechtenstein\",\"Lithuania\",\"Luxembourg\",\"Macedonia\",\"Madagascar\",\"Malawi\",\"Malaysia\",\"Maldives\",\"Mali\",\"Malta\",\"Marshall Islands\",\"Mauritania\",\"Mauritius\",\"Mexico\",\"Micronesia\",\"Moldova\",\"Monaco\",\"Mongolia\",\"Montenegro\",\"Morocco\",\"Mozambique\",\"Myanmar, {Burma}\",\"Namibia\",\"Nauru\",\"Nepal\",\"Netherlands\",\"New Zealand\",\"Nicaragua\",\"Niger\",\"Nigeria\",\"Norway\",\"Oman\",\"Pakistan\",\"Palau\",\"Panama\",\"Papua New Guinea\",\"Paraguay\",\"Peru\",\"Philippines\",\"Poland\",\"Portugal\",\"Qatar\",\"Romania\",\"Russian Federation\",\"Rwanda\",\"St Kitts \\u0026 Nevis\",\"St Lucia\",\"Saint Vincent \\u0026 the Grenadines\",\"Samoa\",\"San Marino\",\"Sao Tome \\u0026 Principe\",\"Saudi Arabia\",\"Senegal\",\"Serbia\",\"Seychelles\",\"Sierra Leone\",\"Singapore\",\"Slovakia\",\"Slovenia\",\"Solomon Islands\",\"Somalia\",\"South Africa\",\"South Sudan\",\"Spain\",\"Sri Lanka\",\"Sudan\",\"Suriname\",\"Swaziland\",\"Sweden\",\"Switzerland\",\"Syria\",\"Taiwan\",\"Tajikistan\",\"Tanzania\",\"Thailand\",\"Togo\",\"Tonga\",\"Trinidad \\u0026 Tobago\",\"Tunisia\",\"Turkey\",\"Turkmenistan\",\"Tuvalu\",\"Uganda\",\"Ukraine\",\"United Arab Emirates\",\"Uruguay\",\"Uzbekistan\",\"Vanuatu\",\"Vatican City\",\"Venezuela\",\"Vietnam\",\"Yemen\",\"Zambia\",\"Zimbabwe\"],\"name\":\"options\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"-Select-\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-4\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"file\",\"title\":\"file.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"file_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Attach Detailed Itinerary\",\"name\":\"label\"},\"accept\":{\"label\":\"component.accept\",\"type\":\"input\",\"value\":\".txt, .pdf, .doc, .docx\",\"name\":\"accept\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"minSize\":{\"label\":\"component.minSize\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minSize\"},\"maxSize\":{\"label\":\"component.maxSize\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"button\",\"title\":\"button.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"button_0\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"submit\",\"label\":\"Submit\",\"selected\":true},{\"value\":\"reset\",\"label\":\"Reset\",\"selected\":false},{\"value\":\"image\",\"label\":\"Image\",\"selected\":false}],\"name\":\"inputType\"},\"buttonText\":{\"label\":\"component.buttonText\",\"type\":\"input\",\"value\":\"Submit\",\"name\":\"buttonText\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"label\"},\"src\":{\"label\":\"component.src\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"src\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"btn btn-primary\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false}],\"height\":1126}', '&lt;form id=&quot;form-app&quot; enctype=&quot;multipart/form-data&quot;&gt;\r\n&lt;fieldset&gt;\r\n\r\n&lt;!-- Heading --&gt;\r\n&lt;h3 class=&quot;legend&quot;&gt;Event Planner&lt;/h3&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_0&quot;&gt;Event Name&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_0&quot; name=&quot;text_0&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_1&quot;&gt;Event Coordinator&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_1&quot; name=&quot;text_1&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Email --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;email_0&quot;&gt;Email&lt;/label&gt;\r\n    &lt;input type=&quot;email&quot; id=&quot;email_0&quot; name=&quot;email_0&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Select List --&gt;\r\n&lt;div class=&quot;form-group col-xs-6&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_0&quot;&gt;Event Type&lt;/label&gt;\r\n    &lt;select id=&quot;selectlist_0&quot; name=&quot;selectlist_0[]&quot; class=&quot;form-control&quot;&gt;\r\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\r\n        &lt;option value=&quot;Banquet&quot;&gt;Banquet&lt;/option&gt;\r\n        &lt;option value=&quot;Dinner Party&quot;&gt;Dinner Party&lt;/option&gt;\r\n        &lt;option value=&quot;Wedding&quot;&gt;Wedding&lt;/option&gt;\r\n    &lt;/select&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Select List --&gt;\r\n&lt;div class=&quot;form-group col-xs-6&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_1&quot;&gt;Status&lt;/label&gt;\r\n    &lt;select id=&quot;selectlist_1&quot; name=&quot;selectlist_1[]&quot; class=&quot;form-control&quot;&gt;\r\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\r\n        &lt;option value=&quot;Planning&quot;&gt;Planning&lt;/option&gt;\r\n        &lt;option value=&quot;In Progress&quot;&gt;In Progress&lt;/option&gt;\r\n        &lt;option value=&quot;Finished&quot;&gt;Finished&lt;/option&gt;\r\n    &lt;/select&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text Area --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;textarea_0&quot;&gt;Event Description&lt;/label&gt;\r\n    &lt;textarea id=&quot;textarea_0&quot; name=&quot;textarea_0&quot; rows=&quot;3&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Radio --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_0&quot;&gt;Does your program involve any type of outside activity?&lt;/label&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_0_0&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_0&quot; value=&quot;Yes&quot;&gt; Yes &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_0_1&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_1&quot; value=&quot;No&quot;&gt; No &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;span id=&quot;radio_0&quot;&gt;&lt;/span&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Number --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;number_0&quot;&gt;Cost Per Person ($)&lt;/label&gt;\r\n    &lt;input type=&quot;number&quot; id=&quot;number_0&quot; name=&quot;number_0&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Checkbox --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;checkbox_0&quot;&gt;Requirements&lt;/label&gt;\r\n        &lt;div class=&quot;checkbox&quot;&gt;\r\n            &lt;label for=&quot;checkbox_0_0&quot; class=&quot;checkbox-inline&quot;&gt;\r\n            &lt;input type=&quot;checkbox&quot; name=&quot;checkbox_0[]&quot; id=&quot;checkbox_0_0&quot; value=&quot;Staffing&quot;&gt; Staffing &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;checkbox&quot;&gt;\r\n            &lt;label for=&quot;checkbox_0_1&quot; class=&quot;checkbox-inline&quot;&gt;\r\n            &lt;input type=&quot;checkbox&quot; name=&quot;checkbox_0[]&quot; id=&quot;checkbox_0_1&quot; value=&quot;Catering&quot;&gt; Catering &lt;/label&gt;\r\n        &lt;/div&gt;\r\n        &lt;div class=&quot;checkbox&quot;&gt;\r\n            &lt;label for=&quot;checkbox_0_2&quot; class=&quot;checkbox-inline&quot;&gt;\r\n            &lt;input type=&quot;checkbox&quot; name=&quot;checkbox_0[]&quot; id=&quot;checkbox_0_2&quot; value=&quot;Security&quot;&gt; Security &lt;/label&gt;\r\n        &lt;/div&gt;\r\n    &lt;span id=&quot;checkbox_0&quot;&gt;&lt;/span&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Date --&gt;\r\n&lt;div class=&quot;form-group col-xs-6&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;date_0&quot;&gt;Event Start Date&lt;/label&gt;\r\n    &lt;input type=&quot;datetime-local&quot; id=&quot;date_0&quot; name=&quot;date_0&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Date --&gt;\r\n&lt;div class=&quot;form-group col-xs-6&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;date_1&quot;&gt;Event End Date&lt;/label&gt;\r\n    &lt;input type=&quot;datetime-local&quot; id=&quot;date_1&quot; name=&quot;date_1&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text Area --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;textarea_1&quot;&gt;Location&lt;/label&gt;\r\n    &lt;textarea id=&quot;textarea_1&quot; name=&quot;textarea_1&quot; rows=&quot;3&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group col-xs-4&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_2&quot;&gt;City&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_2&quot; name=&quot;text_2&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group col-xs-4&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_3&quot;&gt;State&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_3&quot; name=&quot;text_3&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Select List --&gt;\r\n&lt;div class=&quot;form-group col-xs-4&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_2&quot;&gt;Country&lt;/label&gt;\r\n    &lt;select id=&quot;selectlist_2&quot; name=&quot;selectlist_2[]&quot; class=&quot;form-control&quot;&gt;\r\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\r\n        &lt;option value=&quot;United States&quot;&gt;United States&lt;/option&gt;\r\n        &lt;option value=&quot;United Kingdom&quot;&gt;United Kingdom&lt;/option&gt;\r\n        &lt;option value=&quot;Australia&quot;&gt;Australia&lt;/option&gt;\r\n        &lt;option value=&quot;Canada&quot;&gt;Canada&lt;/option&gt;\r\n        &lt;option value=&quot;France&quot;&gt;France&lt;/option&gt;\r\n        &lt;option value=&quot;----&quot;&gt;----&lt;/option&gt;\r\n        &lt;option value=&quot;Afghanistan&quot;&gt;Afghanistan&lt;/option&gt;\r\n        &lt;option value=&quot;Albania&quot;&gt;Albania&lt;/option&gt;\r\n        &lt;option value=&quot;Algeria&quot;&gt;Algeria&lt;/option&gt;\r\n        &lt;option value=&quot;Andorra&quot;&gt;Andorra&lt;/option&gt;\r\n        &lt;option value=&quot;Angola&quot;&gt;Angola&lt;/option&gt;\r\n        &lt;option value=&quot;Antigua &amp;amp; Deps&quot;&gt;Antigua &amp;amp; Deps&lt;/option&gt;\r\n        &lt;option value=&quot;Argentina&quot;&gt;Argentina&lt;/option&gt;\r\n        &lt;option value=&quot;Armenia&quot;&gt;Armenia&lt;/option&gt;\r\n        &lt;option value=&quot;Austria&quot;&gt;Austria&lt;/option&gt;\r\n        &lt;option value=&quot;Azerbaijan&quot;&gt;Azerbaijan&lt;/option&gt;\r\n        &lt;option value=&quot;Bahamas&quot;&gt;Bahamas&lt;/option&gt;\r\n        &lt;option value=&quot;Bahrain&quot;&gt;Bahrain&lt;/option&gt;\r\n        &lt;option value=&quot;Bangladesh&quot;&gt;Bangladesh&lt;/option&gt;\r\n        &lt;option value=&quot;Barbados&quot;&gt;Barbados&lt;/option&gt;\r\n        &lt;option value=&quot;Belarus&quot;&gt;Belarus&lt;/option&gt;\r\n        &lt;option value=&quot;Belgium&quot;&gt;Belgium&lt;/option&gt;\r\n        &lt;option value=&quot;Belize&quot;&gt;Belize&lt;/option&gt;\r\n        &lt;option value=&quot;Benin&quot;&gt;Benin&lt;/option&gt;\r\n        &lt;option value=&quot;Bhutan&quot;&gt;Bhutan&lt;/option&gt;\r\n        &lt;option value=&quot;Bolivia&quot;&gt;Bolivia&lt;/option&gt;\r\n        &lt;option value=&quot;Bosnia Herzegovina&quot;&gt;Bosnia Herzegovina&lt;/option&gt;\r\n        &lt;option value=&quot;Botswana&quot;&gt;Botswana&lt;/option&gt;\r\n        &lt;option value=&quot;Brazil&quot;&gt;Brazil&lt;/option&gt;\r\n        &lt;option value=&quot;Brunei&quot;&gt;Brunei&lt;/option&gt;\r\n        &lt;option value=&quot;Bulgaria&quot;&gt;Bulgaria&lt;/option&gt;\r\n        &lt;option value=&quot;Burkina&quot;&gt;Burkina&lt;/option&gt;\r\n        &lt;option value=&quot;Burundi&quot;&gt;Burundi&lt;/option&gt;\r\n        &lt;option value=&quot;Cambodia&quot;&gt;Cambodia&lt;/option&gt;\r\n        &lt;option value=&quot;Cameroon&quot;&gt;Cameroon&lt;/option&gt;\r\n        &lt;option value=&quot;Cape Verde&quot;&gt;Cape Verde&lt;/option&gt;\r\n        &lt;option value=&quot;Central African Rep&quot;&gt;Central African Rep&lt;/option&gt;\r\n        &lt;option value=&quot;Chad&quot;&gt;Chad&lt;/option&gt;\r\n        &lt;option value=&quot;Chile&quot;&gt;Chile&lt;/option&gt;\r\n        &lt;option value=&quot;China&quot;&gt;China&lt;/option&gt;\r\n        &lt;option value=&quot;Colombia&quot;&gt;Colombia&lt;/option&gt;\r\n        &lt;option value=&quot;Comoros&quot;&gt;Comoros&lt;/option&gt;\r\n        &lt;option value=&quot;Congo&quot;&gt;Congo&lt;/option&gt;\r\n        &lt;option value=&quot;Congo {Democratic Rep}&quot;&gt;Congo {Democratic Rep}&lt;/option&gt;\r\n        &lt;option value=&quot;Costa Rica&quot;&gt;Costa Rica&lt;/option&gt;\r\n        &lt;option value=&quot;Croatia&quot;&gt;Croatia&lt;/option&gt;\r\n        &lt;option value=&quot;Cuba&quot;&gt;Cuba&lt;/option&gt;\r\n        &lt;option value=&quot;Cyprus&quot;&gt;Cyprus&lt;/option&gt;\r\n        &lt;option value=&quot;Czech Republic&quot;&gt;Czech Republic&lt;/option&gt;\r\n        &lt;option value=&quot;Denmark&quot;&gt;Denmark&lt;/option&gt;\r\n        &lt;option value=&quot;Djibouti&quot;&gt;Djibouti&lt;/option&gt;\r\n        &lt;option value=&quot;Dominica&quot;&gt;Dominica&lt;/option&gt;\r\n        &lt;option value=&quot;Dominican Republic&quot;&gt;Dominican Republic&lt;/option&gt;\r\n        &lt;option value=&quot;East Timor&quot;&gt;East Timor&lt;/option&gt;\r\n        &lt;option value=&quot;Ecuador&quot;&gt;Ecuador&lt;/option&gt;\r\n        &lt;option value=&quot;Egypt&quot;&gt;Egypt&lt;/option&gt;\r\n        &lt;option value=&quot;El Salvador&quot;&gt;El Salvador&lt;/option&gt;\r\n        &lt;option value=&quot;Equatorial Guinea&quot;&gt;Equatorial Guinea&lt;/option&gt;\r\n        &lt;option value=&quot;Eritrea&quot;&gt;Eritrea&lt;/option&gt;\r\n        &lt;option value=&quot;Estonia&quot;&gt;Estonia&lt;/option&gt;\r\n        &lt;option value=&quot;Ethiopia&quot;&gt;Ethiopia&lt;/option&gt;\r\n        &lt;option value=&quot;Fiji&quot;&gt;Fiji&lt;/option&gt;\r\n        &lt;option value=&quot;Finland&quot;&gt;Finland&lt;/option&gt;\r\n        &lt;option value=&quot;Gabon&quot;&gt;Gabon&lt;/option&gt;\r\n        &lt;option value=&quot;Gambia&quot;&gt;Gambia&lt;/option&gt;\r\n        &lt;option value=&quot;Georgia&quot;&gt;Georgia&lt;/option&gt;\r\n        &lt;option value=&quot;Germany&quot;&gt;Germany&lt;/option&gt;\r\n        &lt;option value=&quot;Ghana&quot;&gt;Ghana&lt;/option&gt;\r\n        &lt;option value=&quot;Greece&quot;&gt;Greece&lt;/option&gt;\r\n        &lt;option value=&quot;Grenada&quot;&gt;Grenada&lt;/option&gt;\r\n        &lt;option value=&quot;Guatemala&quot;&gt;Guatemala&lt;/option&gt;\r\n        &lt;option value=&quot;Guinea&quot;&gt;Guinea&lt;/option&gt;\r\n        &lt;option value=&quot;Guinea-Bissau&quot;&gt;Guinea-Bissau&lt;/option&gt;\r\n        &lt;option value=&quot;Guyana&quot;&gt;Guyana&lt;/option&gt;\r\n        &lt;option value=&quot;Haiti&quot;&gt;Haiti&lt;/option&gt;\r\n        &lt;option value=&quot;Honduras&quot;&gt;Honduras&lt;/option&gt;\r\n        &lt;option value=&quot;Hungary&quot;&gt;Hungary&lt;/option&gt;\r\n        &lt;option value=&quot;Iceland&quot;&gt;Iceland&lt;/option&gt;\r\n        &lt;option value=&quot;India&quot;&gt;India&lt;/option&gt;\r\n        &lt;option value=&quot;Indonesia&quot;&gt;Indonesia&lt;/option&gt;\r\n        &lt;option value=&quot;Iran&quot;&gt;Iran&lt;/option&gt;\r\n        &lt;option value=&quot;Iraq&quot;&gt;Iraq&lt;/option&gt;\r\n        &lt;option value=&quot;Ireland {Republic}&quot;&gt;Ireland {Republic}&lt;/option&gt;\r\n        &lt;option value=&quot;Israel&quot;&gt;Israel&lt;/option&gt;\r\n        &lt;option value=&quot;Italy&quot;&gt;Italy&lt;/option&gt;\r\n        &lt;option value=&quot;Ivory Coast&quot;&gt;Ivory Coast&lt;/option&gt;\r\n        &lt;option value=&quot;Jamaica&quot;&gt;Jamaica&lt;/option&gt;\r\n        &lt;option value=&quot;Japan&quot;&gt;Japan&lt;/option&gt;\r\n        &lt;option value=&quot;Jordan&quot;&gt;Jordan&lt;/option&gt;\r\n        &lt;option value=&quot;Kazakhstan&quot;&gt;Kazakhstan&lt;/option&gt;\r\n        &lt;option value=&quot;Kenya&quot;&gt;Kenya&lt;/option&gt;\r\n        &lt;option value=&quot;Kiribati&quot;&gt;Kiribati&lt;/option&gt;\r\n        &lt;option value=&quot;Korea North&quot;&gt;Korea North&lt;/option&gt;\r\n        &lt;option value=&quot;Korea South&quot;&gt;Korea South&lt;/option&gt;\r\n        &lt;option value=&quot;Kosovo&quot;&gt;Kosovo&lt;/option&gt;\r\n        &lt;option value=&quot;Kuwait&quot;&gt;Kuwait&lt;/option&gt;\r\n        &lt;option value=&quot;Kyrgyzstan&quot;&gt;Kyrgyzstan&lt;/option&gt;\r\n        &lt;option value=&quot;Laos&quot;&gt;Laos&lt;/option&gt;\r\n        &lt;option value=&quot;Latvia&quot;&gt;Latvia&lt;/option&gt;\r\n        &lt;option value=&quot;Lebanon&quot;&gt;Lebanon&lt;/option&gt;\r\n        &lt;option value=&quot;Lesotho&quot;&gt;Lesotho&lt;/option&gt;\r\n        &lt;option value=&quot;Liberia&quot;&gt;Liberia&lt;/option&gt;\r\n        &lt;option value=&quot;Libya&quot;&gt;Libya&lt;/option&gt;\r\n        &lt;option value=&quot;Liechtenstein&quot;&gt;Liechtenstein&lt;/option&gt;\r\n        &lt;option value=&quot;Lithuania&quot;&gt;Lithuania&lt;/option&gt;\r\n        &lt;option value=&quot;Luxembourg&quot;&gt;Luxembourg&lt;/option&gt;\r\n        &lt;option value=&quot;Macedonia&quot;&gt;Macedonia&lt;/option&gt;\r\n        &lt;option value=&quot;Madagascar&quot;&gt;Madagascar&lt;/option&gt;\r\n        &lt;option value=&quot;Malawi&quot;&gt;Malawi&lt;/option&gt;\r\n        &lt;option value=&quot;Malaysia&quot;&gt;Malaysia&lt;/option&gt;\r\n        &lt;option value=&quot;Maldives&quot;&gt;Maldives&lt;/option&gt;\r\n        &lt;option value=&quot;Mali&quot;&gt;Mali&lt;/option&gt;\r\n        &lt;option value=&quot;Malta&quot;&gt;Malta&lt;/option&gt;\r\n        &lt;option value=&quot;Marshall Islands&quot;&gt;Marshall Islands&lt;/option&gt;\r\n        &lt;option value=&quot;Mauritania&quot;&gt;Mauritania&lt;/option&gt;\r\n        &lt;option value=&quot;Mauritius&quot;&gt;Mauritius&lt;/option&gt;\r\n        &lt;option value=&quot;Mexico&quot;&gt;Mexico&lt;/option&gt;\r\n        &lt;option value=&quot;Micronesia&quot;&gt;Micronesia&lt;/option&gt;\r\n        &lt;option value=&quot;Moldova&quot;&gt;Moldova&lt;/option&gt;\r\n        &lt;option value=&quot;Monaco&quot;&gt;Monaco&lt;/option&gt;\r\n        &lt;option value=&quot;Mongolia&quot;&gt;Mongolia&lt;/option&gt;\r\n        &lt;option value=&quot;Montenegro&quot;&gt;Montenegro&lt;/option&gt;\r\n        &lt;option value=&quot;Morocco&quot;&gt;Morocco&lt;/option&gt;\r\n        &lt;option value=&quot;Mozambique&quot;&gt;Mozambique&lt;/option&gt;\r\n        &lt;option value=&quot;Myanmar, {Burma}&quot;&gt;Myanmar, {Burma}&lt;/option&gt;\r\n        &lt;option value=&quot;Namibia&quot;&gt;Namibia&lt;/option&gt;\r\n        &lt;option value=&quot;Nauru&quot;&gt;Nauru&lt;/option&gt;\r\n        &lt;option value=&quot;Nepal&quot;&gt;Nepal&lt;/option&gt;\r\n        &lt;option value=&quot;Netherlands&quot;&gt;Netherlands&lt;/option&gt;\r\n        &lt;option value=&quot;New Zealand&quot;&gt;New Zealand&lt;/option&gt;\r\n        &lt;option value=&quot;Nicaragua&quot;&gt;Nicaragua&lt;/option&gt;\r\n        &lt;option value=&quot;Niger&quot;&gt;Niger&lt;/option&gt;\r\n        &lt;option value=&quot;Nigeria&quot;&gt;Nigeria&lt;/option&gt;\r\n        &lt;option value=&quot;Norway&quot;&gt;Norway&lt;/option&gt;\r\n        &lt;option value=&quot;Oman&quot;&gt;Oman&lt;/option&gt;\r\n        &lt;option value=&quot;Pakistan&quot;&gt;Pakistan&lt;/option&gt;\r\n        &lt;option value=&quot;Palau&quot;&gt;Palau&lt;/option&gt;\r\n        &lt;option value=&quot;Panama&quot;&gt;Panama&lt;/option&gt;\r\n        &lt;option value=&quot;Papua New Guinea&quot;&gt;Papua New Guinea&lt;/option&gt;\r\n        &lt;option value=&quot;Paraguay&quot;&gt;Paraguay&lt;/option&gt;\r\n        &lt;option value=&quot;Peru&quot;&gt;Peru&lt;/option&gt;\r\n        &lt;option value=&quot;Philippines&quot;&gt;Philippines&lt;/option&gt;\r\n        &lt;option value=&quot;Poland&quot;&gt;Poland&lt;/option&gt;\r\n        &lt;option value=&quot;Portugal&quot;&gt;Portugal&lt;/option&gt;\r\n        &lt;option value=&quot;Qatar&quot;&gt;Qatar&lt;/option&gt;\r\n        &lt;option value=&quot;Romania&quot;&gt;Romania&lt;/option&gt;\r\n        &lt;option value=&quot;Russian Federation&quot;&gt;Russian Federation&lt;/option&gt;\r\n        &lt;option value=&quot;Rwanda&quot;&gt;Rwanda&lt;/option&gt;\r\n        &lt;option value=&quot;St Kitts &amp;amp; Nevis&quot;&gt;St Kitts &amp;amp; Nevis&lt;/option&gt;\r\n        &lt;option value=&quot;St Lucia&quot;&gt;St Lucia&lt;/option&gt;\r\n        &lt;option value=&quot;Saint Vincent &amp;amp; the Grenadines&quot;&gt;Saint Vincent &amp;amp; the Grenadines&lt;/option&gt;\r\n        &lt;option value=&quot;Samoa&quot;&gt;Samoa&lt;/option&gt;\r\n        &lt;option value=&quot;San Marino&quot;&gt;San Marino&lt;/option&gt;\r\n        &lt;option value=&quot;Sao Tome &amp;amp; Principe&quot;&gt;Sao Tome &amp;amp; Principe&lt;/option&gt;\r\n        &lt;option value=&quot;Saudi Arabia&quot;&gt;Saudi Arabia&lt;/option&gt;\r\n        &lt;option value=&quot;Senegal&quot;&gt;Senegal&lt;/option&gt;\r\n        &lt;option value=&quot;Serbia&quot;&gt;Serbia&lt;/option&gt;\r\n        &lt;option value=&quot;Seychelles&quot;&gt;Seychelles&lt;/option&gt;\r\n        &lt;option value=&quot;Sierra Leone&quot;&gt;Sierra Leone&lt;/option&gt;\r\n        &lt;option value=&quot;Singapore&quot;&gt;Singapore&lt;/option&gt;\r\n        &lt;option value=&quot;Slovakia&quot;&gt;Slovakia&lt;/option&gt;\r\n        &lt;option value=&quot;Slovenia&quot;&gt;Slovenia&lt;/option&gt;\r\n        &lt;option value=&quot;Solomon Islands&quot;&gt;Solomon Islands&lt;/option&gt;\r\n        &lt;option value=&quot;Somalia&quot;&gt;Somalia&lt;/option&gt;\r\n        &lt;option value=&quot;South Africa&quot;&gt;South Africa&lt;/option&gt;\r\n        &lt;option value=&quot;South Sudan&quot;&gt;South Sudan&lt;/option&gt;\r\n        &lt;option value=&quot;Spain&quot;&gt;Spain&lt;/option&gt;\r\n        &lt;option value=&quot;Sri Lanka&quot;&gt;Sri Lanka&lt;/option&gt;\r\n        &lt;option value=&quot;Sudan&quot;&gt;Sudan&lt;/option&gt;\r\n        &lt;option value=&quot;Suriname&quot;&gt;Suriname&lt;/option&gt;\r\n        &lt;option value=&quot;Swaziland&quot;&gt;Swaziland&lt;/option&gt;\r\n        &lt;option value=&quot;Sweden&quot;&gt;Sweden&lt;/option&gt;\r\n        &lt;option value=&quot;Switzerland&quot;&gt;Switzerland&lt;/option&gt;\r\n        &lt;option value=&quot;Syria&quot;&gt;Syria&lt;/option&gt;\r\n        &lt;option value=&quot;Taiwan&quot;&gt;Taiwan&lt;/option&gt;\r\n        &lt;option value=&quot;Tajikistan&quot;&gt;Tajikistan&lt;/option&gt;\r\n        &lt;option value=&quot;Tanzania&quot;&gt;Tanzania&lt;/option&gt;\r\n        &lt;option value=&quot;Thailand&quot;&gt;Thailand&lt;/option&gt;\r\n        &lt;option value=&quot;Togo&quot;&gt;Togo&lt;/option&gt;\r\n        &lt;option value=&quot;Tonga&quot;&gt;Tonga&lt;/option&gt;\r\n        &lt;option value=&quot;Trinidad &amp;amp; Tobago&quot;&gt;Trinidad &amp;amp; Tobago&lt;/option&gt;\r\n        &lt;option value=&quot;Tunisia&quot;&gt;Tunisia&lt;/option&gt;\r\n        &lt;option value=&quot;Turkey&quot;&gt;Turkey&lt;/option&gt;\r\n        &lt;option value=&quot;Turkmenistan&quot;&gt;Turkmenistan&lt;/option&gt;\r\n        &lt;option value=&quot;Tuvalu&quot;&gt;Tuvalu&lt;/option&gt;\r\n        &lt;option value=&quot;Uganda&quot;&gt;Uganda&lt;/option&gt;\r\n        &lt;option value=&quot;Ukraine&quot;&gt;Ukraine&lt;/option&gt;\r\n        &lt;option value=&quot;United Arab Emirates&quot;&gt;United Arab Emirates&lt;/option&gt;\r\n        &lt;option value=&quot;Uruguay&quot;&gt;Uruguay&lt;/option&gt;\r\n        &lt;option value=&quot;Uzbekistan&quot;&gt;Uzbekistan&lt;/option&gt;\r\n        &lt;option value=&quot;Vanuatu&quot;&gt;Vanuatu&lt;/option&gt;\r\n        &lt;option value=&quot;Vatican City&quot;&gt;Vatican City&lt;/option&gt;\r\n        &lt;option value=&quot;Venezuela&quot;&gt;Venezuela&lt;/option&gt;\r\n        &lt;option value=&quot;Vietnam&quot;&gt;Vietnam&lt;/option&gt;\r\n        &lt;option value=&quot;Yemen&quot;&gt;Yemen&lt;/option&gt;\r\n        &lt;option value=&quot;Zambia&quot;&gt;Zambia&lt;/option&gt;\r\n        &lt;option value=&quot;Zimbabwe&quot;&gt;Zimbabwe&lt;/option&gt;\r\n    &lt;/select&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- File --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;file_0&quot;&gt;Attach Detailed Itinerary&lt;/label&gt;\r\n    &lt;input type=&quot;file&quot; id=&quot;file_0&quot; name=&quot;file_0&quot; accept=&quot;.txt, .pdf, .doc, .docx&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Button --&gt;\r\n&lt;div class=&quot;form-action&quot;&gt;\r\n    &lt;input type=&quot;submit&quot; id=&quot;button_0&quot; name=&quot;button_0&quot; class=&quot;btn btn-primary&quot; value=&quot;Submit&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;/fieldset&gt;\r\n&lt;/form&gt;', 0, 'event-planner', 1, 1, 1576184991, 1576184991);
INSERT INTO `template` VALUES (6, 7, 'Expense Tracker', 'With this expense tracker at hand, you can instantly record every one of your expenses and on what you spend. That way, you can generate reports to know where you should start cutting down costs.', '{\"settings\":{\"name\":\"Expense Tracker\",\"canvas\":\"#canvas\",\"disabledFieldset\":false,\"layoutSelected\":\"\",\"layouts\":[{\"id\":\"\",\"name\":\"Vertical\"},{\"id\":\"form-horizontal\",\"name\":\"Horizontal\"},{\"id\":\"form-inline\",\"name\":\"Inline\"}],\"formSteps\":{\"title\":\"formSteps.title\",\"fields\":{\"id\":{\"label\":\"formSteps.id\",\"type\":\"input\",\"value\":\"formSteps\",\"name\":\"id\"},\"steps\":{\"label\":\"formSteps.steps\",\"type\":\"textarea-split\",\"value\":[],\"name\":\"steps\"},\"progressBar\":{\"label\":\"formSteps.progressBar\",\"type\":\"checkbox\",\"value\":false,\"name\":\"progressBar\"},\"noTitles\":{\"label\":\"formSteps.noTitles\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noTitles\"},\"noStages\":{\"label\":\"formSteps.noStages\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noStages\"},\"noSteps\":{\"label\":\"formSteps.noSteps\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noSteps\"}}}},\"initForm\":[{\"name\":\"heading\",\"title\":\"heading.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"heading_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"input\",\"value\":\"Expense Tracker\",\"name\":\"text\"},\"type\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"h1\",\"selected\":false,\"label\":\"H1\"},{\"value\":\"h2\",\"selected\":false,\"label\":\"H2\"},{\"value\":\"h3\",\"selected\":true,\"label\":\"H3\"},{\"value\":\"h4\",\"selected\":false,\"label\":\"H4\"},{\"value\":\"h5\",\"selected\":false,\"label\":\"H5\"},{\"value\":\"h6\",\"selected\":false,\"label\":\"H6\"}],\"name\":\"heading\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"legend\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"paragraph\",\"title\":\"paragraph.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"paragraph_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"textarea\",\"value\":\"If you\\u0027d like to better manage your expenses fill this form and generate your report.\",\"name\":\"text\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"date\",\"title\":\"date.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"date_0\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"date\",\"selected\":true,\"label\":\"Date\"},{\"value\":\"datetime-local\",\"selected\":false,\"label\":\"DateTime-Local\"},{\"value\":\"time\",\"selected\":false,\"label\":\"Time\"},{\"value\":\"month\",\"selected\":false,\"label\":\"Month\"},{\"value\":\"week\",\"selected\":false,\"label\":\"Week\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Date\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"min\":{\"label\":\"component.minDate\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"min\"},\"max\":{\"label\":\"component.maxDate\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"max\"},\"step\":{\"label\":\"component.stepNumber\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"step\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"selectlist\",\"title\":\"selectlist.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"selectlist_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Category\",\"name\":\"label\"},\"options\":{\"label\":\"component.options\",\"type\":\"textarea-split\",\"value\":[\"Option 1\",\"Option 2\",\"Option 3\"],\"name\":\"options\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"-Select-\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"selectlist\",\"title\":\"selectlist.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"selectlist_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Subcategory\",\"name\":\"label\"},\"options\":{\"label\":\"component.options\",\"type\":\"textarea-split\",\"value\":[\"Option 1\",\"Option 2\",\"Option 3\"],\"name\":\"options\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"-Select-\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_0\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Amount\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"selectlist\",\"title\":\"selectlist.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"selectlist_2\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Payment Method\",\"name\":\"label\"},\"options\":{\"label\":\"component.options\",\"type\":\"textarea-split\",\"value\":[\"Cash\",\"Cheque\",\"Credit Card\",\"Debit Card\"],\"name\":\"options\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"-Select-\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"textarea\",\"title\":\"textarea.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"textarea_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Transaction Notes\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"fieldSize\":{\"label\":\"component.fieldSize\",\"type\":\"input\",\"value\":\"3\",\"advanced\":true,\"name\":\"fieldSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Type\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"textarea-split\",\"value\":[\"Personal\",\"Bussiness\"],\"name\":\"radios\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"radio-inline\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"button\",\"title\":\"button.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"button_0\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"submit\",\"label\":\"Submit\",\"selected\":true},{\"value\":\"reset\",\"label\":\"Reset\",\"selected\":false},{\"value\":\"image\",\"label\":\"Image\",\"selected\":false}],\"name\":\"inputType\"},\"buttonText\":{\"label\":\"component.buttonText\",\"type\":\"input\",\"value\":\"Submit\",\"name\":\"buttonText\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"label\"},\"src\":{\"label\":\"component.src\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"src\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"btn btn-primary\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false}],\"height\":731}', '&lt;form id=&quot;form-app&quot;&gt;\r\n&lt;fieldset&gt;\r\n\r\n&lt;!-- Heading --&gt;\r\n&lt;h3 class=&quot;legend&quot;&gt;Expense Tracker&lt;/h3&gt;\r\n\r\n&lt;!-- Paragraph Text --&gt;\r\n&lt;p&gt;If you&#039;d like to better manage your expenses fill this form and generate your report.&lt;/p&gt;\r\n\r\n&lt;!-- Date --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;date_0&quot;&gt;Date&lt;/label&gt;\r\n    &lt;input type=&quot;date&quot; id=&quot;date_0&quot; name=&quot;date_0&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Select List --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_0&quot;&gt;Category&lt;/label&gt;\r\n    &lt;select id=&quot;selectlist_0&quot; name=&quot;selectlist_0[]&quot; class=&quot;form-control&quot;&gt;\r\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\r\n        &lt;option value=&quot;Option 1&quot;&gt;Option 1&lt;/option&gt;\r\n        &lt;option value=&quot;Option 2&quot;&gt;Option 2&lt;/option&gt;\r\n        &lt;option value=&quot;Option 3&quot;&gt;Option 3&lt;/option&gt;\r\n    &lt;/select&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Select List --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_1&quot;&gt;Subcategory&lt;/label&gt;\r\n    &lt;select id=&quot;selectlist_1&quot; name=&quot;selectlist_1[]&quot; class=&quot;form-control&quot;&gt;\r\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\r\n        &lt;option value=&quot;Option 1&quot;&gt;Option 1&lt;/option&gt;\r\n        &lt;option value=&quot;Option 2&quot;&gt;Option 2&lt;/option&gt;\r\n        &lt;option value=&quot;Option 3&quot;&gt;Option 3&lt;/option&gt;\r\n    &lt;/select&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_0&quot;&gt;Amount&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_0&quot; name=&quot;text_0&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Select List --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_2&quot;&gt;Payment Method&lt;/label&gt;\r\n    &lt;select id=&quot;selectlist_2&quot; name=&quot;selectlist_2[]&quot; class=&quot;form-control&quot;&gt;\r\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\r\n        &lt;option value=&quot;Cash&quot;&gt;Cash&lt;/option&gt;\r\n        &lt;option value=&quot;Cheque&quot;&gt;Cheque&lt;/option&gt;\r\n        &lt;option value=&quot;Credit Card&quot;&gt;Credit Card&lt;/option&gt;\r\n        &lt;option value=&quot;Debit Card&quot;&gt;Debit Card&lt;/option&gt;\r\n    &lt;/select&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text Area --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;textarea_0&quot;&gt;Transaction Notes&lt;/label&gt;\r\n    &lt;textarea id=&quot;textarea_0&quot; name=&quot;textarea_0&quot; rows=&quot;3&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Radio --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_0&quot;&gt;Type&lt;/label&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_0_0&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_0&quot; value=&quot;Personal&quot;&gt; Personal &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_0_1&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_1&quot; value=&quot;Bussiness&quot;&gt; Bussiness &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;span id=&quot;radio_0&quot;&gt;&lt;/span&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Button --&gt;\r\n&lt;div class=&quot;form-action&quot;&gt;\r\n    &lt;input type=&quot;submit&quot; id=&quot;button_0&quot; name=&quot;button_0&quot; class=&quot;btn btn-primary&quot; value=&quot;Submit&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;/fieldset&gt;\r\n&lt;/form&gt;', 0, 'expense-tracker', 1, 1, 1576184991, 1576184991);
INSERT INTO `template` VALUES (7, 5, 'Online Payment Form', 'An online payment form to sell your products securely on any place you want.', '{\"settings\":{\"name\":\"Online Payment Form\",\"canvas\":\"#canvas\",\"disabledFieldset\":false,\"layoutSelected\":\"\",\"layouts\":[{\"id\":\"\",\"name\":\"Vertical\"},{\"id\":\"form-horizontal\",\"name\":\"Horizontal\"},{\"id\":\"form-inline\",\"name\":\"Inline\"}],\"formSteps\":{\"title\":\"formSteps.title\",\"fields\":{\"id\":{\"label\":\"formSteps.id\",\"type\":\"input\",\"value\":\"formSteps\",\"name\":\"id\"},\"steps\":{\"label\":\"formSteps.steps\",\"type\":\"textarea-split\",\"value\":[],\"name\":\"steps\"},\"progressBar\":{\"label\":\"formSteps.progressBar\",\"type\":\"checkbox\",\"value\":false,\"name\":\"progressBar\"},\"noTitles\":{\"label\":\"formSteps.noTitles\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noTitles\"},\"noStages\":{\"label\":\"formSteps.noStages\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noStages\"},\"noSteps\":{\"label\":\"formSteps.noSteps\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noSteps\"}}}},\"initForm\":[{\"name\":\"heading\",\"title\":\"heading.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"heading_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"input\",\"value\":\"Online Payment Form\",\"name\":\"text\"},\"type\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"h1\",\"selected\":false,\"label\":\"H1\"},{\"value\":\"h2\",\"selected\":false,\"label\":\"H2\"},{\"value\":\"h3\",\"selected\":true,\"label\":\"H3\"},{\"value\":\"h4\",\"selected\":false,\"label\":\"H4\"},{\"value\":\"h5\",\"selected\":false,\"label\":\"H5\"},{\"value\":\"h6\",\"selected\":false,\"label\":\"H6\"}],\"name\":\"heading\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"legend\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"paragraph\",\"title\":\"paragraph.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"paragraph_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"textarea\",\"value\":\"What would you like to buy?\",\"name\":\"text\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"How many widgets would you like to buy?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"textarea-split\",\"value\":[\"1 - $10|1\",\"2 - $19|2\",\"3 - $26|3\"],\"name\":\"radios\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"radio-inline\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"What color would you like?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"textarea-split\",\"value\":[\"Red\",\"Yellow\",\"Blue\"],\"name\":\"radios\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"radio-inline\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_0\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Name\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"email\",\"title\":\"email.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"email_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Email\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"checkdns\":{\"label\":\"component.checkDNS\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"checkdns\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"textarea\",\"title\":\"textarea.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"textarea_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Where would you like the widgets shipped?\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"fieldSize\":{\"label\":\"component.fieldSize\",\"type\":\"input\",\"value\":\"3\",\"advanced\":true,\"name\":\"fieldSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_1\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"City\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-4\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_2\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"State\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-4\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"selectlist\",\"title\":\"selectlist.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"selectlist_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Country\",\"name\":\"label\"},\"options\":{\"label\":\"component.options\",\"type\":\"textarea-split\",\"value\":[\"United States\",\"United Kingdom\",\"Australia\",\"Canada\",\"France\",\"----\",\"Afghanistan\",\"Albania\",\"Algeria\",\"Andorra\",\"Angola\",\"Antigua \\u0026 Deps\",\"Argentina\",\"Armenia\",\"Austria\",\"Azerbaijan\",\"Bahamas\",\"Bahrain\",\"Bangladesh\",\"Barbados\",\"Belarus\",\"Belgium\",\"Belize\",\"Benin\",\"Bhutan\",\"Bolivia\",\"Bosnia Herzegovina\",\"Botswana\",\"Brazil\",\"Brunei\",\"Bulgaria\",\"Burkina\",\"Burundi\",\"Cambodia\",\"Cameroon\",\"Cape Verde\",\"Central African Rep\",\"Chad\",\"Chile\",\"China\",\"Colombia\",\"Comoros\",\"Congo\",\"Congo {Democratic Rep}\",\"Costa Rica\",\"Croatia\",\"Cuba\",\"Cyprus\",\"Czech Republic\",\"Denmark\",\"Djibouti\",\"Dominica\",\"Dominican Republic\",\"East Timor\",\"Ecuador\",\"Egypt\",\"El Salvador\",\"Equatorial Guinea\",\"Eritrea\",\"Estonia\",\"Ethiopia\",\"Fiji\",\"Finland\",\"Gabon\",\"Gambia\",\"Georgia\",\"Germany\",\"Ghana\",\"Greece\",\"Grenada\",\"Guatemala\",\"Guinea\",\"Guinea-Bissau\",\"Guyana\",\"Haiti\",\"Honduras\",\"Hungary\",\"Iceland\",\"India\",\"Indonesia\",\"Iran\",\"Iraq\",\"Ireland {Republic}\",\"Israel\",\"Italy\",\"Ivory Coast\",\"Jamaica\",\"Japan\",\"Jordan\",\"Kazakhstan\",\"Kenya\",\"Kiribati\",\"Korea North\",\"Korea South\",\"Kosovo\",\"Kuwait\",\"Kyrgyzstan\",\"Laos\",\"Latvia\",\"Lebanon\",\"Lesotho\",\"Liberia\",\"Libya\",\"Liechtenstein\",\"Lithuania\",\"Luxembourg\",\"Macedonia\",\"Madagascar\",\"Malawi\",\"Malaysia\",\"Maldives\",\"Mali\",\"Malta\",\"Marshall Islands\",\"Mauritania\",\"Mauritius\",\"Mexico\",\"Micronesia\",\"Moldova\",\"Monaco\",\"Mongolia\",\"Montenegro\",\"Morocco\",\"Mozambique\",\"Myanmar, {Burma}\",\"Namibia\",\"Nauru\",\"Nepal\",\"Netherlands\",\"New Zealand\",\"Nicaragua\",\"Niger\",\"Nigeria\",\"Norway\",\"Oman\",\"Pakistan\",\"Palau\",\"Panama\",\"Papua New Guinea\",\"Paraguay\",\"Peru\",\"Philippines\",\"Poland\",\"Portugal\",\"Qatar\",\"Romania\",\"Russian Federation\",\"Rwanda\",\"St Kitts \\u0026 Nevis\",\"St Lucia\",\"Saint Vincent \\u0026 the Grenadines\",\"Samoa\",\"San Marino\",\"Sao Tome \\u0026 Principe\",\"Saudi Arabia\",\"Senegal\",\"Serbia\",\"Seychelles\",\"Sierra Leone\",\"Singapore\",\"Slovakia\",\"Slovenia\",\"Solomon Islands\",\"Somalia\",\"South Africa\",\"South Sudan\",\"Spain\",\"Sri Lanka\",\"Sudan\",\"Suriname\",\"Swaziland\",\"Sweden\",\"Switzerland\",\"Syria\",\"Taiwan\",\"Tajikistan\",\"Tanzania\",\"Thailand\",\"Togo\",\"Tonga\",\"Trinidad \\u0026 Tobago\",\"Tunisia\",\"Turkey\",\"Turkmenistan\",\"Tuvalu\",\"Uganda\",\"Ukraine\",\"United Arab Emirates\",\"Uruguay\",\"Uzbekistan\",\"Vanuatu\",\"Vatican City\",\"Venezuela\",\"Vietnam\",\"Yemen\",\"Zambia\",\"Zimbabwe\"],\"name\":\"options\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"-Select-\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-4\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"selectlist\",\"title\":\"selectlist.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"selectlist_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Would you like to pay by check or credit card?\",\"name\":\"label\"},\"options\":{\"label\":\"component.options\",\"type\":\"textarea-split\",\"value\":[\"Check\",\"Credit Card\"],\"name\":\"options\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"-Select-\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"paragraph\",\"title\":\"paragraph.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"paragraph_1\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"textarea\",\"value\":\"\\u003Cstrong\\u003EPlease Read\\u003C\\/strong\\u003E\",\"name\":\"text\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"paragraph\",\"title\":\"paragraph.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"paragraph_2\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"textarea\",\"value\":\"\\u003Csmall\\u003EYou will be taken to a secure payment page after submitting this form. Please enter your credit card information on that page to complete your purchase.\\u003C\\/small\\u003E\",\"name\":\"text\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"paragraph\",\"title\":\"paragraph.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"paragraph_3\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"textarea\",\"value\":\"\\u003Csmall\\u003EThank you!\\u003C\\/small\\u003E\",\"name\":\"text\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"button\",\"title\":\"button.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"button_0\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"submit\",\"label\":\"Submit\",\"selected\":true},{\"value\":\"reset\",\"label\":\"Reset\",\"selected\":false},{\"value\":\"image\",\"label\":\"Image\",\"selected\":false}],\"name\":\"inputType\"},\"buttonText\":{\"label\":\"component.buttonText\",\"type\":\"input\",\"value\":\"Submit\",\"name\":\"buttonText\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"label\"},\"src\":{\"label\":\"component.src\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"src\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"btn btn-primary\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false}],\"height\":891}', '&lt;form id=&quot;form-app&quot;&gt;\r\n&lt;fieldset&gt;\r\n\r\n&lt;!-- Heading --&gt;\r\n&lt;h3 class=&quot;legend&quot;&gt;Online Payment Form&lt;/h3&gt;\r\n\r\n&lt;!-- Paragraph Text --&gt;\r\n&lt;p&gt;What would you like to buy?&lt;/p&gt;\r\n\r\n&lt;!-- Radio --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_0&quot;&gt;How many widgets would you like to buy?&lt;/label&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_0_0&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_0&quot; value=&quot;1&quot;&gt; 1 - $10 &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_0_1&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_1&quot; value=&quot;2&quot;&gt; 2 - $19 &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_0_2&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_2&quot; value=&quot;3&quot;&gt; 3 - $26 &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;span id=&quot;radio_0&quot;&gt;&lt;/span&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Radio --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_1&quot;&gt;What color would you like?&lt;/label&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_1_0&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_0&quot; value=&quot;Red&quot;&gt; Red &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_1_1&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_1&quot; value=&quot;Yellow&quot;&gt; Yellow &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_1_2&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_2&quot; value=&quot;Blue&quot;&gt; Blue &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;span id=&quot;radio_1&quot;&gt;&lt;/span&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_0&quot;&gt;Name&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_0&quot; name=&quot;text_0&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Email --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;email_0&quot;&gt;Email&lt;/label&gt;\r\n    &lt;input type=&quot;email&quot; id=&quot;email_0&quot; name=&quot;email_0&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text Area --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;textarea_0&quot;&gt;Where would you like the widgets shipped?&lt;/label&gt;\r\n    &lt;textarea id=&quot;textarea_0&quot; name=&quot;textarea_0&quot; rows=&quot;3&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group col-xs-4&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_1&quot;&gt;City&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_1&quot; name=&quot;text_1&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group col-xs-4&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_2&quot;&gt;State&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_2&quot; name=&quot;text_2&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Select List --&gt;\r\n&lt;div class=&quot;form-group col-xs-4&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_0&quot;&gt;Country&lt;/label&gt;\r\n    &lt;select id=&quot;selectlist_0&quot; name=&quot;selectlist_0[]&quot; class=&quot;form-control&quot;&gt;\r\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\r\n        &lt;option value=&quot;United States&quot;&gt;United States&lt;/option&gt;\r\n        &lt;option value=&quot;United Kingdom&quot;&gt;United Kingdom&lt;/option&gt;\r\n        &lt;option value=&quot;Australia&quot;&gt;Australia&lt;/option&gt;\r\n        &lt;option value=&quot;Canada&quot;&gt;Canada&lt;/option&gt;\r\n        &lt;option value=&quot;France&quot;&gt;France&lt;/option&gt;\r\n        &lt;option value=&quot;----&quot;&gt;----&lt;/option&gt;\r\n        &lt;option value=&quot;Afghanistan&quot;&gt;Afghanistan&lt;/option&gt;\r\n        &lt;option value=&quot;Albania&quot;&gt;Albania&lt;/option&gt;\r\n        &lt;option value=&quot;Algeria&quot;&gt;Algeria&lt;/option&gt;\r\n        &lt;option value=&quot;Andorra&quot;&gt;Andorra&lt;/option&gt;\r\n        &lt;option value=&quot;Angola&quot;&gt;Angola&lt;/option&gt;\r\n        &lt;option value=&quot;Antigua &amp;amp; Deps&quot;&gt;Antigua &amp;amp; Deps&lt;/option&gt;\r\n        &lt;option value=&quot;Argentina&quot;&gt;Argentina&lt;/option&gt;\r\n        &lt;option value=&quot;Armenia&quot;&gt;Armenia&lt;/option&gt;\r\n        &lt;option value=&quot;Austria&quot;&gt;Austria&lt;/option&gt;\r\n        &lt;option value=&quot;Azerbaijan&quot;&gt;Azerbaijan&lt;/option&gt;\r\n        &lt;option value=&quot;Bahamas&quot;&gt;Bahamas&lt;/option&gt;\r\n        &lt;option value=&quot;Bahrain&quot;&gt;Bahrain&lt;/option&gt;\r\n        &lt;option value=&quot;Bangladesh&quot;&gt;Bangladesh&lt;/option&gt;\r\n        &lt;option value=&quot;Barbados&quot;&gt;Barbados&lt;/option&gt;\r\n        &lt;option value=&quot;Belarus&quot;&gt;Belarus&lt;/option&gt;\r\n        &lt;option value=&quot;Belgium&quot;&gt;Belgium&lt;/option&gt;\r\n        &lt;option value=&quot;Belize&quot;&gt;Belize&lt;/option&gt;\r\n        &lt;option value=&quot;Benin&quot;&gt;Benin&lt;/option&gt;\r\n        &lt;option value=&quot;Bhutan&quot;&gt;Bhutan&lt;/option&gt;\r\n        &lt;option value=&quot;Bolivia&quot;&gt;Bolivia&lt;/option&gt;\r\n        &lt;option value=&quot;Bosnia Herzegovina&quot;&gt;Bosnia Herzegovina&lt;/option&gt;\r\n        &lt;option value=&quot;Botswana&quot;&gt;Botswana&lt;/option&gt;\r\n        &lt;option value=&quot;Brazil&quot;&gt;Brazil&lt;/option&gt;\r\n        &lt;option value=&quot;Brunei&quot;&gt;Brunei&lt;/option&gt;\r\n        &lt;option value=&quot;Bulgaria&quot;&gt;Bulgaria&lt;/option&gt;\r\n        &lt;option value=&quot;Burkina&quot;&gt;Burkina&lt;/option&gt;\r\n        &lt;option value=&quot;Burundi&quot;&gt;Burundi&lt;/option&gt;\r\n        &lt;option value=&quot;Cambodia&quot;&gt;Cambodia&lt;/option&gt;\r\n        &lt;option value=&quot;Cameroon&quot;&gt;Cameroon&lt;/option&gt;\r\n        &lt;option value=&quot;Cape Verde&quot;&gt;Cape Verde&lt;/option&gt;\r\n        &lt;option value=&quot;Central African Rep&quot;&gt;Central African Rep&lt;/option&gt;\r\n        &lt;option value=&quot;Chad&quot;&gt;Chad&lt;/option&gt;\r\n        &lt;option value=&quot;Chile&quot;&gt;Chile&lt;/option&gt;\r\n        &lt;option value=&quot;China&quot;&gt;China&lt;/option&gt;\r\n        &lt;option value=&quot;Colombia&quot;&gt;Colombia&lt;/option&gt;\r\n        &lt;option value=&quot;Comoros&quot;&gt;Comoros&lt;/option&gt;\r\n        &lt;option value=&quot;Congo&quot;&gt;Congo&lt;/option&gt;\r\n        &lt;option value=&quot;Congo {Democratic Rep}&quot;&gt;Congo {Democratic Rep}&lt;/option&gt;\r\n        &lt;option value=&quot;Costa Rica&quot;&gt;Costa Rica&lt;/option&gt;\r\n        &lt;option value=&quot;Croatia&quot;&gt;Croatia&lt;/option&gt;\r\n        &lt;option value=&quot;Cuba&quot;&gt;Cuba&lt;/option&gt;\r\n        &lt;option value=&quot;Cyprus&quot;&gt;Cyprus&lt;/option&gt;\r\n        &lt;option value=&quot;Czech Republic&quot;&gt;Czech Republic&lt;/option&gt;\r\n        &lt;option value=&quot;Denmark&quot;&gt;Denmark&lt;/option&gt;\r\n        &lt;option value=&quot;Djibouti&quot;&gt;Djibouti&lt;/option&gt;\r\n        &lt;option value=&quot;Dominica&quot;&gt;Dominica&lt;/option&gt;\r\n        &lt;option value=&quot;Dominican Republic&quot;&gt;Dominican Republic&lt;/option&gt;\r\n        &lt;option value=&quot;East Timor&quot;&gt;East Timor&lt;/option&gt;\r\n        &lt;option value=&quot;Ecuador&quot;&gt;Ecuador&lt;/option&gt;\r\n        &lt;option value=&quot;Egypt&quot;&gt;Egypt&lt;/option&gt;\r\n        &lt;option value=&quot;El Salvador&quot;&gt;El Salvador&lt;/option&gt;\r\n        &lt;option value=&quot;Equatorial Guinea&quot;&gt;Equatorial Guinea&lt;/option&gt;\r\n        &lt;option value=&quot;Eritrea&quot;&gt;Eritrea&lt;/option&gt;\r\n        &lt;option value=&quot;Estonia&quot;&gt;Estonia&lt;/option&gt;\r\n        &lt;option value=&quot;Ethiopia&quot;&gt;Ethiopia&lt;/option&gt;\r\n        &lt;option value=&quot;Fiji&quot;&gt;Fiji&lt;/option&gt;\r\n        &lt;option value=&quot;Finland&quot;&gt;Finland&lt;/option&gt;\r\n        &lt;option value=&quot;Gabon&quot;&gt;Gabon&lt;/option&gt;\r\n        &lt;option value=&quot;Gambia&quot;&gt;Gambia&lt;/option&gt;\r\n        &lt;option value=&quot;Georgia&quot;&gt;Georgia&lt;/option&gt;\r\n        &lt;option value=&quot;Germany&quot;&gt;Germany&lt;/option&gt;\r\n        &lt;option value=&quot;Ghana&quot;&gt;Ghana&lt;/option&gt;\r\n        &lt;option value=&quot;Greece&quot;&gt;Greece&lt;/option&gt;\r\n        &lt;option value=&quot;Grenada&quot;&gt;Grenada&lt;/option&gt;\r\n        &lt;option value=&quot;Guatemala&quot;&gt;Guatemala&lt;/option&gt;\r\n        &lt;option value=&quot;Guinea&quot;&gt;Guinea&lt;/option&gt;\r\n        &lt;option value=&quot;Guinea-Bissau&quot;&gt;Guinea-Bissau&lt;/option&gt;\r\n        &lt;option value=&quot;Guyana&quot;&gt;Guyana&lt;/option&gt;\r\n        &lt;option value=&quot;Haiti&quot;&gt;Haiti&lt;/option&gt;\r\n        &lt;option value=&quot;Honduras&quot;&gt;Honduras&lt;/option&gt;\r\n        &lt;option value=&quot;Hungary&quot;&gt;Hungary&lt;/option&gt;\r\n        &lt;option value=&quot;Iceland&quot;&gt;Iceland&lt;/option&gt;\r\n        &lt;option value=&quot;India&quot;&gt;India&lt;/option&gt;\r\n        &lt;option value=&quot;Indonesia&quot;&gt;Indonesia&lt;/option&gt;\r\n        &lt;option value=&quot;Iran&quot;&gt;Iran&lt;/option&gt;\r\n        &lt;option value=&quot;Iraq&quot;&gt;Iraq&lt;/option&gt;\r\n        &lt;option value=&quot;Ireland {Republic}&quot;&gt;Ireland {Republic}&lt;/option&gt;\r\n        &lt;option value=&quot;Israel&quot;&gt;Israel&lt;/option&gt;\r\n        &lt;option value=&quot;Italy&quot;&gt;Italy&lt;/option&gt;\r\n        &lt;option value=&quot;Ivory Coast&quot;&gt;Ivory Coast&lt;/option&gt;\r\n        &lt;option value=&quot;Jamaica&quot;&gt;Jamaica&lt;/option&gt;\r\n        &lt;option value=&quot;Japan&quot;&gt;Japan&lt;/option&gt;\r\n        &lt;option value=&quot;Jordan&quot;&gt;Jordan&lt;/option&gt;\r\n        &lt;option value=&quot;Kazakhstan&quot;&gt;Kazakhstan&lt;/option&gt;\r\n        &lt;option value=&quot;Kenya&quot;&gt;Kenya&lt;/option&gt;\r\n        &lt;option value=&quot;Kiribati&quot;&gt;Kiribati&lt;/option&gt;\r\n        &lt;option value=&quot;Korea North&quot;&gt;Korea North&lt;/option&gt;\r\n        &lt;option value=&quot;Korea South&quot;&gt;Korea South&lt;/option&gt;\r\n        &lt;option value=&quot;Kosovo&quot;&gt;Kosovo&lt;/option&gt;\r\n        &lt;option value=&quot;Kuwait&quot;&gt;Kuwait&lt;/option&gt;\r\n        &lt;option value=&quot;Kyrgyzstan&quot;&gt;Kyrgyzstan&lt;/option&gt;\r\n        &lt;option value=&quot;Laos&quot;&gt;Laos&lt;/option&gt;\r\n        &lt;option value=&quot;Latvia&quot;&gt;Latvia&lt;/option&gt;\r\n        &lt;option value=&quot;Lebanon&quot;&gt;Lebanon&lt;/option&gt;\r\n        &lt;option value=&quot;Lesotho&quot;&gt;Lesotho&lt;/option&gt;\r\n        &lt;option value=&quot;Liberia&quot;&gt;Liberia&lt;/option&gt;\r\n        &lt;option value=&quot;Libya&quot;&gt;Libya&lt;/option&gt;\r\n        &lt;option value=&quot;Liechtenstein&quot;&gt;Liechtenstein&lt;/option&gt;\r\n        &lt;option value=&quot;Lithuania&quot;&gt;Lithuania&lt;/option&gt;\r\n        &lt;option value=&quot;Luxembourg&quot;&gt;Luxembourg&lt;/option&gt;\r\n        &lt;option value=&quot;Macedonia&quot;&gt;Macedonia&lt;/option&gt;\r\n        &lt;option value=&quot;Madagascar&quot;&gt;Madagascar&lt;/option&gt;\r\n        &lt;option value=&quot;Malawi&quot;&gt;Malawi&lt;/option&gt;\r\n        &lt;option value=&quot;Malaysia&quot;&gt;Malaysia&lt;/option&gt;\r\n        &lt;option value=&quot;Maldives&quot;&gt;Maldives&lt;/option&gt;\r\n        &lt;option value=&quot;Mali&quot;&gt;Mali&lt;/option&gt;\r\n        &lt;option value=&quot;Malta&quot;&gt;Malta&lt;/option&gt;\r\n        &lt;option value=&quot;Marshall Islands&quot;&gt;Marshall Islands&lt;/option&gt;\r\n        &lt;option value=&quot;Mauritania&quot;&gt;Mauritania&lt;/option&gt;\r\n        &lt;option value=&quot;Mauritius&quot;&gt;Mauritius&lt;/option&gt;\r\n        &lt;option value=&quot;Mexico&quot;&gt;Mexico&lt;/option&gt;\r\n        &lt;option value=&quot;Micronesia&quot;&gt;Micronesia&lt;/option&gt;\r\n        &lt;option value=&quot;Moldova&quot;&gt;Moldova&lt;/option&gt;\r\n        &lt;option value=&quot;Monaco&quot;&gt;Monaco&lt;/option&gt;\r\n        &lt;option value=&quot;Mongolia&quot;&gt;Mongolia&lt;/option&gt;\r\n        &lt;option value=&quot;Montenegro&quot;&gt;Montenegro&lt;/option&gt;\r\n        &lt;option value=&quot;Morocco&quot;&gt;Morocco&lt;/option&gt;\r\n        &lt;option value=&quot;Mozambique&quot;&gt;Mozambique&lt;/option&gt;\r\n        &lt;option value=&quot;Myanmar, {Burma}&quot;&gt;Myanmar, {Burma}&lt;/option&gt;\r\n        &lt;option value=&quot;Namibia&quot;&gt;Namibia&lt;/option&gt;\r\n        &lt;option value=&quot;Nauru&quot;&gt;Nauru&lt;/option&gt;\r\n        &lt;option value=&quot;Nepal&quot;&gt;Nepal&lt;/option&gt;\r\n        &lt;option value=&quot;Netherlands&quot;&gt;Netherlands&lt;/option&gt;\r\n        &lt;option value=&quot;New Zealand&quot;&gt;New Zealand&lt;/option&gt;\r\n        &lt;option value=&quot;Nicaragua&quot;&gt;Nicaragua&lt;/option&gt;\r\n        &lt;option value=&quot;Niger&quot;&gt;Niger&lt;/option&gt;\r\n        &lt;option value=&quot;Nigeria&quot;&gt;Nigeria&lt;/option&gt;\r\n        &lt;option value=&quot;Norway&quot;&gt;Norway&lt;/option&gt;\r\n        &lt;option value=&quot;Oman&quot;&gt;Oman&lt;/option&gt;\r\n        &lt;option value=&quot;Pakistan&quot;&gt;Pakistan&lt;/option&gt;\r\n        &lt;option value=&quot;Palau&quot;&gt;Palau&lt;/option&gt;\r\n        &lt;option value=&quot;Panama&quot;&gt;Panama&lt;/option&gt;\r\n        &lt;option value=&quot;Papua New Guinea&quot;&gt;Papua New Guinea&lt;/option&gt;\r\n        &lt;option value=&quot;Paraguay&quot;&gt;Paraguay&lt;/option&gt;\r\n        &lt;option value=&quot;Peru&quot;&gt;Peru&lt;/option&gt;\r\n        &lt;option value=&quot;Philippines&quot;&gt;Philippines&lt;/option&gt;\r\n        &lt;option value=&quot;Poland&quot;&gt;Poland&lt;/option&gt;\r\n        &lt;option value=&quot;Portugal&quot;&gt;Portugal&lt;/option&gt;\r\n        &lt;option value=&quot;Qatar&quot;&gt;Qatar&lt;/option&gt;\r\n        &lt;option value=&quot;Romania&quot;&gt;Romania&lt;/option&gt;\r\n        &lt;option value=&quot;Russian Federation&quot;&gt;Russian Federation&lt;/option&gt;\r\n        &lt;option value=&quot;Rwanda&quot;&gt;Rwanda&lt;/option&gt;\r\n        &lt;option value=&quot;St Kitts &amp;amp; Nevis&quot;&gt;St Kitts &amp;amp; Nevis&lt;/option&gt;\r\n        &lt;option value=&quot;St Lucia&quot;&gt;St Lucia&lt;/option&gt;\r\n        &lt;option value=&quot;Saint Vincent &amp;amp; the Grenadines&quot;&gt;Saint Vincent &amp;amp; the Grenadines&lt;/option&gt;\r\n        &lt;option value=&quot;Samoa&quot;&gt;Samoa&lt;/option&gt;\r\n        &lt;option value=&quot;San Marino&quot;&gt;San Marino&lt;/option&gt;\r\n        &lt;option value=&quot;Sao Tome &amp;amp; Principe&quot;&gt;Sao Tome &amp;amp; Principe&lt;/option&gt;\r\n        &lt;option value=&quot;Saudi Arabia&quot;&gt;Saudi Arabia&lt;/option&gt;\r\n        &lt;option value=&quot;Senegal&quot;&gt;Senegal&lt;/option&gt;\r\n        &lt;option value=&quot;Serbia&quot;&gt;Serbia&lt;/option&gt;\r\n        &lt;option value=&quot;Seychelles&quot;&gt;Seychelles&lt;/option&gt;\r\n        &lt;option value=&quot;Sierra Leone&quot;&gt;Sierra Leone&lt;/option&gt;\r\n        &lt;option value=&quot;Singapore&quot;&gt;Singapore&lt;/option&gt;\r\n        &lt;option value=&quot;Slovakia&quot;&gt;Slovakia&lt;/option&gt;\r\n        &lt;option value=&quot;Slovenia&quot;&gt;Slovenia&lt;/option&gt;\r\n        &lt;option value=&quot;Solomon Islands&quot;&gt;Solomon Islands&lt;/option&gt;\r\n        &lt;option value=&quot;Somalia&quot;&gt;Somalia&lt;/option&gt;\r\n        &lt;option value=&quot;South Africa&quot;&gt;South Africa&lt;/option&gt;\r\n        &lt;option value=&quot;South Sudan&quot;&gt;South Sudan&lt;/option&gt;\r\n        &lt;option value=&quot;Spain&quot;&gt;Spain&lt;/option&gt;\r\n        &lt;option value=&quot;Sri Lanka&quot;&gt;Sri Lanka&lt;/option&gt;\r\n        &lt;option value=&quot;Sudan&quot;&gt;Sudan&lt;/option&gt;\r\n        &lt;option value=&quot;Suriname&quot;&gt;Suriname&lt;/option&gt;\r\n        &lt;option value=&quot;Swaziland&quot;&gt;Swaziland&lt;/option&gt;\r\n        &lt;option value=&quot;Sweden&quot;&gt;Sweden&lt;/option&gt;\r\n        &lt;option value=&quot;Switzerland&quot;&gt;Switzerland&lt;/option&gt;\r\n        &lt;option value=&quot;Syria&quot;&gt;Syria&lt;/option&gt;\r\n        &lt;option value=&quot;Taiwan&quot;&gt;Taiwan&lt;/option&gt;\r\n        &lt;option value=&quot;Tajikistan&quot;&gt;Tajikistan&lt;/option&gt;\r\n        &lt;option value=&quot;Tanzania&quot;&gt;Tanzania&lt;/option&gt;\r\n        &lt;option value=&quot;Thailand&quot;&gt;Thailand&lt;/option&gt;\r\n        &lt;option value=&quot;Togo&quot;&gt;Togo&lt;/option&gt;\r\n        &lt;option value=&quot;Tonga&quot;&gt;Tonga&lt;/option&gt;\r\n        &lt;option value=&quot;Trinidad &amp;amp; Tobago&quot;&gt;Trinidad &amp;amp; Tobago&lt;/option&gt;\r\n        &lt;option value=&quot;Tunisia&quot;&gt;Tunisia&lt;/option&gt;\r\n        &lt;option value=&quot;Turkey&quot;&gt;Turkey&lt;/option&gt;\r\n        &lt;option value=&quot;Turkmenistan&quot;&gt;Turkmenistan&lt;/option&gt;\r\n        &lt;option value=&quot;Tuvalu&quot;&gt;Tuvalu&lt;/option&gt;\r\n        &lt;option value=&quot;Uganda&quot;&gt;Uganda&lt;/option&gt;\r\n        &lt;option value=&quot;Ukraine&quot;&gt;Ukraine&lt;/option&gt;\r\n        &lt;option value=&quot;United Arab Emirates&quot;&gt;United Arab Emirates&lt;/option&gt;\r\n        &lt;option value=&quot;Uruguay&quot;&gt;Uruguay&lt;/option&gt;\r\n        &lt;option value=&quot;Uzbekistan&quot;&gt;Uzbekistan&lt;/option&gt;\r\n        &lt;option value=&quot;Vanuatu&quot;&gt;Vanuatu&lt;/option&gt;\r\n        &lt;option value=&quot;Vatican City&quot;&gt;Vatican City&lt;/option&gt;\r\n        &lt;option value=&quot;Venezuela&quot;&gt;Venezuela&lt;/option&gt;\r\n        &lt;option value=&quot;Vietnam&quot;&gt;Vietnam&lt;/option&gt;\r\n        &lt;option value=&quot;Yemen&quot;&gt;Yemen&lt;/option&gt;\r\n        &lt;option value=&quot;Zambia&quot;&gt;Zambia&lt;/option&gt;\r\n        &lt;option value=&quot;Zimbabwe&quot;&gt;Zimbabwe&lt;/option&gt;\r\n    &lt;/select&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Select List --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_1&quot;&gt;Would you like to pay by check or credit card?&lt;/label&gt;\r\n    &lt;select id=&quot;selectlist_1&quot; name=&quot;selectlist_1[]&quot; class=&quot;form-control&quot;&gt;\r\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\r\n        &lt;option value=&quot;Check&quot;&gt;Check&lt;/option&gt;\r\n        &lt;option value=&quot;Credit Card&quot;&gt;Credit Card&lt;/option&gt;\r\n    &lt;/select&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Paragraph Text --&gt;\r\n&lt;p&gt;&lt;strong&gt;Please Read&lt;/strong&gt;&lt;/p&gt;\r\n\r\n&lt;!-- Paragraph Text --&gt;\r\n&lt;p&gt;&lt;small&gt;You will be taken to a secure payment page after submitting this form. Please enter your credit card information on that page to complete your purchase.&lt;/small&gt;&lt;/p&gt;\r\n\r\n&lt;!-- Paragraph Text --&gt;\r\n&lt;p&gt;&lt;small&gt;Thank you!&lt;/small&gt;&lt;/p&gt;\r\n\r\n&lt;!-- Button --&gt;\r\n&lt;div class=&quot;form-action&quot;&gt;\r\n    &lt;input type=&quot;submit&quot; id=&quot;button_0&quot; name=&quot;button_0&quot; class=&quot;btn btn-primary&quot; value=&quot;Submit&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;/fieldset&gt;\r\n&lt;/form&gt;', 0, 'online-payment-form', 1, 1, 1576184991, 1576184991);
INSERT INTO `template` VALUES (8, 2, 'Trivia Quiz', 'Create trivia quizes and receive online responses to the quiz.', '{\"settings\":{\"name\":\"Trivia Quiz\",\"canvas\":\"#canvas\",\"disabledFieldset\":false,\"layoutSelected\":\"\",\"layouts\":[{\"id\":\"\",\"name\":\"Vertical\"},{\"id\":\"form-horizontal\",\"name\":\"Horizontal\"},{\"id\":\"form-inline\",\"name\":\"Inline\"}],\"formSteps\":{\"title\":\"formSteps.title\",\"fields\":{\"id\":{\"label\":\"formSteps.id\",\"type\":\"input\",\"value\":\"formSteps\",\"name\":\"id\"},\"steps\":{\"label\":\"formSteps.steps\",\"type\":\"textarea-split\",\"value\":[\"Untitled Step\",\"Untitled Step\",\"Untitled Step\",\"Untitled Step\"],\"name\":\"steps\"},\"progressBar\":{\"label\":\"formSteps.progressBar\",\"type\":\"checkbox\",\"value\":false,\"name\":\"progressBar\"},\"noTitles\":{\"label\":\"formSteps.noTitles\",\"type\":\"checkbox\",\"value\":true,\"name\":\"noTitles\"},\"noStages\":{\"label\":\"formSteps.noStages\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noStages\"},\"noSteps\":{\"label\":\"formSteps.noSteps\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noSteps\"}}}},\"initForm\":[{\"name\":\"heading\",\"title\":\"heading.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"heading_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"input\",\"value\":\"Trivia Quiz\",\"name\":\"text\"},\"type\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"h1\",\"selected\":false,\"label\":\"H1\"},{\"value\":\"h2\",\"selected\":false,\"label\":\"H2\"},{\"value\":\"h3\",\"selected\":true,\"label\":\"H3\"},{\"value\":\"h4\",\"selected\":false,\"label\":\"H4\"},{\"value\":\"h5\",\"selected\":false,\"label\":\"H5\"},{\"value\":\"h6\",\"selected\":false,\"label\":\"H6\"}],\"name\":\"heading\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"legend\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"paragraph\",\"title\":\"paragraph.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"paragraph_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"textarea\",\"value\":\"\\u003Cstrong\\u003EFill out this trivia quiz for fun!\\u003C\\/strong\\u003E\",\"name\":\"text\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"paragraph\",\"title\":\"paragraph.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"paragraph_1\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"textarea\",\"value\":\"\\u003Csmall\\u003EYou will receive 5 points for every correct answer.\\u003C\\/small\\u003E\",\"name\":\"text\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Which country is also known as the land of the rising sun?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"textarea-split\",\"value\":[\"Japan|5\",\"China|0\",\"Australia|0\"],\"name\":\"radios\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"radio-inline\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"pagebreak\",\"title\":\"pagebreak.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"pagebreak_0\",\"name\":\"id\"},\"prev\":{\"label\":\"component.prev\",\"type\":\"input\",\"value\":\"\",\"name\":\"prev\"},\"next\":{\"label\":\"component.next\",\"type\":\"input\",\"value\":\"\",\"name\":\"next\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Which is the smallest country in the world?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"textarea-split\",\"value\":[\"Liechtenstein|0\",\"Vatican City|5\",\"Monaco|0\"],\"name\":\"radios\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"radio-inline\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"pagebreak\",\"title\":\"pagebreak.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"pagebreak_1\",\"name\":\"id\"},\"prev\":{\"label\":\"component.prev\",\"type\":\"input\",\"value\":\"\",\"name\":\"prev\"},\"next\":{\"label\":\"component.next\",\"type\":\"input\",\"value\":\"\",\"name\":\"next\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_2\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"What food group has the highest level of protein?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"textarea-split\",\"value\":[\"Bread|0\",\"Vegetables|0\",\"Meat|5\"],\"name\":\"radios\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"radio-inline\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"pagebreak\",\"title\":\"pagebreak.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"pagebreak_2\",\"name\":\"id\"},\"prev\":{\"label\":\"component.prev\",\"type\":\"input\",\"value\":\"\",\"name\":\"prev\"},\"next\":{\"label\":\"component.next\",\"type\":\"input\",\"value\":\"\",\"name\":\"next\"}},\"fresh\":false},{\"name\":\"radio\",\"title\":\"radio.title\",\"fields\":{\"id\":{\"label\":\"component.groupName\",\"type\":\"input\",\"value\":\"radio_3\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"How many words are there in the English language?\",\"name\":\"label\"},\"radios\":{\"label\":\"component.radios\",\"type\":\"textarea-split\",\"value\":[\"2 Million+|0\",\"170,000|5\",\"70,000|0\",\"500,000|0\"],\"name\":\"radios\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"radio-inline\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"inline\":{\"label\":\"component.inline\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"inline\"}},\"fresh\":false},{\"name\":\"snippet\",\"title\":\"snippet.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"snippet_0\",\"name\":\"id\"},\"snippet\":{\"label\":\"component.htmlCode\",\"type\":\"textarea\",\"value\":\"\\u003Cdiv id=\\u0022result\\u0022 class=\\u0022well\\u0022\\u003EYour score is \\u003Cspan id=\\u0022score\\u0022 class=\\u0022label label-default\\u0022\\u003E0\\u003C\\/span\\u003E. Thanks for your time!\\u003C\\/div\\u003E\",\"name\":\"snippet\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"button\",\"title\":\"button.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"button_0\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"submit\",\"label\":\"Submit\",\"selected\":true},{\"value\":\"reset\",\"label\":\"Reset\",\"selected\":false},{\"value\":\"image\",\"label\":\"Image\",\"selected\":false}],\"name\":\"inputType\"},\"buttonText\":{\"label\":\"component.buttonText\",\"type\":\"input\",\"value\":\"Submit\",\"name\":\"buttonText\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"label\"},\"src\":{\"label\":\"component.src\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"src\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"btn btn-primary\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false}],\"height\":883}', '&lt;form id=&quot;form-app&quot;&gt;\r\n&lt;!-- Steps --&gt;\r\n&lt;div class=&quot;steps&quot;&gt;\r\n    &lt;div class=&quot;step no-title current&quot;&gt;\r\n        &lt;div class=&quot;stage&quot;&gt;1&lt;/div&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;step no-title&quot;&gt;\r\n        &lt;div class=&quot;stage&quot;&gt;2&lt;/div&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;step no-title&quot;&gt;\r\n        &lt;div class=&quot;stage&quot;&gt;3&lt;/div&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;step no-title&quot;&gt;\r\n        &lt;div class=&quot;stage&quot;&gt;4&lt;/div&gt;\r\n    &lt;/div&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;fieldset&gt;\r\n\r\n&lt;!-- Heading --&gt;\r\n&lt;h3 class=&quot;legend&quot;&gt;Trivia Quiz&lt;/h3&gt;\r\n\r\n&lt;!-- Paragraph Text --&gt;\r\n&lt;p&gt;&lt;strong&gt;Fill out this trivia quiz for fun!&lt;/strong&gt;&lt;/p&gt;\r\n\r\n&lt;!-- Paragraph Text --&gt;\r\n&lt;p&gt;&lt;small&gt;You will receive 5 points for every correct answer.&lt;/small&gt;&lt;/p&gt;\r\n\r\n&lt;!-- Radio --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_0&quot;&gt;Which country is also known as the land of the rising sun?&lt;/label&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_0_0&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_0&quot; value=&quot;5&quot;&gt; Japan &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_0_1&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_1&quot; value=&quot;0&quot;&gt; China &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_0_2&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_0&quot; id=&quot;radio_0_2&quot; value=&quot;0&quot;&gt; Australia &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;span id=&quot;radio_0&quot;&gt;&lt;/span&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Page Break --&gt;\r\n&lt;div class=&quot;page-break&quot; data-button-previous=&quot;&quot; data-button-next=&quot;&quot;&gt;&lt;/div&gt;\r\n\r\n&lt;!-- Radio --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_1&quot;&gt;Which is the smallest country in the world?&lt;/label&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_1_0&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_0&quot; value=&quot;0&quot;&gt; Liechtenstein &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_1_1&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_1&quot; value=&quot;5&quot;&gt; Vatican City &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_1_2&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_2&quot; value=&quot;0&quot;&gt; Monaco &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;span id=&quot;radio_1&quot;&gt;&lt;/span&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Page Break --&gt;\r\n&lt;div class=&quot;page-break&quot; data-button-previous=&quot;&quot; data-button-next=&quot;&quot;&gt;&lt;/div&gt;\r\n\r\n&lt;!-- Radio --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_2&quot;&gt;What food group has the highest level of protein?&lt;/label&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_2_0&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_0&quot; value=&quot;0&quot;&gt; Bread &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_2_1&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_1&quot; value=&quot;0&quot;&gt; Vegetables &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_2_2&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_2&quot; value=&quot;5&quot;&gt; Meat &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;span id=&quot;radio_2&quot;&gt;&lt;/span&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Page Break --&gt;\r\n&lt;div class=&quot;page-break&quot; data-button-previous=&quot;&quot; data-button-next=&quot;&quot;&gt;&lt;/div&gt;\r\n\r\n&lt;!-- Radio --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;radio_3&quot;&gt;How many words are there in the English language?&lt;/label&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_3_0&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_0&quot; value=&quot;0&quot;&gt; 2 Million+ &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_3_1&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_1&quot; value=&quot;5&quot;&gt; 170,000 &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_3_2&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_2&quot; value=&quot;0&quot;&gt; 70,000 &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;div class=&quot;radio&quot;&gt;\r\n        &lt;label for=&quot;radio_3_3&quot; class=&quot;radio-inline&quot;&gt;\r\n        &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_3&quot; value=&quot;0&quot;&gt; 500,000 &lt;/label&gt;\r\n    &lt;/div&gt;\r\n    &lt;span id=&quot;radio_3&quot;&gt;&lt;/span&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Snippet --&gt;\r\n&lt;div class=&quot;snippet&quot;&gt;&lt;div id=&quot;result&quot; class=&quot;well&quot;&gt;Your score is &lt;span id=&quot;score&quot; class=&quot;label label-default&quot;&gt;0&lt;/span&gt;. Thanks for your time!&lt;/div&gt;&lt;/div&gt;\r\n\r\n&lt;!-- Button --&gt;\r\n&lt;div class=&quot;form-action&quot;&gt;\r\n    &lt;input type=&quot;submit&quot; id=&quot;button_0&quot; name=&quot;button_0&quot; class=&quot;btn btn-primary&quot; value=&quot;Submit&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;/fieldset&gt;\r\n&lt;/form&gt;', 1, 'trivia-quiz', 1, 1, 1576184991, 1576184991);
INSERT INTO `template` VALUES (9, 7, 'Address Book', 'Use our online address book to easily input, organize, and store your personal contacts.', '{\"settings\":{\"name\":\"Address Book\",\"canvas\":\"#canvas\",\"disabledFieldset\":false,\"layoutSelected\":\"\",\"layouts\":[{\"id\":\"\",\"name\":\"Vertical\"},{\"id\":\"form-horizontal\",\"name\":\"Horizontal\"},{\"id\":\"form-inline\",\"name\":\"Inline\"}],\"formSteps\":{\"title\":\"formSteps.title\",\"fields\":{\"id\":{\"label\":\"formSteps.id\",\"type\":\"input\",\"value\":\"formSteps\",\"name\":\"id\"},\"steps\":{\"label\":\"formSteps.steps\",\"type\":\"textarea-split\",\"value\":[],\"name\":\"steps\"},\"progressBar\":{\"label\":\"formSteps.progressBar\",\"type\":\"checkbox\",\"value\":false,\"name\":\"progressBar\"},\"noTitles\":{\"label\":\"formSteps.noTitles\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noTitles\"},\"noStages\":{\"label\":\"formSteps.noStages\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noStages\"},\"noSteps\":{\"label\":\"formSteps.noSteps\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noSteps\"}}}},\"initForm\":[{\"name\":\"heading\",\"title\":\"heading.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"heading_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"input\",\"value\":\"Address Book\",\"name\":\"text\"},\"type\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"h1\",\"selected\":false,\"label\":\"H1\"},{\"value\":\"h2\",\"selected\":false,\"label\":\"H2\"},{\"value\":\"h3\",\"selected\":true,\"label\":\"H3\"},{\"value\":\"h4\",\"selected\":false,\"label\":\"H4\"},{\"value\":\"h5\",\"selected\":false,\"label\":\"H5\"},{\"value\":\"h6\",\"selected\":false,\"label\":\"H6\"}],\"name\":\"type\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"legend\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_0\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Name\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"file\",\"title\":\"file.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"file_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Photo\",\"name\":\"label\"},\"accept\":{\"label\":\"component.accept\",\"type\":\"input\",\"value\":\".gif, .jpg, .png\",\"name\":\"accept\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"minSize\":{\"label\":\"component.minSize\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"minSize\"},\"maxSize\":{\"label\":\"component.maxSize\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"maxSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_1\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Address\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_2\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"City\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-4\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_3\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"State\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-4\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"selectlist\",\"title\":\"selectlist.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"selectlist_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Country\",\"name\":\"label\"},\"options\":{\"label\":\"component.options\",\"type\":\"textarea-split\",\"value\":[\"United States\",\"United Kingdom\",\"Australia\",\"Canada\",\"France\",\"----\",\"Afghanistan\",\"Albania\",\"Algeria\",\"Andorra\",\"Angola\",\"Antigua \\u0026 Deps\",\"Argentina\",\"Armenia\",\"Austria\",\"Azerbaijan\",\"Bahamas\",\"Bahrain\",\"Bangladesh\",\"Barbados\",\"Belarus\",\"Belgium\",\"Belize\",\"Benin\",\"Bhutan\",\"Bolivia\",\"Bosnia Herzegovina\",\"Botswana\",\"Brazil\",\"Brunei\",\"Bulgaria\",\"Burkina\",\"Burundi\",\"Cambodia\",\"Cameroon\",\"Cape Verde\",\"Central African Rep\",\"Chad\",\"Chile\",\"China\",\"Colombia\",\"Comoros\",\"Congo\",\"Congo {Democratic Rep}\",\"Costa Rica\",\"Croatia\",\"Cuba\",\"Cyprus\",\"Czech Republic\",\"Denmark\",\"Djibouti\",\"Dominica\",\"Dominican Republic\",\"East Timor\",\"Ecuador\",\"Egypt\",\"El Salvador\",\"Equatorial Guinea\",\"Eritrea\",\"Estonia\",\"Ethiopia\",\"Fiji\",\"Finland\",\"Gabon\",\"Gambia\",\"Georgia\",\"Germany\",\"Ghana\",\"Greece\",\"Grenada\",\"Guatemala\",\"Guinea\",\"Guinea-Bissau\",\"Guyana\",\"Haiti\",\"Honduras\",\"Hungary\",\"Iceland\",\"India\",\"Indonesia\",\"Iran\",\"Iraq\",\"Ireland {Republic}\",\"Israel\",\"Italy\",\"Ivory Coast\",\"Jamaica\",\"Japan\",\"Jordan\",\"Kazakhstan\",\"Kenya\",\"Kiribati\",\"Korea North\",\"Korea South\",\"Kosovo\",\"Kuwait\",\"Kyrgyzstan\",\"Laos\",\"Latvia\",\"Lebanon\",\"Lesotho\",\"Liberia\",\"Libya\",\"Liechtenstein\",\"Lithuania\",\"Luxembourg\",\"Macedonia\",\"Madagascar\",\"Malawi\",\"Malaysia\",\"Maldives\",\"Mali\",\"Malta\",\"Marshall Islands\",\"Mauritania\",\"Mauritius\",\"Mexico\",\"Micronesia\",\"Moldova\",\"Monaco\",\"Mongolia\",\"Montenegro\",\"Morocco\",\"Mozambique\",\"Myanmar, {Burma}\",\"Namibia\",\"Nauru\",\"Nepal\",\"Netherlands\",\"New Zealand\",\"Nicaragua\",\"Niger\",\"Nigeria\",\"Norway\",\"Oman\",\"Pakistan\",\"Palau\",\"Panama\",\"Papua New Guinea\",\"Paraguay\",\"Peru\",\"Philippines\",\"Poland\",\"Portugal\",\"Qatar\",\"Romania\",\"Russian Federation\",\"Rwanda\",\"St Kitts \\u0026 Nevis\",\"St Lucia\",\"Saint Vincent \\u0026 the Grenadines\",\"Samoa\",\"San Marino\",\"Sao Tome \\u0026 Principe\",\"Saudi Arabia\",\"Senegal\",\"Serbia\",\"Seychelles\",\"Sierra Leone\",\"Singapore\",\"Slovakia\",\"Slovenia\",\"Solomon Islands\",\"Somalia\",\"South Africa\",\"South Sudan\",\"Spain\",\"Sri Lanka\",\"Sudan\",\"Suriname\",\"Swaziland\",\"Sweden\",\"Switzerland\",\"Syria\",\"Taiwan\",\"Tajikistan\",\"Tanzania\",\"Thailand\",\"Togo\",\"Tonga\",\"Trinidad \\u0026 Tobago\",\"Tunisia\",\"Turkey\",\"Turkmenistan\",\"Tuvalu\",\"Uganda\",\"Ukraine\",\"United Arab Emirates\",\"Uruguay\",\"Uzbekistan\",\"Vanuatu\",\"Vatican City\",\"Venezuela\",\"Vietnam\",\"Yemen\",\"Zambia\",\"Zimbabwe\"],\"name\":\"options\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"-Select-\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-4\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_4\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":false,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":true,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Web Site\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"email\",\"title\":\"email.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"email_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Email Address\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"checkdns\":{\"label\":\"component.checkDNS\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"checkdns\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_5\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":false,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":true,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Home Phone\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-6\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_6\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":false,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":true,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Cell Phone\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-6\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"date\",\"title\":\"date.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"date_0\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"date\",\"selected\":true,\"label\":\"Date\"},{\"value\":\"datetime-local\",\"selected\":false,\"label\":\"DateTime-Local\"},{\"value\":\"time\",\"selected\":false,\"label\":\"Time\"},{\"value\":\"month\",\"selected\":false,\"label\":\"Month\"},{\"value\":\"week\",\"selected\":false,\"label\":\"Week\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Birthday\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"min\":{\"label\":\"component.minDate\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"min\"},\"max\":{\"label\":\"component.maxDate\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"max\"},\"step\":{\"label\":\"component.stepNumber\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"step\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"textarea\",\"title\":\"textarea.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"textarea_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Notes\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"fieldSize\":{\"label\":\"component.fieldSize\",\"type\":\"input\",\"value\":\"3\",\"advanced\":true,\"name\":\"fieldSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"button\",\"title\":\"button.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"button_0\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"submit\",\"label\":\"Submit\",\"selected\":true},{\"value\":\"reset\",\"label\":\"Reset\",\"selected\":false},{\"value\":\"image\",\"label\":\"Image\",\"selected\":false}],\"name\":\"inputType\"},\"buttonText\":{\"label\":\"component.buttonText\",\"type\":\"input\",\"value\":\"Submit\",\"name\":\"buttonText\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"label\"},\"src\":{\"label\":\"component.src\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"src\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"btn btn-primary\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false}],\"height\":792}', '&lt;form id=&quot;form-app&quot; enctype=&quot;multipart/form-data&quot;&gt;\r\n&lt;fieldset&gt;\r\n\r\n&lt;!-- Heading --&gt;\r\n&lt;h3 class=&quot;legend&quot;&gt;Address Book&lt;/h3&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_0&quot;&gt;Name&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_0&quot; name=&quot;text_0&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- File --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;file_0&quot;&gt;Photo&lt;/label&gt;\r\n    &lt;input type=&quot;file&quot; id=&quot;file_0&quot; name=&quot;file_0&quot; accept=&quot;.gif, .jpg, .png&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_1&quot;&gt;Address&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_1&quot; name=&quot;text_1&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group col-xs-4&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_2&quot;&gt;City&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_2&quot; name=&quot;text_2&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group col-xs-4&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_3&quot;&gt;State&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_3&quot; name=&quot;text_3&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Select List --&gt;\r\n&lt;div class=&quot;form-group col-xs-4&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_0&quot;&gt;Country&lt;/label&gt;\r\n    &lt;select id=&quot;selectlist_0&quot; name=&quot;selectlist_0[]&quot; class=&quot;form-control&quot;&gt;\r\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\r\n        &lt;option value=&quot;United States&quot;&gt;United States&lt;/option&gt;\r\n        &lt;option value=&quot;United Kingdom&quot;&gt;United Kingdom&lt;/option&gt;\r\n        &lt;option value=&quot;Australia&quot;&gt;Australia&lt;/option&gt;\r\n        &lt;option value=&quot;Canada&quot;&gt;Canada&lt;/option&gt;\r\n        &lt;option value=&quot;France&quot;&gt;France&lt;/option&gt;\r\n        &lt;option value=&quot;----&quot;&gt;----&lt;/option&gt;\r\n        &lt;option value=&quot;Afghanistan&quot;&gt;Afghanistan&lt;/option&gt;\r\n        &lt;option value=&quot;Albania&quot;&gt;Albania&lt;/option&gt;\r\n        &lt;option value=&quot;Algeria&quot;&gt;Algeria&lt;/option&gt;\r\n        &lt;option value=&quot;Andorra&quot;&gt;Andorra&lt;/option&gt;\r\n        &lt;option value=&quot;Angola&quot;&gt;Angola&lt;/option&gt;\r\n        &lt;option value=&quot;Antigua &amp;amp; Deps&quot;&gt;Antigua &amp;amp; Deps&lt;/option&gt;\r\n        &lt;option value=&quot;Argentina&quot;&gt;Argentina&lt;/option&gt;\r\n        &lt;option value=&quot;Armenia&quot;&gt;Armenia&lt;/option&gt;\r\n        &lt;option value=&quot;Austria&quot;&gt;Austria&lt;/option&gt;\r\n        &lt;option value=&quot;Azerbaijan&quot;&gt;Azerbaijan&lt;/option&gt;\r\n        &lt;option value=&quot;Bahamas&quot;&gt;Bahamas&lt;/option&gt;\r\n        &lt;option value=&quot;Bahrain&quot;&gt;Bahrain&lt;/option&gt;\r\n        &lt;option value=&quot;Bangladesh&quot;&gt;Bangladesh&lt;/option&gt;\r\n        &lt;option value=&quot;Barbados&quot;&gt;Barbados&lt;/option&gt;\r\n        &lt;option value=&quot;Belarus&quot;&gt;Belarus&lt;/option&gt;\r\n        &lt;option value=&quot;Belgium&quot;&gt;Belgium&lt;/option&gt;\r\n        &lt;option value=&quot;Belize&quot;&gt;Belize&lt;/option&gt;\r\n        &lt;option value=&quot;Benin&quot;&gt;Benin&lt;/option&gt;\r\n        &lt;option value=&quot;Bhutan&quot;&gt;Bhutan&lt;/option&gt;\r\n        &lt;option value=&quot;Bolivia&quot;&gt;Bolivia&lt;/option&gt;\r\n        &lt;option value=&quot;Bosnia Herzegovina&quot;&gt;Bosnia Herzegovina&lt;/option&gt;\r\n        &lt;option value=&quot;Botswana&quot;&gt;Botswana&lt;/option&gt;\r\n        &lt;option value=&quot;Brazil&quot;&gt;Brazil&lt;/option&gt;\r\n        &lt;option value=&quot;Brunei&quot;&gt;Brunei&lt;/option&gt;\r\n        &lt;option value=&quot;Bulgaria&quot;&gt;Bulgaria&lt;/option&gt;\r\n        &lt;option value=&quot;Burkina&quot;&gt;Burkina&lt;/option&gt;\r\n        &lt;option value=&quot;Burundi&quot;&gt;Burundi&lt;/option&gt;\r\n        &lt;option value=&quot;Cambodia&quot;&gt;Cambodia&lt;/option&gt;\r\n        &lt;option value=&quot;Cameroon&quot;&gt;Cameroon&lt;/option&gt;\r\n        &lt;option value=&quot;Cape Verde&quot;&gt;Cape Verde&lt;/option&gt;\r\n        &lt;option value=&quot;Central African Rep&quot;&gt;Central African Rep&lt;/option&gt;\r\n        &lt;option value=&quot;Chad&quot;&gt;Chad&lt;/option&gt;\r\n        &lt;option value=&quot;Chile&quot;&gt;Chile&lt;/option&gt;\r\n        &lt;option value=&quot;China&quot;&gt;China&lt;/option&gt;\r\n        &lt;option value=&quot;Colombia&quot;&gt;Colombia&lt;/option&gt;\r\n        &lt;option value=&quot;Comoros&quot;&gt;Comoros&lt;/option&gt;\r\n        &lt;option value=&quot;Congo&quot;&gt;Congo&lt;/option&gt;\r\n        &lt;option value=&quot;Congo {Democratic Rep}&quot;&gt;Congo {Democratic Rep}&lt;/option&gt;\r\n        &lt;option value=&quot;Costa Rica&quot;&gt;Costa Rica&lt;/option&gt;\r\n        &lt;option value=&quot;Croatia&quot;&gt;Croatia&lt;/option&gt;\r\n        &lt;option value=&quot;Cuba&quot;&gt;Cuba&lt;/option&gt;\r\n        &lt;option value=&quot;Cyprus&quot;&gt;Cyprus&lt;/option&gt;\r\n        &lt;option value=&quot;Czech Republic&quot;&gt;Czech Republic&lt;/option&gt;\r\n        &lt;option value=&quot;Denmark&quot;&gt;Denmark&lt;/option&gt;\r\n        &lt;option value=&quot;Djibouti&quot;&gt;Djibouti&lt;/option&gt;\r\n        &lt;option value=&quot;Dominica&quot;&gt;Dominica&lt;/option&gt;\r\n        &lt;option value=&quot;Dominican Republic&quot;&gt;Dominican Republic&lt;/option&gt;\r\n        &lt;option value=&quot;East Timor&quot;&gt;East Timor&lt;/option&gt;\r\n        &lt;option value=&quot;Ecuador&quot;&gt;Ecuador&lt;/option&gt;\r\n        &lt;option value=&quot;Egypt&quot;&gt;Egypt&lt;/option&gt;\r\n        &lt;option value=&quot;El Salvador&quot;&gt;El Salvador&lt;/option&gt;\r\n        &lt;option value=&quot;Equatorial Guinea&quot;&gt;Equatorial Guinea&lt;/option&gt;\r\n        &lt;option value=&quot;Eritrea&quot;&gt;Eritrea&lt;/option&gt;\r\n        &lt;option value=&quot;Estonia&quot;&gt;Estonia&lt;/option&gt;\r\n        &lt;option value=&quot;Ethiopia&quot;&gt;Ethiopia&lt;/option&gt;\r\n        &lt;option value=&quot;Fiji&quot;&gt;Fiji&lt;/option&gt;\r\n        &lt;option value=&quot;Finland&quot;&gt;Finland&lt;/option&gt;\r\n        &lt;option value=&quot;Gabon&quot;&gt;Gabon&lt;/option&gt;\r\n        &lt;option value=&quot;Gambia&quot;&gt;Gambia&lt;/option&gt;\r\n        &lt;option value=&quot;Georgia&quot;&gt;Georgia&lt;/option&gt;\r\n        &lt;option value=&quot;Germany&quot;&gt;Germany&lt;/option&gt;\r\n        &lt;option value=&quot;Ghana&quot;&gt;Ghana&lt;/option&gt;\r\n        &lt;option value=&quot;Greece&quot;&gt;Greece&lt;/option&gt;\r\n        &lt;option value=&quot;Grenada&quot;&gt;Grenada&lt;/option&gt;\r\n        &lt;option value=&quot;Guatemala&quot;&gt;Guatemala&lt;/option&gt;\r\n        &lt;option value=&quot;Guinea&quot;&gt;Guinea&lt;/option&gt;\r\n        &lt;option value=&quot;Guinea-Bissau&quot;&gt;Guinea-Bissau&lt;/option&gt;\r\n        &lt;option value=&quot;Guyana&quot;&gt;Guyana&lt;/option&gt;\r\n        &lt;option value=&quot;Haiti&quot;&gt;Haiti&lt;/option&gt;\r\n        &lt;option value=&quot;Honduras&quot;&gt;Honduras&lt;/option&gt;\r\n        &lt;option value=&quot;Hungary&quot;&gt;Hungary&lt;/option&gt;\r\n        &lt;option value=&quot;Iceland&quot;&gt;Iceland&lt;/option&gt;\r\n        &lt;option value=&quot;India&quot;&gt;India&lt;/option&gt;\r\n        &lt;option value=&quot;Indonesia&quot;&gt;Indonesia&lt;/option&gt;\r\n        &lt;option value=&quot;Iran&quot;&gt;Iran&lt;/option&gt;\r\n        &lt;option value=&quot;Iraq&quot;&gt;Iraq&lt;/option&gt;\r\n        &lt;option value=&quot;Ireland {Republic}&quot;&gt;Ireland {Republic}&lt;/option&gt;\r\n        &lt;option value=&quot;Israel&quot;&gt;Israel&lt;/option&gt;\r\n        &lt;option value=&quot;Italy&quot;&gt;Italy&lt;/option&gt;\r\n        &lt;option value=&quot;Ivory Coast&quot;&gt;Ivory Coast&lt;/option&gt;\r\n        &lt;option value=&quot;Jamaica&quot;&gt;Jamaica&lt;/option&gt;\r\n        &lt;option value=&quot;Japan&quot;&gt;Japan&lt;/option&gt;\r\n        &lt;option value=&quot;Jordan&quot;&gt;Jordan&lt;/option&gt;\r\n        &lt;option value=&quot;Kazakhstan&quot;&gt;Kazakhstan&lt;/option&gt;\r\n        &lt;option value=&quot;Kenya&quot;&gt;Kenya&lt;/option&gt;\r\n        &lt;option value=&quot;Kiribati&quot;&gt;Kiribati&lt;/option&gt;\r\n        &lt;option value=&quot;Korea North&quot;&gt;Korea North&lt;/option&gt;\r\n        &lt;option value=&quot;Korea South&quot;&gt;Korea South&lt;/option&gt;\r\n        &lt;option value=&quot;Kosovo&quot;&gt;Kosovo&lt;/option&gt;\r\n        &lt;option value=&quot;Kuwait&quot;&gt;Kuwait&lt;/option&gt;\r\n        &lt;option value=&quot;Kyrgyzstan&quot;&gt;Kyrgyzstan&lt;/option&gt;\r\n        &lt;option value=&quot;Laos&quot;&gt;Laos&lt;/option&gt;\r\n        &lt;option value=&quot;Latvia&quot;&gt;Latvia&lt;/option&gt;\r\n        &lt;option value=&quot;Lebanon&quot;&gt;Lebanon&lt;/option&gt;\r\n        &lt;option value=&quot;Lesotho&quot;&gt;Lesotho&lt;/option&gt;\r\n        &lt;option value=&quot;Liberia&quot;&gt;Liberia&lt;/option&gt;\r\n        &lt;option value=&quot;Libya&quot;&gt;Libya&lt;/option&gt;\r\n        &lt;option value=&quot;Liechtenstein&quot;&gt;Liechtenstein&lt;/option&gt;\r\n        &lt;option value=&quot;Lithuania&quot;&gt;Lithuania&lt;/option&gt;\r\n        &lt;option value=&quot;Luxembourg&quot;&gt;Luxembourg&lt;/option&gt;\r\n        &lt;option value=&quot;Macedonia&quot;&gt;Macedonia&lt;/option&gt;\r\n        &lt;option value=&quot;Madagascar&quot;&gt;Madagascar&lt;/option&gt;\r\n        &lt;option value=&quot;Malawi&quot;&gt;Malawi&lt;/option&gt;\r\n        &lt;option value=&quot;Malaysia&quot;&gt;Malaysia&lt;/option&gt;\r\n        &lt;option value=&quot;Maldives&quot;&gt;Maldives&lt;/option&gt;\r\n        &lt;option value=&quot;Mali&quot;&gt;Mali&lt;/option&gt;\r\n        &lt;option value=&quot;Malta&quot;&gt;Malta&lt;/option&gt;\r\n        &lt;option value=&quot;Marshall Islands&quot;&gt;Marshall Islands&lt;/option&gt;\r\n        &lt;option value=&quot;Mauritania&quot;&gt;Mauritania&lt;/option&gt;\r\n        &lt;option value=&quot;Mauritius&quot;&gt;Mauritius&lt;/option&gt;\r\n        &lt;option value=&quot;Mexico&quot;&gt;Mexico&lt;/option&gt;\r\n        &lt;option value=&quot;Micronesia&quot;&gt;Micronesia&lt;/option&gt;\r\n        &lt;option value=&quot;Moldova&quot;&gt;Moldova&lt;/option&gt;\r\n        &lt;option value=&quot;Monaco&quot;&gt;Monaco&lt;/option&gt;\r\n        &lt;option value=&quot;Mongolia&quot;&gt;Mongolia&lt;/option&gt;\r\n        &lt;option value=&quot;Montenegro&quot;&gt;Montenegro&lt;/option&gt;\r\n        &lt;option value=&quot;Morocco&quot;&gt;Morocco&lt;/option&gt;\r\n        &lt;option value=&quot;Mozambique&quot;&gt;Mozambique&lt;/option&gt;\r\n        &lt;option value=&quot;Myanmar, {Burma}&quot;&gt;Myanmar, {Burma}&lt;/option&gt;\r\n        &lt;option value=&quot;Namibia&quot;&gt;Namibia&lt;/option&gt;\r\n        &lt;option value=&quot;Nauru&quot;&gt;Nauru&lt;/option&gt;\r\n        &lt;option value=&quot;Nepal&quot;&gt;Nepal&lt;/option&gt;\r\n        &lt;option value=&quot;Netherlands&quot;&gt;Netherlands&lt;/option&gt;\r\n        &lt;option value=&quot;New Zealand&quot;&gt;New Zealand&lt;/option&gt;\r\n        &lt;option value=&quot;Nicaragua&quot;&gt;Nicaragua&lt;/option&gt;\r\n        &lt;option value=&quot;Niger&quot;&gt;Niger&lt;/option&gt;\r\n        &lt;option value=&quot;Nigeria&quot;&gt;Nigeria&lt;/option&gt;\r\n        &lt;option value=&quot;Norway&quot;&gt;Norway&lt;/option&gt;\r\n        &lt;option value=&quot;Oman&quot;&gt;Oman&lt;/option&gt;\r\n        &lt;option value=&quot;Pakistan&quot;&gt;Pakistan&lt;/option&gt;\r\n        &lt;option value=&quot;Palau&quot;&gt;Palau&lt;/option&gt;\r\n        &lt;option value=&quot;Panama&quot;&gt;Panama&lt;/option&gt;\r\n        &lt;option value=&quot;Papua New Guinea&quot;&gt;Papua New Guinea&lt;/option&gt;\r\n        &lt;option value=&quot;Paraguay&quot;&gt;Paraguay&lt;/option&gt;\r\n        &lt;option value=&quot;Peru&quot;&gt;Peru&lt;/option&gt;\r\n        &lt;option value=&quot;Philippines&quot;&gt;Philippines&lt;/option&gt;\r\n        &lt;option value=&quot;Poland&quot;&gt;Poland&lt;/option&gt;\r\n        &lt;option value=&quot;Portugal&quot;&gt;Portugal&lt;/option&gt;\r\n        &lt;option value=&quot;Qatar&quot;&gt;Qatar&lt;/option&gt;\r\n        &lt;option value=&quot;Romania&quot;&gt;Romania&lt;/option&gt;\r\n        &lt;option value=&quot;Russian Federation&quot;&gt;Russian Federation&lt;/option&gt;\r\n        &lt;option value=&quot;Rwanda&quot;&gt;Rwanda&lt;/option&gt;\r\n        &lt;option value=&quot;St Kitts &amp;amp; Nevis&quot;&gt;St Kitts &amp;amp; Nevis&lt;/option&gt;\r\n        &lt;option value=&quot;St Lucia&quot;&gt;St Lucia&lt;/option&gt;\r\n        &lt;option value=&quot;Saint Vincent &amp;amp; the Grenadines&quot;&gt;Saint Vincent &amp;amp; the Grenadines&lt;/option&gt;\r\n        &lt;option value=&quot;Samoa&quot;&gt;Samoa&lt;/option&gt;\r\n        &lt;option value=&quot;San Marino&quot;&gt;San Marino&lt;/option&gt;\r\n        &lt;option value=&quot;Sao Tome &amp;amp; Principe&quot;&gt;Sao Tome &amp;amp; Principe&lt;/option&gt;\r\n        &lt;option value=&quot;Saudi Arabia&quot;&gt;Saudi Arabia&lt;/option&gt;\r\n        &lt;option value=&quot;Senegal&quot;&gt;Senegal&lt;/option&gt;\r\n        &lt;option value=&quot;Serbia&quot;&gt;Serbia&lt;/option&gt;\r\n        &lt;option value=&quot;Seychelles&quot;&gt;Seychelles&lt;/option&gt;\r\n        &lt;option value=&quot;Sierra Leone&quot;&gt;Sierra Leone&lt;/option&gt;\r\n        &lt;option value=&quot;Singapore&quot;&gt;Singapore&lt;/option&gt;\r\n        &lt;option value=&quot;Slovakia&quot;&gt;Slovakia&lt;/option&gt;\r\n        &lt;option value=&quot;Slovenia&quot;&gt;Slovenia&lt;/option&gt;\r\n        &lt;option value=&quot;Solomon Islands&quot;&gt;Solomon Islands&lt;/option&gt;\r\n        &lt;option value=&quot;Somalia&quot;&gt;Somalia&lt;/option&gt;\r\n        &lt;option value=&quot;South Africa&quot;&gt;South Africa&lt;/option&gt;\r\n        &lt;option value=&quot;South Sudan&quot;&gt;South Sudan&lt;/option&gt;\r\n        &lt;option value=&quot;Spain&quot;&gt;Spain&lt;/option&gt;\r\n        &lt;option value=&quot;Sri Lanka&quot;&gt;Sri Lanka&lt;/option&gt;\r\n        &lt;option value=&quot;Sudan&quot;&gt;Sudan&lt;/option&gt;\r\n        &lt;option value=&quot;Suriname&quot;&gt;Suriname&lt;/option&gt;\r\n        &lt;option value=&quot;Swaziland&quot;&gt;Swaziland&lt;/option&gt;\r\n        &lt;option value=&quot;Sweden&quot;&gt;Sweden&lt;/option&gt;\r\n        &lt;option value=&quot;Switzerland&quot;&gt;Switzerland&lt;/option&gt;\r\n        &lt;option value=&quot;Syria&quot;&gt;Syria&lt;/option&gt;\r\n        &lt;option value=&quot;Taiwan&quot;&gt;Taiwan&lt;/option&gt;\r\n        &lt;option value=&quot;Tajikistan&quot;&gt;Tajikistan&lt;/option&gt;\r\n        &lt;option value=&quot;Tanzania&quot;&gt;Tanzania&lt;/option&gt;\r\n        &lt;option value=&quot;Thailand&quot;&gt;Thailand&lt;/option&gt;\r\n        &lt;option value=&quot;Togo&quot;&gt;Togo&lt;/option&gt;\r\n        &lt;option value=&quot;Tonga&quot;&gt;Tonga&lt;/option&gt;\r\n        &lt;option value=&quot;Trinidad &amp;amp; Tobago&quot;&gt;Trinidad &amp;amp; Tobago&lt;/option&gt;\r\n        &lt;option value=&quot;Tunisia&quot;&gt;Tunisia&lt;/option&gt;\r\n        &lt;option value=&quot;Turkey&quot;&gt;Turkey&lt;/option&gt;\r\n        &lt;option value=&quot;Turkmenistan&quot;&gt;Turkmenistan&lt;/option&gt;\r\n        &lt;option value=&quot;Tuvalu&quot;&gt;Tuvalu&lt;/option&gt;\r\n        &lt;option value=&quot;Uganda&quot;&gt;Uganda&lt;/option&gt;\r\n        &lt;option value=&quot;Ukraine&quot;&gt;Ukraine&lt;/option&gt;\r\n        &lt;option value=&quot;United Arab Emirates&quot;&gt;United Arab Emirates&lt;/option&gt;\r\n        &lt;option value=&quot;Uruguay&quot;&gt;Uruguay&lt;/option&gt;\r\n        &lt;option value=&quot;Uzbekistan&quot;&gt;Uzbekistan&lt;/option&gt;\r\n        &lt;option value=&quot;Vanuatu&quot;&gt;Vanuatu&lt;/option&gt;\r\n        &lt;option value=&quot;Vatican City&quot;&gt;Vatican City&lt;/option&gt;\r\n        &lt;option value=&quot;Venezuela&quot;&gt;Venezuela&lt;/option&gt;\r\n        &lt;option value=&quot;Vietnam&quot;&gt;Vietnam&lt;/option&gt;\r\n        &lt;option value=&quot;Yemen&quot;&gt;Yemen&lt;/option&gt;\r\n        &lt;option value=&quot;Zambia&quot;&gt;Zambia&lt;/option&gt;\r\n        &lt;option value=&quot;Zimbabwe&quot;&gt;Zimbabwe&lt;/option&gt;\r\n    &lt;/select&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_4&quot;&gt;Web Site&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_4&quot; name=&quot;text_4&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Email --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;email_0&quot;&gt;Email Address&lt;/label&gt;\r\n    &lt;input type=&quot;email&quot; id=&quot;email_0&quot; name=&quot;email_0&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group col-xs-6&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_5&quot;&gt;Home Phone&lt;/label&gt;\r\n    &lt;input type=&quot;tel&quot; id=&quot;text_5&quot; name=&quot;text_5&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group col-xs-6&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_6&quot;&gt;Cell Phone&lt;/label&gt;\r\n    &lt;input type=&quot;tel&quot; id=&quot;text_6&quot; name=&quot;text_6&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Date --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;date_0&quot;&gt;Birthday&lt;/label&gt;\r\n    &lt;input type=&quot;date&quot; id=&quot;date_0&quot; name=&quot;date_0&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text Area --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;textarea_0&quot;&gt;Notes&lt;/label&gt;\r\n    &lt;textarea id=&quot;textarea_0&quot; name=&quot;textarea_0&quot; rows=&quot;3&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Button --&gt;\r\n&lt;div class=&quot;form-action&quot;&gt;\r\n    &lt;input type=&quot;submit&quot; id=&quot;button_0&quot; name=&quot;button_0&quot; class=&quot;btn btn-primary&quot; value=&quot;Submit&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;/fieldset&gt;\r\n&lt;/form&gt;', 0, 'address-book', 1, 1, 1576184991, 1576184991);
INSERT INTO `template` VALUES (10, 3, 'Sales Lead Form', 'Capture your website leads with a simple lead form. Our sales lead form helps you understand where your leads are coming from, and it asks for detailed contact information so that you can reach out to prospects', '{\"settings\":{\"name\":\"Sales Lead Form\",\"canvas\":\"#canvas\",\"disabledFieldset\":false,\"layoutSelected\":\"\",\"layouts\":[{\"id\":\"\",\"name\":\"Vertical\"},{\"id\":\"form-horizontal\",\"name\":\"Horizontal\"},{\"id\":\"form-inline\",\"name\":\"Inline\"}],\"formSteps\":{\"title\":\"formSteps.title\",\"fields\":{\"id\":{\"label\":\"formSteps.id\",\"type\":\"input\",\"value\":\"formSteps\",\"name\":\"id\"},\"steps\":{\"label\":\"formSteps.steps\",\"type\":\"textarea-split\",\"value\":[],\"name\":\"steps\"},\"progressBar\":{\"label\":\"formSteps.progressBar\",\"type\":\"checkbox\",\"value\":false,\"name\":\"progressBar\"},\"noTitles\":{\"label\":\"formSteps.noTitles\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noTitles\"},\"noStages\":{\"label\":\"formSteps.noStages\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noStages\"},\"noSteps\":{\"label\":\"formSteps.noSteps\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noSteps\"}}}},\"initForm\":[{\"name\":\"heading\",\"title\":\"heading.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"heading_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"input\",\"value\":\"Sales Lead Form\",\"name\":\"text\"},\"type\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"h1\",\"selected\":false,\"label\":\"H1\"},{\"value\":\"h2\",\"selected\":false,\"label\":\"H2\"},{\"value\":\"h3\",\"selected\":true,\"label\":\"H3\"},{\"value\":\"h4\",\"selected\":false,\"label\":\"H4\"},{\"value\":\"h5\",\"selected\":false,\"label\":\"H5\"},{\"value\":\"h6\",\"selected\":false,\"label\":\"H6\"}],\"name\":\"type\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"legend\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"paragraph\",\"title\":\"paragraph.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"paragraph_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"textarea\",\"value\":\"Please enter your information below so we can be in touch.\",\"name\":\"text\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_0\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Company\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_1\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Name\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_2\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Title at Company\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"email\",\"title\":\"email.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"email_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Contact Email\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-6\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"checkdns\":{\"label\":\"component.checkDNS\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"checkdns\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_3\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":false,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":true,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Contact Phone\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-6\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_4\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Contact Address\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_5\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"City\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-4\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_6\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"State\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-4\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"selectlist\",\"title\":\"selectlist.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"selectlist_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Country\",\"name\":\"label\"},\"options\":{\"label\":\"component.options\",\"type\":\"textarea-split\",\"value\":[\"United States\",\"United Kingdom\",\"Australia\",\"Canada\",\"France\",\"----\",\"Afghanistan\",\"Albania\",\"Algeria\",\"Andorra\",\"Angola\",\"Antigua \\u0026 Deps\",\"Argentina\",\"Armenia\",\"Austria\",\"Azerbaijan\",\"Bahamas\",\"Bahrain\",\"Bangladesh\",\"Barbados\",\"Belarus\",\"Belgium\",\"Belize\",\"Benin\",\"Bhutan\",\"Bolivia\",\"Bosnia Herzegovina\",\"Botswana\",\"Brazil\",\"Brunei\",\"Bulgaria\",\"Burkina\",\"Burundi\",\"Cambodia\",\"Cameroon\",\"Cape Verde\",\"Central African Rep\",\"Chad\",\"Chile\",\"China\",\"Colombia\",\"Comoros\",\"Congo\",\"Congo {Democratic Rep}\",\"Costa Rica\",\"Croatia\",\"Cuba\",\"Cyprus\",\"Czech Republic\",\"Denmark\",\"Djibouti\",\"Dominica\",\"Dominican Republic\",\"East Timor\",\"Ecuador\",\"Egypt\",\"El Salvador\",\"Equatorial Guinea\",\"Eritrea\",\"Estonia\",\"Ethiopia\",\"Fiji\",\"Finland\",\"Gabon\",\"Gambia\",\"Georgia\",\"Germany\",\"Ghana\",\"Greece\",\"Grenada\",\"Guatemala\",\"Guinea\",\"Guinea-Bissau\",\"Guyana\",\"Haiti\",\"Honduras\",\"Hungary\",\"Iceland\",\"India\",\"Indonesia\",\"Iran\",\"Iraq\",\"Ireland {Republic}\",\"Israel\",\"Italy\",\"Ivory Coast\",\"Jamaica\",\"Japan\",\"Jordan\",\"Kazakhstan\",\"Kenya\",\"Kiribati\",\"Korea North\",\"Korea South\",\"Kosovo\",\"Kuwait\",\"Kyrgyzstan\",\"Laos\",\"Latvia\",\"Lebanon\",\"Lesotho\",\"Liberia\",\"Libya\",\"Liechtenstein\",\"Lithuania\",\"Luxembourg\",\"Macedonia\",\"Madagascar\",\"Malawi\",\"Malaysia\",\"Maldives\",\"Mali\",\"Malta\",\"Marshall Islands\",\"Mauritania\",\"Mauritius\",\"Mexico\",\"Micronesia\",\"Moldova\",\"Monaco\",\"Mongolia\",\"Montenegro\",\"Morocco\",\"Mozambique\",\"Myanmar, {Burma}\",\"Namibia\",\"Nauru\",\"Nepal\",\"Netherlands\",\"New Zealand\",\"Nicaragua\",\"Niger\",\"Nigeria\",\"Norway\",\"Oman\",\"Pakistan\",\"Palau\",\"Panama\",\"Papua New Guinea\",\"Paraguay\",\"Peru\",\"Philippines\",\"Poland\",\"Portugal\",\"Qatar\",\"Romania\",\"Russian Federation\",\"Rwanda\",\"St Kitts \\u0026 Nevis\",\"St Lucia\",\"Saint Vincent \\u0026 the Grenadines\",\"Samoa\",\"San Marino\",\"Sao Tome \\u0026 Principe\",\"Saudi Arabia\",\"Senegal\",\"Serbia\",\"Seychelles\",\"Sierra Leone\",\"Singapore\",\"Slovakia\",\"Slovenia\",\"Solomon Islands\",\"Somalia\",\"South Africa\",\"South Sudan\",\"Spain\",\"Sri Lanka\",\"Sudan\",\"Suriname\",\"Swaziland\",\"Sweden\",\"Switzerland\",\"Syria\",\"Taiwan\",\"Tajikistan\",\"Tanzania\",\"Thailand\",\"Togo\",\"Tonga\",\"Trinidad \\u0026 Tobago\",\"Tunisia\",\"Turkey\",\"Turkmenistan\",\"Tuvalu\",\"Uganda\",\"Ukraine\",\"United Arab Emirates\",\"Uruguay\",\"Uzbekistan\",\"Vanuatu\",\"Vatican City\",\"Venezuela\",\"Vietnam\",\"Yemen\",\"Zambia\",\"Zimbabwe\"],\"name\":\"options\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"-Select-\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-4\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_7\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":false,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":true,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Company Website\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"textarea\",\"title\":\"textarea.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"textarea_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Please tell us about your industry.\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"fieldSize\":{\"label\":\"component.fieldSize\",\"type\":\"input\",\"value\":\"3\",\"advanced\":true,\"name\":\"fieldSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"textarea\",\"title\":\"textarea.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"textarea_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Questions or Comments\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"fieldSize\":{\"label\":\"component.fieldSize\",\"type\":\"input\",\"value\":\"3\",\"advanced\":true,\"name\":\"fieldSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"button\",\"title\":\"button.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"button_0\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"submit\",\"label\":\"Submit\",\"selected\":true},{\"value\":\"reset\",\"label\":\"Reset\",\"selected\":false},{\"value\":\"image\",\"label\":\"Image\",\"selected\":false}],\"name\":\"inputType\"},\"buttonText\":{\"label\":\"component.buttonText\",\"type\":\"input\",\"value\":\"Submit\",\"name\":\"buttonText\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"label\"},\"src\":{\"label\":\"component.src\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"src\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"btn btn-primary\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false}],\"height\":876}', '&lt;form id=&quot;form-app&quot;&gt;\r\n&lt;fieldset&gt;\r\n\r\n&lt;!-- Heading --&gt;\r\n&lt;h3 class=&quot;legend&quot;&gt;Sales Lead Form&lt;/h3&gt;\r\n\r\n&lt;!-- Paragraph Text --&gt;\r\n&lt;p&gt;Please enter your information below so we can be in touch.&lt;/p&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_0&quot;&gt;Company&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_0&quot; name=&quot;text_0&quot; value=&quot;&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_1&quot;&gt;Name&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_1&quot; name=&quot;text_1&quot; value=&quot;&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_2&quot;&gt;Title at Company&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_2&quot; name=&quot;text_2&quot; value=&quot;&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Email --&gt;\r\n&lt;div class=&quot;form-group required-control col-xs-6&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;email_0&quot;&gt;Contact Email&lt;/label&gt;\r\n    &lt;input type=&quot;email&quot; id=&quot;email_0&quot; name=&quot;email_0&quot; value=&quot;&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group col-xs-6&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_3&quot;&gt;Contact Phone&lt;/label&gt;\r\n    &lt;input type=&quot;tel&quot; id=&quot;text_3&quot; name=&quot;text_3&quot; value=&quot;&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_4&quot;&gt;Contact Address&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_4&quot; name=&quot;text_4&quot; value=&quot;&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group col-xs-4&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_5&quot;&gt;City&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_5&quot; name=&quot;text_5&quot; value=&quot;&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group col-xs-4&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_6&quot;&gt;State&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_6&quot; name=&quot;text_6&quot; value=&quot;&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Select List --&gt;\r\n&lt;div class=&quot;form-group col-xs-4&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_0&quot;&gt;Country&lt;/label&gt;\r\n    &lt;select id=&quot;selectlist_0&quot; name=&quot;selectlist_0[]&quot; class=&quot;form-control&quot;&gt;\r\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\r\n        &lt;option value=&quot;United States&quot;&gt;United States&lt;/option&gt;\r\n        &lt;option value=&quot;United Kingdom&quot;&gt;United Kingdom&lt;/option&gt;\r\n        &lt;option value=&quot;Australia&quot;&gt;Australia&lt;/option&gt;\r\n        &lt;option value=&quot;Canada&quot;&gt;Canada&lt;/option&gt;\r\n        &lt;option value=&quot;France&quot;&gt;France&lt;/option&gt;\r\n        &lt;option value=&quot;----&quot;&gt;----&lt;/option&gt;\r\n        &lt;option value=&quot;Afghanistan&quot;&gt;Afghanistan&lt;/option&gt;\r\n        &lt;option value=&quot;Albania&quot;&gt;Albania&lt;/option&gt;\r\n        &lt;option value=&quot;Algeria&quot;&gt;Algeria&lt;/option&gt;\r\n        &lt;option value=&quot;Andorra&quot;&gt;Andorra&lt;/option&gt;\r\n        &lt;option value=&quot;Angola&quot;&gt;Angola&lt;/option&gt;\r\n        &lt;option value=&quot;Antigua &amp;amp; Deps&quot;&gt;Antigua &amp;amp; Deps&lt;/option&gt;\r\n        &lt;option value=&quot;Argentina&quot;&gt;Argentina&lt;/option&gt;\r\n        &lt;option value=&quot;Armenia&quot;&gt;Armenia&lt;/option&gt;\r\n        &lt;option value=&quot;Austria&quot;&gt;Austria&lt;/option&gt;\r\n        &lt;option value=&quot;Azerbaijan&quot;&gt;Azerbaijan&lt;/option&gt;\r\n        &lt;option value=&quot;Bahamas&quot;&gt;Bahamas&lt;/option&gt;\r\n        &lt;option value=&quot;Bahrain&quot;&gt;Bahrain&lt;/option&gt;\r\n        &lt;option value=&quot;Bangladesh&quot;&gt;Bangladesh&lt;/option&gt;\r\n        &lt;option value=&quot;Barbados&quot;&gt;Barbados&lt;/option&gt;\r\n        &lt;option value=&quot;Belarus&quot;&gt;Belarus&lt;/option&gt;\r\n        &lt;option value=&quot;Belgium&quot;&gt;Belgium&lt;/option&gt;\r\n        &lt;option value=&quot;Belize&quot;&gt;Belize&lt;/option&gt;\r\n        &lt;option value=&quot;Benin&quot;&gt;Benin&lt;/option&gt;\r\n        &lt;option value=&quot;Bhutan&quot;&gt;Bhutan&lt;/option&gt;\r\n        &lt;option value=&quot;Bolivia&quot;&gt;Bolivia&lt;/option&gt;\r\n        &lt;option value=&quot;Bosnia Herzegovina&quot;&gt;Bosnia Herzegovina&lt;/option&gt;\r\n        &lt;option value=&quot;Botswana&quot;&gt;Botswana&lt;/option&gt;\r\n        &lt;option value=&quot;Brazil&quot;&gt;Brazil&lt;/option&gt;\r\n        &lt;option value=&quot;Brunei&quot;&gt;Brunei&lt;/option&gt;\r\n        &lt;option value=&quot;Bulgaria&quot;&gt;Bulgaria&lt;/option&gt;\r\n        &lt;option value=&quot;Burkina&quot;&gt;Burkina&lt;/option&gt;\r\n        &lt;option value=&quot;Burundi&quot;&gt;Burundi&lt;/option&gt;\r\n        &lt;option value=&quot;Cambodia&quot;&gt;Cambodia&lt;/option&gt;\r\n        &lt;option value=&quot;Cameroon&quot;&gt;Cameroon&lt;/option&gt;\r\n        &lt;option value=&quot;Cape Verde&quot;&gt;Cape Verde&lt;/option&gt;\r\n        &lt;option value=&quot;Central African Rep&quot;&gt;Central African Rep&lt;/option&gt;\r\n        &lt;option value=&quot;Chad&quot;&gt;Chad&lt;/option&gt;\r\n        &lt;option value=&quot;Chile&quot;&gt;Chile&lt;/option&gt;\r\n        &lt;option value=&quot;China&quot;&gt;China&lt;/option&gt;\r\n        &lt;option value=&quot;Colombia&quot;&gt;Colombia&lt;/option&gt;\r\n        &lt;option value=&quot;Comoros&quot;&gt;Comoros&lt;/option&gt;\r\n        &lt;option value=&quot;Congo&quot;&gt;Congo&lt;/option&gt;\r\n        &lt;option value=&quot;Congo {Democratic Rep}&quot;&gt;Congo {Democratic Rep}&lt;/option&gt;\r\n        &lt;option value=&quot;Costa Rica&quot;&gt;Costa Rica&lt;/option&gt;\r\n        &lt;option value=&quot;Croatia&quot;&gt;Croatia&lt;/option&gt;\r\n        &lt;option value=&quot;Cuba&quot;&gt;Cuba&lt;/option&gt;\r\n        &lt;option value=&quot;Cyprus&quot;&gt;Cyprus&lt;/option&gt;\r\n        &lt;option value=&quot;Czech Republic&quot;&gt;Czech Republic&lt;/option&gt;\r\n        &lt;option value=&quot;Denmark&quot;&gt;Denmark&lt;/option&gt;\r\n        &lt;option value=&quot;Djibouti&quot;&gt;Djibouti&lt;/option&gt;\r\n        &lt;option value=&quot;Dominica&quot;&gt;Dominica&lt;/option&gt;\r\n        &lt;option value=&quot;Dominican Republic&quot;&gt;Dominican Republic&lt;/option&gt;\r\n        &lt;option value=&quot;East Timor&quot;&gt;East Timor&lt;/option&gt;\r\n        &lt;option value=&quot;Ecuador&quot;&gt;Ecuador&lt;/option&gt;\r\n        &lt;option value=&quot;Egypt&quot;&gt;Egypt&lt;/option&gt;\r\n        &lt;option value=&quot;El Salvador&quot;&gt;El Salvador&lt;/option&gt;\r\n        &lt;option value=&quot;Equatorial Guinea&quot;&gt;Equatorial Guinea&lt;/option&gt;\r\n        &lt;option value=&quot;Eritrea&quot;&gt;Eritrea&lt;/option&gt;\r\n        &lt;option value=&quot;Estonia&quot;&gt;Estonia&lt;/option&gt;\r\n        &lt;option value=&quot;Ethiopia&quot;&gt;Ethiopia&lt;/option&gt;\r\n        &lt;option value=&quot;Fiji&quot;&gt;Fiji&lt;/option&gt;\r\n        &lt;option value=&quot;Finland&quot;&gt;Finland&lt;/option&gt;\r\n        &lt;option value=&quot;Gabon&quot;&gt;Gabon&lt;/option&gt;\r\n        &lt;option value=&quot;Gambia&quot;&gt;Gambia&lt;/option&gt;\r\n        &lt;option value=&quot;Georgia&quot;&gt;Georgia&lt;/option&gt;\r\n        &lt;option value=&quot;Germany&quot;&gt;Germany&lt;/option&gt;\r\n        &lt;option value=&quot;Ghana&quot;&gt;Ghana&lt;/option&gt;\r\n        &lt;option value=&quot;Greece&quot;&gt;Greece&lt;/option&gt;\r\n        &lt;option value=&quot;Grenada&quot;&gt;Grenada&lt;/option&gt;\r\n        &lt;option value=&quot;Guatemala&quot;&gt;Guatemala&lt;/option&gt;\r\n        &lt;option value=&quot;Guinea&quot;&gt;Guinea&lt;/option&gt;\r\n        &lt;option value=&quot;Guinea-Bissau&quot;&gt;Guinea-Bissau&lt;/option&gt;\r\n        &lt;option value=&quot;Guyana&quot;&gt;Guyana&lt;/option&gt;\r\n        &lt;option value=&quot;Haiti&quot;&gt;Haiti&lt;/option&gt;\r\n        &lt;option value=&quot;Honduras&quot;&gt;Honduras&lt;/option&gt;\r\n        &lt;option value=&quot;Hungary&quot;&gt;Hungary&lt;/option&gt;\r\n        &lt;option value=&quot;Iceland&quot;&gt;Iceland&lt;/option&gt;\r\n        &lt;option value=&quot;India&quot;&gt;India&lt;/option&gt;\r\n        &lt;option value=&quot;Indonesia&quot;&gt;Indonesia&lt;/option&gt;\r\n        &lt;option value=&quot;Iran&quot;&gt;Iran&lt;/option&gt;\r\n        &lt;option value=&quot;Iraq&quot;&gt;Iraq&lt;/option&gt;\r\n        &lt;option value=&quot;Ireland {Republic}&quot;&gt;Ireland {Republic}&lt;/option&gt;\r\n        &lt;option value=&quot;Israel&quot;&gt;Israel&lt;/option&gt;\r\n        &lt;option value=&quot;Italy&quot;&gt;Italy&lt;/option&gt;\r\n        &lt;option value=&quot;Ivory Coast&quot;&gt;Ivory Coast&lt;/option&gt;\r\n        &lt;option value=&quot;Jamaica&quot;&gt;Jamaica&lt;/option&gt;\r\n        &lt;option value=&quot;Japan&quot;&gt;Japan&lt;/option&gt;\r\n        &lt;option value=&quot;Jordan&quot;&gt;Jordan&lt;/option&gt;\r\n        &lt;option value=&quot;Kazakhstan&quot;&gt;Kazakhstan&lt;/option&gt;\r\n        &lt;option value=&quot;Kenya&quot;&gt;Kenya&lt;/option&gt;\r\n        &lt;option value=&quot;Kiribati&quot;&gt;Kiribati&lt;/option&gt;\r\n        &lt;option value=&quot;Korea North&quot;&gt;Korea North&lt;/option&gt;\r\n        &lt;option value=&quot;Korea South&quot;&gt;Korea South&lt;/option&gt;\r\n        &lt;option value=&quot;Kosovo&quot;&gt;Kosovo&lt;/option&gt;\r\n        &lt;option value=&quot;Kuwait&quot;&gt;Kuwait&lt;/option&gt;\r\n        &lt;option value=&quot;Kyrgyzstan&quot;&gt;Kyrgyzstan&lt;/option&gt;\r\n        &lt;option value=&quot;Laos&quot;&gt;Laos&lt;/option&gt;\r\n        &lt;option value=&quot;Latvia&quot;&gt;Latvia&lt;/option&gt;\r\n        &lt;option value=&quot;Lebanon&quot;&gt;Lebanon&lt;/option&gt;\r\n        &lt;option value=&quot;Lesotho&quot;&gt;Lesotho&lt;/option&gt;\r\n        &lt;option value=&quot;Liberia&quot;&gt;Liberia&lt;/option&gt;\r\n        &lt;option value=&quot;Libya&quot;&gt;Libya&lt;/option&gt;\r\n        &lt;option value=&quot;Liechtenstein&quot;&gt;Liechtenstein&lt;/option&gt;\r\n        &lt;option value=&quot;Lithuania&quot;&gt;Lithuania&lt;/option&gt;\r\n        &lt;option value=&quot;Luxembourg&quot;&gt;Luxembourg&lt;/option&gt;\r\n        &lt;option value=&quot;Macedonia&quot;&gt;Macedonia&lt;/option&gt;\r\n        &lt;option value=&quot;Madagascar&quot;&gt;Madagascar&lt;/option&gt;\r\n        &lt;option value=&quot;Malawi&quot;&gt;Malawi&lt;/option&gt;\r\n        &lt;option value=&quot;Malaysia&quot;&gt;Malaysia&lt;/option&gt;\r\n        &lt;option value=&quot;Maldives&quot;&gt;Maldives&lt;/option&gt;\r\n        &lt;option value=&quot;Mali&quot;&gt;Mali&lt;/option&gt;\r\n        &lt;option value=&quot;Malta&quot;&gt;Malta&lt;/option&gt;\r\n        &lt;option value=&quot;Marshall Islands&quot;&gt;Marshall Islands&lt;/option&gt;\r\n        &lt;option value=&quot;Mauritania&quot;&gt;Mauritania&lt;/option&gt;\r\n        &lt;option value=&quot;Mauritius&quot;&gt;Mauritius&lt;/option&gt;\r\n        &lt;option value=&quot;Mexico&quot;&gt;Mexico&lt;/option&gt;\r\n        &lt;option value=&quot;Micronesia&quot;&gt;Micronesia&lt;/option&gt;\r\n        &lt;option value=&quot;Moldova&quot;&gt;Moldova&lt;/option&gt;\r\n        &lt;option value=&quot;Monaco&quot;&gt;Monaco&lt;/option&gt;\r\n        &lt;option value=&quot;Mongolia&quot;&gt;Mongolia&lt;/option&gt;\r\n        &lt;option value=&quot;Montenegro&quot;&gt;Montenegro&lt;/option&gt;\r\n        &lt;option value=&quot;Morocco&quot;&gt;Morocco&lt;/option&gt;\r\n        &lt;option value=&quot;Mozambique&quot;&gt;Mozambique&lt;/option&gt;\r\n        &lt;option value=&quot;Myanmar, {Burma}&quot;&gt;Myanmar, {Burma}&lt;/option&gt;\r\n        &lt;option value=&quot;Namibia&quot;&gt;Namibia&lt;/option&gt;\r\n        &lt;option value=&quot;Nauru&quot;&gt;Nauru&lt;/option&gt;\r\n        &lt;option value=&quot;Nepal&quot;&gt;Nepal&lt;/option&gt;\r\n        &lt;option value=&quot;Netherlands&quot;&gt;Netherlands&lt;/option&gt;\r\n        &lt;option value=&quot;New Zealand&quot;&gt;New Zealand&lt;/option&gt;\r\n        &lt;option value=&quot;Nicaragua&quot;&gt;Nicaragua&lt;/option&gt;\r\n        &lt;option value=&quot;Niger&quot;&gt;Niger&lt;/option&gt;\r\n        &lt;option value=&quot;Nigeria&quot;&gt;Nigeria&lt;/option&gt;\r\n        &lt;option value=&quot;Norway&quot;&gt;Norway&lt;/option&gt;\r\n        &lt;option value=&quot;Oman&quot;&gt;Oman&lt;/option&gt;\r\n        &lt;option value=&quot;Pakistan&quot;&gt;Pakistan&lt;/option&gt;\r\n        &lt;option value=&quot;Palau&quot;&gt;Palau&lt;/option&gt;\r\n        &lt;option value=&quot;Panama&quot;&gt;Panama&lt;/option&gt;\r\n        &lt;option value=&quot;Papua New Guinea&quot;&gt;Papua New Guinea&lt;/option&gt;\r\n        &lt;option value=&quot;Paraguay&quot;&gt;Paraguay&lt;/option&gt;\r\n        &lt;option value=&quot;Peru&quot;&gt;Peru&lt;/option&gt;\r\n        &lt;option value=&quot;Philippines&quot;&gt;Philippines&lt;/option&gt;\r\n        &lt;option value=&quot;Poland&quot;&gt;Poland&lt;/option&gt;\r\n        &lt;option value=&quot;Portugal&quot;&gt;Portugal&lt;/option&gt;\r\n        &lt;option value=&quot;Qatar&quot;&gt;Qatar&lt;/option&gt;\r\n        &lt;option value=&quot;Romania&quot;&gt;Romania&lt;/option&gt;\r\n        &lt;option value=&quot;Russian Federation&quot;&gt;Russian Federation&lt;/option&gt;\r\n        &lt;option value=&quot;Rwanda&quot;&gt;Rwanda&lt;/option&gt;\r\n        &lt;option value=&quot;St Kitts &amp;amp; Nevis&quot;&gt;St Kitts &amp;amp; Nevis&lt;/option&gt;\r\n        &lt;option value=&quot;St Lucia&quot;&gt;St Lucia&lt;/option&gt;\r\n        &lt;option value=&quot;Saint Vincent &amp;amp; the Grenadines&quot;&gt;Saint Vincent &amp;amp; the Grenadines&lt;/option&gt;\r\n        &lt;option value=&quot;Samoa&quot;&gt;Samoa&lt;/option&gt;\r\n        &lt;option value=&quot;San Marino&quot;&gt;San Marino&lt;/option&gt;\r\n        &lt;option value=&quot;Sao Tome &amp;amp; Principe&quot;&gt;Sao Tome &amp;amp; Principe&lt;/option&gt;\r\n        &lt;option value=&quot;Saudi Arabia&quot;&gt;Saudi Arabia&lt;/option&gt;\r\n        &lt;option value=&quot;Senegal&quot;&gt;Senegal&lt;/option&gt;\r\n        &lt;option value=&quot;Serbia&quot;&gt;Serbia&lt;/option&gt;\r\n        &lt;option value=&quot;Seychelles&quot;&gt;Seychelles&lt;/option&gt;\r\n        &lt;option value=&quot;Sierra Leone&quot;&gt;Sierra Leone&lt;/option&gt;\r\n        &lt;option value=&quot;Singapore&quot;&gt;Singapore&lt;/option&gt;\r\n        &lt;option value=&quot;Slovakia&quot;&gt;Slovakia&lt;/option&gt;\r\n        &lt;option value=&quot;Slovenia&quot;&gt;Slovenia&lt;/option&gt;\r\n        &lt;option value=&quot;Solomon Islands&quot;&gt;Solomon Islands&lt;/option&gt;\r\n        &lt;option value=&quot;Somalia&quot;&gt;Somalia&lt;/option&gt;\r\n        &lt;option value=&quot;South Africa&quot;&gt;South Africa&lt;/option&gt;\r\n        &lt;option value=&quot;South Sudan&quot;&gt;South Sudan&lt;/option&gt;\r\n        &lt;option value=&quot;Spain&quot;&gt;Spain&lt;/option&gt;\r\n        &lt;option value=&quot;Sri Lanka&quot;&gt;Sri Lanka&lt;/option&gt;\r\n        &lt;option value=&quot;Sudan&quot;&gt;Sudan&lt;/option&gt;\r\n        &lt;option value=&quot;Suriname&quot;&gt;Suriname&lt;/option&gt;\r\n        &lt;option value=&quot;Swaziland&quot;&gt;Swaziland&lt;/option&gt;\r\n        &lt;option value=&quot;Sweden&quot;&gt;Sweden&lt;/option&gt;\r\n        &lt;option value=&quot;Switzerland&quot;&gt;Switzerland&lt;/option&gt;\r\n        &lt;option value=&quot;Syria&quot;&gt;Syria&lt;/option&gt;\r\n        &lt;option value=&quot;Taiwan&quot;&gt;Taiwan&lt;/option&gt;\r\n        &lt;option value=&quot;Tajikistan&quot;&gt;Tajikistan&lt;/option&gt;\r\n        &lt;option value=&quot;Tanzania&quot;&gt;Tanzania&lt;/option&gt;\r\n        &lt;option value=&quot;Thailand&quot;&gt;Thailand&lt;/option&gt;\r\n        &lt;option value=&quot;Togo&quot;&gt;Togo&lt;/option&gt;\r\n        &lt;option value=&quot;Tonga&quot;&gt;Tonga&lt;/option&gt;\r\n        &lt;option value=&quot;Trinidad &amp;amp; Tobago&quot;&gt;Trinidad &amp;amp; Tobago&lt;/option&gt;\r\n        &lt;option value=&quot;Tunisia&quot;&gt;Tunisia&lt;/option&gt;\r\n        &lt;option value=&quot;Turkey&quot;&gt;Turkey&lt;/option&gt;\r\n        &lt;option value=&quot;Turkmenistan&quot;&gt;Turkmenistan&lt;/option&gt;\r\n        &lt;option value=&quot;Tuvalu&quot;&gt;Tuvalu&lt;/option&gt;\r\n        &lt;option value=&quot;Uganda&quot;&gt;Uganda&lt;/option&gt;\r\n        &lt;option value=&quot;Ukraine&quot;&gt;Ukraine&lt;/option&gt;\r\n        &lt;option value=&quot;United Arab Emirates&quot;&gt;United Arab Emirates&lt;/option&gt;\r\n        &lt;option value=&quot;Uruguay&quot;&gt;Uruguay&lt;/option&gt;\r\n        &lt;option value=&quot;Uzbekistan&quot;&gt;Uzbekistan&lt;/option&gt;\r\n        &lt;option value=&quot;Vanuatu&quot;&gt;Vanuatu&lt;/option&gt;\r\n        &lt;option value=&quot;Vatican City&quot;&gt;Vatican City&lt;/option&gt;\r\n        &lt;option value=&quot;Venezuela&quot;&gt;Venezuela&lt;/option&gt;\r\n        &lt;option value=&quot;Vietnam&quot;&gt;Vietnam&lt;/option&gt;\r\n        &lt;option value=&quot;Yemen&quot;&gt;Yemen&lt;/option&gt;\r\n        &lt;option value=&quot;Zambia&quot;&gt;Zambia&lt;/option&gt;\r\n        &lt;option value=&quot;Zimbabwe&quot;&gt;Zimbabwe&lt;/option&gt;\r\n    &lt;/select&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_7&quot;&gt;Company Website&lt;/label&gt;\r\n    &lt;input type=&quot;url&quot; id=&quot;text_7&quot; name=&quot;text_7&quot; value=&quot;&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text Area --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;textarea_0&quot;&gt;Please tell us about your industry.&lt;/label&gt;\r\n    &lt;textarea id=&quot;textarea_0&quot; name=&quot;textarea_0&quot; rows=&quot;3&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text Area --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;textarea_1&quot;&gt;Questions or Comments&lt;/label&gt;\r\n    &lt;textarea id=&quot;textarea_1&quot; name=&quot;textarea_1&quot; rows=&quot;3&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Button --&gt;\r\n&lt;div class=&quot;form-action&quot;&gt;\r\n    &lt;input type=&quot;submit&quot; id=&quot;button_0&quot; name=&quot;button_0&quot; class=&quot;btn btn-primary&quot; value=&quot;Submit&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;/fieldset&gt;\r\n&lt;/form&gt;', 1, 'sales-lead-form', 1, 1, 1576184991, 1576184991);
INSERT INTO `template` VALUES (11, 1, 'Mailing List', 'A mailing list is a collection of names and addresses used by an individual or an organization to send material to multiple recipients.', '{\"settings\":{\"name\":\"Mailing List\",\"canvas\":\"#canvas\",\"disabledFieldset\":false,\"layoutSelected\":\"form-inline\",\"layouts\":[{\"id\":\"\",\"name\":\"Vertical\"},{\"id\":\"form-horizontal\",\"name\":\"Horizontal\"},{\"id\":\"form-inline\",\"name\":\"Inline\"}],\"formSteps\":{\"title\":\"formSteps.title\",\"fields\":{\"id\":{\"label\":\"formSteps.id\",\"type\":\"input\",\"value\":\"formSteps\",\"name\":\"id\"},\"steps\":{\"label\":\"formSteps.steps\",\"type\":\"textarea-split\",\"value\":[],\"name\":\"steps\"},\"progressBar\":{\"label\":\"formSteps.progressBar\",\"type\":\"checkbox\",\"value\":false,\"name\":\"progressBar\"},\"noTitles\":{\"label\":\"formSteps.noTitles\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noTitles\"},\"noStages\":{\"label\":\"formSteps.noStages\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noStages\"},\"noSteps\":{\"label\":\"formSteps.noSteps\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noSteps\"}}}},\"initForm\":[{\"name\":\"heading\",\"title\":\"heading.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"heading_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"input\",\"value\":\"Join our Mailing List\",\"name\":\"text\"},\"type\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"h1\",\"selected\":false,\"label\":\"H1\"},{\"value\":\"h2\",\"selected\":false,\"label\":\"H2\"},{\"value\":\"h3\",\"selected\":true,\"label\":\"H3\"},{\"value\":\"h4\",\"selected\":false,\"label\":\"H4\"},{\"value\":\"h5\",\"selected\":false,\"label\":\"H5\"},{\"value\":\"h6\",\"selected\":false,\"label\":\"H6\"}],\"name\":\"heading\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"legend\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"paragraph\",\"title\":\"paragraph.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"paragraph_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"textarea\",\"value\":\"Keep up to date with information about our publishing by joining our mailing list!\",\"name\":\"text\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_0\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Your Name\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"Your Name\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"email\",\"title\":\"email.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"email_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Your Email Address\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"Your Email\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"checkdns\":{\"label\":\"component.checkDNS\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"checkdns\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"button\",\"title\":\"button.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"button_0\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"submit\",\"label\":\"Submit\",\"selected\":true},{\"value\":\"reset\",\"label\":\"Reset\",\"selected\":false},{\"value\":\"image\",\"label\":\"Image\",\"selected\":false}],\"name\":\"inputType\"},\"buttonText\":{\"label\":\"component.buttonText\",\"type\":\"input\",\"value\":\"Submit\",\"name\":\"buttonText\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"label\"},\"src\":{\"label\":\"component.src\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"src\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"btn btn-primary\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false}],\"height\":150}', '&lt;form id=&quot;form-app&quot; class=&quot;form-inline&quot;&gt;\r\n&lt;fieldset&gt;\r\n\r\n&lt;!-- Heading --&gt;\r\n&lt;h3 class=&quot;legend&quot;&gt;Join our Mailing List&lt;/h3&gt;\r\n\r\n&lt;!-- Paragraph Text --&gt;\r\n&lt;p&gt;Keep up to date with information about our publishing by joining our mailing list!&lt;/p&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group required-control&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_0&quot;&gt;Your Name&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_0&quot; name=&quot;text_0&quot; placeholder=&quot;Your Name&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Email --&gt;\r\n&lt;div class=&quot;form-group required-control&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;email_0&quot;&gt;Your Email Address&lt;/label&gt;\r\n    &lt;input type=&quot;email&quot; id=&quot;email_0&quot; name=&quot;email_0&quot; placeholder=&quot;Your Email&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Button --&gt;\r\n&lt;div class=&quot;form-action&quot;&gt;\r\n    &lt;input type=&quot;submit&quot; id=&quot;button_0&quot; name=&quot;button_0&quot; class=&quot;btn btn-primary&quot; value=&quot;Submit&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;/fieldset&gt;\r\n&lt;/form&gt;', 0, 'mailing-list', 1, 1, 1576184991, 1576184991);
INSERT INTO `template` VALUES (12, 4, 'Wedding RSVP Form', 'About to get married? Create your own online RSVP to know how many guests would attend your wedding reception. Easy for your guests to read and quickly to fill in!', '{\"settings\":{\"name\":\"Wedding RSVP Form\",\"canvas\":\"#canvas\",\"disabledFieldset\":false,\"layoutSelected\":\"\",\"layouts\":[{\"id\":\"\",\"name\":\"Vertical\"},{\"id\":\"form-horizontal\",\"name\":\"Horizontal\"},{\"id\":\"form-inline\",\"name\":\"Inline\"}],\"formSteps\":{\"title\":\"formSteps.title\",\"fields\":{\"id\":{\"label\":\"formSteps.id\",\"type\":\"input\",\"value\":\"formSteps\",\"name\":\"id\"},\"steps\":{\"label\":\"formSteps.steps\",\"type\":\"textarea-split\",\"value\":[],\"name\":\"steps\"},\"progressBar\":{\"label\":\"formSteps.progressBar\",\"type\":\"checkbox\",\"value\":false,\"name\":\"progressBar\"},\"noTitles\":{\"label\":\"formSteps.noTitles\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noTitles\"},\"noStages\":{\"label\":\"formSteps.noStages\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noStages\"},\"noSteps\":{\"label\":\"formSteps.noSteps\",\"type\":\"checkbox\",\"value\":false,\"name\":\"noSteps\"}}}},\"initForm\":[{\"name\":\"heading\",\"title\":\"heading.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"heading_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"input\",\"value\":\"Caroline \\u0026 Steven\\u0027s Wedding RSVP\",\"name\":\"text\"},\"type\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"h1\",\"selected\":false,\"label\":\"H1\"},{\"value\":\"h2\",\"selected\":false,\"label\":\"H2\"},{\"value\":\"h3\",\"selected\":true,\"label\":\"H3\"},{\"value\":\"h4\",\"selected\":false,\"label\":\"H4\"},{\"value\":\"h5\",\"selected\":false,\"label\":\"H5\"},{\"value\":\"h6\",\"selected\":false,\"label\":\"H6\"}],\"name\":\"type\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"legend\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"paragraph\",\"title\":\"paragraph.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"paragraph_0\",\"name\":\"id\"},\"text\":{\"label\":\"component.text\",\"type\":\"textarea\",\"value\":\"We look forward to celebrating with you! Please reply by October 18, 2016\",\"name\":\"text\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"cssClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_0\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"First Name\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-6\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_1\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Last Name\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-6\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"selectlist\",\"title\":\"selectlist.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"selectlist_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Are you coming?\",\"name\":\"label\"},\"options\":{\"label\":\"component.options\",\"type\":\"textarea-split\",\"value\":[\"Can\\u0027t Wait!\",\"Sorry To Miss Out\"],\"name\":\"options\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"-Select-\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":true,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-6\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"selectlist\",\"title\":\"selectlist.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"selectlist_1\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Persons will atend\",\"name\":\"label\"},\"options\":{\"label\":\"component.options\",\"type\":\"textarea-split\",\"value\":[\"1\",\"2\"],\"name\":\"options\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"-Select-\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"col-xs-6\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"},\"multiple\":{\"label\":\"component.multiple\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"multiple\"}},\"fresh\":false},{\"name\":\"text\",\"title\":\"text.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"text_2\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.inputType\",\"type\":\"select\",\"value\":[{\"value\":\"text\",\"selected\":true,\"label\":\"Text\"},{\"value\":\"tel\",\"selected\":false,\"label\":\"Tel\"},{\"value\":\"url\",\"selected\":false,\"label\":\"URL\"},{\"value\":\"color\",\"selected\":false,\"label\":\"Color\"},{\"value\":\"password\",\"selected\":false,\"label\":\"Password\"}],\"name\":\"inputType\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Guest Name\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"pattern\":{\"label\":\"component.pattern\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"pattern\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"textarea\",\"title\":\"textarea.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"textarea_0\",\"name\":\"id\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"Any special dietary requirements\",\"name\":\"label\"},\"placeholder\":{\"label\":\"component.placeholder\",\"type\":\"input\",\"value\":\"\",\"name\":\"placeholder\"},\"predefinedValue\":{\"label\":\"component.predefinedValue\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"predefinedValue\"},\"required\":{\"label\":\"component.required\",\"type\":\"checkbox\",\"value\":false,\"name\":\"required\"},\"helpText\":{\"label\":\"component.helpText\",\"type\":\"textarea\",\"value\":\"\",\"advanced\":true,\"name\":\"helpText\"},\"fieldSize\":{\"label\":\"component.fieldSize\",\"type\":\"input\",\"value\":\"3\",\"advanced\":true,\"name\":\"fieldSize\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"form-control\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"alias\":{\"label\":\"component.alias\",\"type\":\"input\",\"value\":\"\",\"advanced\":true},\"unique\":{\"label\":\"component.unique\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"unique\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false},{\"name\":\"snippet\",\"title\":\"snippet.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"snippet_0\",\"name\":\"id\"},\"snippet\":{\"label\":\"component.htmlCode\",\"type\":\"textarea\",\"value\":\"\\u003Cp\\u003E\\u003Cstrong\\u003EHow to get there!\\u003C\\/strong\\u003E\\u003C\\/p\\u003E\\n\\u003Cp\\u003E\\u003Csmall\\u003EThe Francis Marion Hotel 387 King Street Charleston. South Carolina.\\u003C\\/small\\u003E\\u003C\\/p\\u003E\\n\\u003Cdiv id=\\u0022map\\u0022\\u003E\\u003C\\/div\\u003E\\n\\u003Cstyle type=\\u0022text\\/css\\u0022\\u003E\\n#map {\\n    width: 100%;\\n    height: 300px;\\n    margin-bottom: 15px;\\n    background-color: #f3f5f7;\\n}\\n\\u003C\\/style\\u003E\",\"name\":\"snippet\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"}},\"fresh\":false},{\"name\":\"button\",\"title\":\"button.title\",\"fields\":{\"id\":{\"label\":\"component.id\",\"type\":\"input\",\"value\":\"button_0\",\"name\":\"id\"},\"inputType\":{\"label\":\"component.type\",\"type\":\"select\",\"value\":[{\"value\":\"submit\",\"label\":\"Submit\",\"selected\":true},{\"value\":\"reset\",\"label\":\"Reset\",\"selected\":false},{\"value\":\"image\",\"label\":\"Image\",\"selected\":false}],\"name\":\"inputType\"},\"buttonText\":{\"label\":\"component.buttonText\",\"type\":\"input\",\"value\":\"Submit\",\"name\":\"buttonText\"},\"label\":{\"label\":\"component.label\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"label\"},\"src\":{\"label\":\"component.src\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"src\"},\"cssClass\":{\"label\":\"component.cssClass\",\"type\":\"input\",\"value\":\"btn btn-primary\",\"advanced\":true,\"name\":\"cssClass\"},\"labelClass\":{\"label\":\"component.labelClass\",\"type\":\"input\",\"value\":\"control-label\",\"advanced\":true,\"name\":\"labelClass\"},\"containerClass\":{\"label\":\"component.containerClass\",\"type\":\"input\",\"value\":\"\",\"advanced\":true,\"name\":\"containerClass\"},\"readOnly\":{\"label\":\"component.readOnly\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"readOnly\"},\"disabled\":{\"label\":\"component.disabled\",\"type\":\"checkbox\",\"value\":false,\"advanced\":true,\"name\":\"disabled\"}},\"fresh\":false}],\"height\":861}', '&lt;form id=&quot;form-app&quot;&gt;\r\n&lt;fieldset&gt;\r\n\r\n&lt;!-- Heading --&gt;\r\n&lt;h3 class=&quot;legend&quot;&gt;Caroline &amp;amp; Steven&#039;s Wedding RSVP&lt;/h3&gt;\r\n\r\n&lt;!-- Paragraph Text --&gt;\r\n&lt;p&gt;We look forward to celebrating with you! Please reply by October 18, 2016&lt;/p&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group required-control col-xs-6&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_0&quot;&gt;First Name&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_0&quot; name=&quot;text_0&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group required-control col-xs-6&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_1&quot;&gt;Last Name&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_1&quot; name=&quot;text_1&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Select List --&gt;\r\n&lt;div class=&quot;form-group required-control col-xs-6&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_0&quot;&gt;Are you coming?&lt;/label&gt;\r\n    &lt;select id=&quot;selectlist_0&quot; name=&quot;selectlist_0[]&quot; class=&quot;form-control&quot; required=&quot;&quot;&gt;\r\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\r\n        &lt;option value=&quot;Can&#039;t Wait!&quot;&gt;Can&#039;t Wait!&lt;/option&gt;\r\n        &lt;option value=&quot;Sorry To Miss Out&quot;&gt;Sorry To Miss Out&lt;/option&gt;\r\n    &lt;/select&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Select List --&gt;\r\n&lt;div class=&quot;form-group col-xs-6&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;selectlist_1&quot;&gt;Persons will atend&lt;/label&gt;\r\n    &lt;select id=&quot;selectlist_1&quot; name=&quot;selectlist_1[]&quot; class=&quot;form-control&quot;&gt;\r\n        &lt;option value=&quot;&quot; disabled=&quot;&quot; selected=&quot;&quot;&gt;-Select-&lt;/option&gt;\r\n        &lt;option value=&quot;1&quot;&gt;1&lt;/option&gt;\r\n        &lt;option value=&quot;2&quot;&gt;2&lt;/option&gt;\r\n    &lt;/select&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;text_2&quot;&gt;Guest Name&lt;/label&gt;\r\n    &lt;input type=&quot;text&quot; id=&quot;text_2&quot; name=&quot;text_2&quot; class=&quot;form-control&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Text Area --&gt;\r\n&lt;div class=&quot;form-group&quot;&gt;\r\n    &lt;label class=&quot;control-label&quot; for=&quot;textarea_0&quot;&gt;Any special dietary requirements&lt;/label&gt;\r\n    &lt;textarea id=&quot;textarea_0&quot; name=&quot;textarea_0&quot; rows=&quot;3&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;!-- Snippet --&gt;\r\n&lt;div class=&quot;snippet&quot;&gt;&lt;p&gt;&lt;strong&gt;How to get there!&lt;/strong&gt;&lt;/p&gt;\r\n&lt;p&gt;&lt;small&gt;The Francis Marion Hotel 387 King Street Charleston. South Carolina.&lt;/small&gt;&lt;/p&gt;\r\n&lt;div id=&quot;map&quot;&gt;&lt;/div&gt;\r\n&lt;style type=&quot;text/css&quot;&gt;\r\n#map {\r\n    width: 100%;\r\n    height: 300px;\r\n    margin-bottom: 15px;\r\n    background-color: #f3f5f7;\r\n}\r\n&lt;/style&gt;&lt;/div&gt;\r\n\r\n&lt;!-- Button --&gt;\r\n&lt;div class=&quot;form-action&quot;&gt;\r\n    &lt;input type=&quot;submit&quot; id=&quot;button_0&quot; name=&quot;button_0&quot; class=&quot;btn btn-primary&quot; value=&quot;Submit&quot;&gt;\r\n&lt;/div&gt;\r\n\r\n&lt;/fieldset&gt;\r\n&lt;/form&gt;', 0, 'wedding-rsvp-form', 1, 1, 1576184991, 1576184991);

-- ----------------------------
-- Table structure for template_category
-- ----------------------------
DROP TABLE IF EXISTS `template_category`;
CREATE TABLE `template_category`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `description` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 8 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of template_category
-- ----------------------------
INSERT INTO `template_category` VALUES (1, 'Online Forms', 'If you need a ready-to-go form for your website, you\'ve come to the right place.', 1576185892, 1576185892);
INSERT INTO `template_category` VALUES (2, 'Surveys', 'Curious what people think? Need to do some polling? Then this online surveys are made for you.', 1576185892, 1576185892);
INSERT INTO `template_category` VALUES (3, 'Lead Generation', 'A lead generation template is a critical piece of the puzzle on any website designed to attract customer inquiries for follow up.', 1576184991, 1576184991);
INSERT INTO `template_category` VALUES (4, 'Invitation', 'Party? Did someone say party? Add a online invitation to your website, or send it out through email, to make collecting responses a snap.', 1576184991, 1576184991);
INSERT INTO `template_category` VALUES (5, 'Online Order', 'Are you looking for a way to take orders online instead of over the phone? Well then, what you need is an online order form template.', 1576184991, 1576184991);
INSERT INTO `template_category` VALUES (6, 'Registrations', 'Are you an event planner, or has someone \"volunteered\" you to organize that ski lodge reservation for all of your friends? This templates will help you to make organizing events a painless process.', 1576184991, 1576184991);
INSERT INTO `template_category` VALUES (7, 'Tracking', 'Spreadsheets are so yesterday for inventory and tracking purposes. Instead of a spreadsheet, you need a tracking form to keep tabs on inventory, host evaluations, file addresses, or even to record your exercise habits.', 1576184991, 1576184991);

-- ----------------------------
-- Table structure for theme
-- ----------------------------
DROP TABLE IF EXISTS `theme`;
CREATE TABLE `theme`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `description` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `color` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `css` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `created_by` int(11) NOT NULL,
  `updated_by` int(11) NOT NULL,
  `created_at` int(11) NULL DEFAULT NULL,
  `updated_at` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 11 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of theme
-- ----------------------------
INSERT INTO `theme` VALUES (1, 'Blue Denim', 'Dark blue body with white big fields.', '#212a3e', '\r\nbody {\r\n    background-color: #212a3e;\r\n    padding: 20px;\r\n    color: #7b8291;\r\n}\r\n\r\n/* Small devices (tablets, 768px and up) */\r\n@media (min-width: 768px) {\r\n    body {\r\n        padding: 50px;\r\n    }\r\n}\r\nstrong {\r\n    color: #FFFFFF;\r\n}\r\n.legend {\r\n    font-family: \"helvetica\", \"arial\", \"sans-serif\";\r\n    font-size: 28px;\r\n    font-weight: 400;\r\n    line-height: 1.4;\r\n    color: #fff;\r\n    margin: 0 0 5px;\r\n}\r\np.description {\r\n    color: #1ec185;\r\n    background: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAsAAAAPCAYAAAAyPTUwAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA4JpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNS1jMDIxIDc5LjE1NTc3MiwgMjAxNC8wMS8xMy0xOTo0NDowMCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDpEQUIyQTJGOUZCNzZERTExQkFGNUUxNDNCMEI4NkZGMSIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDpFREYxQURBODk5N0YxMUU0OTU0N0EzNkVCREUxQzBFRCIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDpFREYxQURBNzk5N0YxMUU0OTU0N0EzNkVCREUxQzBFRCIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ0MgMjAxNCAoTWFjaW50b3NoKSI+IDx4bXBNTTpEZXJpdmVkRnJvbSBzdFJlZjppbnN0YW5jZUlEPSJ4bXAuaWlkOmNlOWNlZGU1LTM1YTYtNDFiNi04NDA4LTM2YmIxMjY4NjdhNSIgc3RSZWY6ZG9jdW1lbnRJRD0iYWRvYmU6ZG9jaWQ6cGhvdG9zaG9wOmI2Nzk5MjljLWRmZTMtMTE3Ny1iOGNhLTlmM2YyOWFkM2Y1YiIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PoBOvTYAAACrSURBVHjaYpE72MqABKSA2B+IZYH4ERBvAOIXMEkWJIUhQLwIiDmRxHqBOBqqiYEJKiiJpvA/lOaCiosgK/ZFUhgIxKxAHAHl8wKxF7IzZJGs3gCl16L5BW4ystth4A+6AEgRIxBzIIkJYtHICVN8HIjNkSTeYVFcB8QOTGgK8QE7JgYSwCBS/JNItV9BQecJxD5ArAPEikDMB8RsUEM+A/E9IL4EilGAAAMAaCsYB5gwb+gAAAAASUVORK5CYII=\") 0 40% no-repeat;\r\n    font-size: 14px;\r\n    padding-left: 20px;\r\n    display: inline-block;\r\n    margin: 5px auto 0;\r\n}\r\n.form-group, .form-action {\r\n    font-size: 14px;\r\n    color: #7b8291;\r\n    margin: 27px 0 9px;\r\n}\r\n.control-label {\r\n    font-size: 16px;\r\n    color: #fff;\r\n    margin: 0 5px 9px 0;\r\n}\r\n.required-control .control-label:after {\r\n    color: #e55;\r\n    margin-left: 5px;\r\n}\r\n.form-control {\r\n    background: #363e51;\r\n    border-color: transparent;\r\n    border-radius: 3px;\r\n    color: #fff;\r\n    margin: 0;\r\n    height: 36px;\r\n    width: 100%;\r\n    -webkit-transition: background .08s linear;\r\n    -moz-transition: background .08s linear;\r\n    -o-transition: background .08s linear;\r\n    transition: background .08s linear;\r\n}\r\n.form-control:hover {\r\n    background: #424a5b\r\n}\r\n.form-control:focus {\r\n    background: #fff;\r\n    color: #212a3e\r\n}\r\n.form-control::-webkit-input-placeholder {\r\n    color: #7b8291\r\n}\r\n.form-control::-moz-placeholder {\r\n    color: #7b8291\r\n}\r\n.form-control:-ms-input-placeholder {\r\n    color: #7b8291\r\n}\r\n.form-control::placeholder {\r\n    color: #7b8291\r\n}\r\n.btn {\r\n    border-radius: 4px;\r\n    border: 0 !important;\r\n    font-size: 18px;\r\n    font-weight: 500;\r\n    width: auto;\r\n    height: 55px;\r\n    line-height: 55px;\r\n    margin: 0;\r\n    padding: 0 30px;\r\n    -webkit-transition: background-color .1s ease;\r\n    -moz-transition: background-color .1s ease;\r\n    -o-transition: background-color .1s ease;\r\n    transition: background-color .1s ease;\r\n}\r\n.btn-primary {\r\n    background-color: #1ec185;\r\n}\r\n.btn-primary:focus, .btn-primary:active, .btn-primary:hover {\r\n    background-color: #1baf79 !important;\r\n    color: #fff;\r\n    border: 0 !important;\r\n    outline: 0 none !important;\r\n    box-shadow: none !important;\r\n}\r\n', 1, 1, 1576185890, 1576185890);
INSERT INTO `theme` VALUES (2, 'Sky Blue', 'Blue sky background with clouds around. White form with a thin typography.', '#95D6FE', '\r\n@import url(https://fonts.googleapis.com/css?family=Roboto:400,300);\r\nbody {\r\n    background-color: #95D6FE;\r\n    overflow-x: hidden;\r\n    padding: 20px;\r\n    color: #A9A9A9;\r\n    color: rgba(255, 255, 255, 0.6);\r\n    font-family: Roboto, sans-serif;\r\n}\r\n/* Small devices (tablets, 768px and up) */\r\n@media (min-width: 768px) {\r\n    body {\r\n        padding: 50px 25%;\r\n    }\r\n}\r\n/**\r\n * Form\r\n */\r\nh3 {\r\n    color: #FFFFFF;\r\n    font-size: 32px;\r\n    font-weight: 300;\r\n    text-align: center;\r\n    margin: .3em 0;\r\n    -webkit-animation: titleFadein .8s ease;\r\n    -moz-animation: titleFadein .8s ease;\r\n    animation: titleFadein .8s ease;\r\n}\r\np:first-of-type {\r\n    color: #FFFFFF;\r\n    color: rgba(255, 255, 255, 0.92);\r\n    font-weight: 300;\r\n    font-size: 20px;\r\n    text-shadow: none;\r\n    text-align: center;\r\n}\r\n.form-group {\r\n    background-color: #ffffff;\r\n    font-size: 14px;\r\n    padding: 20px 40px 10px;\r\n    margin: 0;\r\n}\r\n.form-group:first-of-type {\r\n    padding-top: 40px;\r\n    margin-top: 40px;\r\n    border-radius: 12px 12px 0 0;\r\n}\r\n.form-action {\r\n    margin: 0;\r\n    padding: 20px 40px 40px 40px;\r\n    border-radius: 0 0 12px 12px;\r\n    background-color: #ffffff;\r\n    font-size: 14px;\r\n}\r\n.control-label {\r\n    font-weight: 300;\r\n    font-size: 16px;\r\n    color: #777777;\r\n}\r\n.form-control {\r\n    width: 100%;\r\n    height: 48px;\r\n    -webkit-box-sizing: padding-box;\r\n    -moz-box-sizing: padding-box;\r\n    box-sizing: padding-box;\r\n    -webkit-appearance: none;\r\n    -moz-appearance: none;\r\n    appearance: none;\r\n    background-color: #EFEFEF;\r\n    background-color: rgba(0, 0, 0, 0.03);\r\n    border-color: transparent;\r\n    border-radius: 6px;\r\n    font-size: 20px;\r\n    font-family: Roboto, sans-serif;\r\n    font-weight: 300;\r\n    box-shadow: inset 0px 2px 1px rgba(0, 0, 0, .03);\r\n    outline: none;\r\n    text-overflow: ellipsis;\r\n    -webkit-font-smoothing: antialiased;\r\n}\r\n.form-control:focus {\r\n    border-color: rgb(138, 197, 65);\r\n    box-shadow: inset 0 0 0 0,inset 0 1px 2px rgba(138, 197, 65, 0.15),0 0 10px rgba(138, 197, 65, 0.8),0 2px 0 rgba(138, 197, 65,0.1);\r\n    transition: none;\r\n}\r\n.form-control::-webkit-input-placeholder {\r\n    color: #A9A9A9;\r\n}\r\n.form-control::-moz-placeholder {\r\n    color: #A9A9A9;\r\n}\r\n.form-control:-ms-input-placeholder {\r\n    color: #A9A9A9;\r\n}\r\n.form-control::placeholder {\r\n    color: #A9A9A9;\r\n}\r\n.radio label, .checkbox label {\r\n    color: #7C7C7C;\r\n    font-weight: 300;\r\n}\r\n.btn {\r\n    display: block;\r\n    padding: 0 28px;\r\n    border-radius: 28px;\r\n    width: auto;\r\n    height: 56px;\r\n    margin: 0 auto;\r\n    overflow: hidden;\r\n    -webkit-font-smoothing: antialiased;\r\n    font-size: 24px;\r\n}\r\n.btn-primary {\r\n    background-color: rgb(138, 197, 65);\r\n    background-color: rgba(138, 197, 65, 0.90);\r\n    border-color: transparent;\r\n}\r\n.btn-primary:focus, .btn-primary:hover {\r\n    background: rgb(138, 197, 65) !important;\r\n    border-color: transparent !important;\r\n    color: rgb(255, 255, 255) !important;\r\n}\r\n.info {\r\n    font-size: 16px;\r\n    color: rgb(102, 102, 102);\r\n    color: rgba(102, 102, 102, 0.3);\r\n    padding: 10px 40px;\r\n    background-color: #ffffff;\r\n    margin: 0;\r\n}\r\n/**\r\n * Clouds\r\n *\r\n * You must add this snippet to your form:\r\n *\r\n * <div id=\"clouds\">\r\n *   <div class=\"cloud x1\"></div>\r\n *   <div class=\"cloud x2\"></div>\r\n *   <div class=\"cloud x3\"></div>\r\n *   <div class=\"cloud x4\"></div>\r\n *   <div class=\"cloud x5\"></div>\r\n * </div>\r\n *\r\n * Based on http://thecodeplayer.com/walkthrough/pure-css3-animated-clouds-background\r\n */\r\n#clouds{\r\n    top: 220px;\r\n    padding: 100px 0;\r\n    position: absolute;\r\n    z-index: -1;\r\n}\r\n/*Time to finalise the cloud shape*/\r\n.cloud {\r\n    width: 200px; height: 60px;\r\n    background: #fff;\r\n\r\n    border-radius: 200px;\r\n    -moz-border-radius: 200px;\r\n    -webkit-border-radius: 200px;\r\n\r\n    position: relative;\r\n}\r\n.cloud:before, .cloud:after {\r\n    content: \"\";\r\n    position: absolute;\r\n    background: #fff;\r\n    width: 100px; height: 80px;\r\n    top: -15px; left: 10px;\r\n\r\n    border-radius: 100px;\r\n    -moz-border-radius: 100px;\r\n    -webkit-border-radius: 100px;\r\n\r\n    -webkit-transform: rotate(30deg);\r\n    transform: rotate(30deg);\r\n    -moz-transform: rotate(30deg);\r\n}\r\n.cloud:after {\r\n    width: 120px; height: 120px;\r\n    top: -55px; left: auto; right: 15px;\r\n}\r\n/*Time to animate*/\r\n.x1 {\r\n    -webkit-animation: moveclouds 15s linear infinite;\r\n    -moz-animation: moveclouds 15s linear infinite;\r\n    -o-animation: moveclouds 15s linear infinite;\r\n}\r\n/*variable speed, opacity, and position of clouds for realistic effect*/\r\n.x2 {\r\n    left: 200px;\r\n\r\n    -webkit-transform: scale(0.6);\r\n    -moz-transform: scale(0.6);\r\n    transform: scale(0.6);\r\n    opacity: 0.6; /*opacity proportional to the size*/\r\n\r\n    /*Speed will also be proportional to the size and opacity*/\r\n    /*More the speed. Less the time in \"s\" = seconds*/\r\n    -webkit-animation: moveclouds 25s linear infinite;\r\n    -moz-animation: moveclouds 25s linear infinite;\r\n    -o-animation: moveclouds 25s linear infinite;\r\n}\r\n.x3 {\r\n    left: -250px; top: -200px;\r\n\r\n    -webkit-transform: scale(0.8);\r\n    -moz-transform: scale(0.8);\r\n    transform: scale(0.8);\r\n    opacity: 0.8; /*opacity proportional to size*/\r\n\r\n    -webkit-animation: moveclouds 20s linear infinite;\r\n    -moz-animation: moveclouds 20s linear infinite;\r\n    -o-animation: moveclouds 20s linear infinite;\r\n}\r\n.x4 {\r\n    left: 470px; top: -250px;\r\n\r\n    -webkit-transform: scale(0.75);\r\n    -moz-transform: scale(0.75);\r\n    transform: scale(0.75);\r\n    opacity: 0.75; /*opacity proportional to size*/\r\n\r\n    -webkit-animation: moveclouds 18s linear infinite;\r\n    -moz-animation: moveclouds 18s linear infinite;\r\n    -o-animation: moveclouds 18s linear infinite;\r\n}\r\n.x5 {\r\n    left: -150px; top: -150px;\r\n\r\n    -webkit-transform: scale(0.8);\r\n    -moz-transform: scale(0.8);\r\n    transform: scale(0.8);\r\n    opacity: 0.8; /*opacity proportional to size*/\r\n\r\n    -webkit-animation: moveclouds 20s linear infinite;\r\n    -moz-animation: moveclouds 20s linear infinite;\r\n    -o-animation: moveclouds 20s linear infinite;\r\n}\r\n@-webkit-keyframes moveclouds {\r\n    0% {margin-left: 1600px;}\r\n    100% {margin-left: -1600px;}\r\n}\r\n@-moz-keyframes moveclouds {\r\n    0% {margin-left: 1600px;}\r\n    100% {margin-left: -1600px;}\r\n}\r\n@-o-keyframes moveclouds {\r\n    0% {margin-left: 1600px;}\r\n    100% {margin-left: -1600px;}\r\n}\r\n', 1, 1, 1576185890, 1576185890);
INSERT INTO `theme` VALUES (3, 'Gray Shadow', 'A gray background with a gray form and a bluish green button.', '#eeeeee', '\r\nbody {\r\n    background-color: transparent;\r\n    padding: 0;\r\n    font-family: \"Helvetica Neue\", Helvetica, Arial, sans-serif;\r\n    font-size: 14px;\r\n    color: #000;\r\n}\r\n/* Small devices (tablets, 768px and up) */\r\n@media (min-width: 768px) {\r\n    body {\r\n        padding: 50px 25%;\r\n        background-color: #eeeeee;\r\n    }\r\n}\r\nform {\r\n    border-style: solid;\r\n    background-image: -moz-linear-gradient(top, rgba(255, 255, 255, 1), rgba(242, 242, 242, 1));\r\n    background-image: linear-gradient(top, rgba(255, 255, 255, 1), rgba(242, 242, 242, 1));\r\n    background-image: -webkit-linear-gradient(top, rgba(255, 255, 255, 1), rgba(242, 242, 242, 1));\r\n    background-repeat: no-repeat;\r\n    background-position: center center;\r\n    background-size: 100% 100%;\r\n    padding: 15px 25px;\r\n    border-radius: 1px;\r\n    box-shadow: 0px 0px 0px 0px rgba(50, 50, 50, 0.75);\r\n    border-width: 4px;\r\n    border-color: rgb(232,232,232);\r\n}\r\nh3 {\r\n    text-align: center;\r\n    color: rgb(89,89,89);\r\n    font-size: 40px;\r\n}\r\np.description {\r\n    text-align: center;\r\n    color: rgb(51, 51, 51);\r\n    font-size: 17px;\r\n}\r\np.info {\r\n    color: rgba(107,107,107,1);\r\n    font-size: 12px;\r\n    margin-top: 15px;\r\n}\r\n.form-control {\r\n    width: 100%;\r\n    height: 100%;\r\n    -webkit-box-sizing: padding-box;\r\n    -moz-box-sizing: padding-box;\r\n    box-sizing: padding-box;\r\n    -webkit-appearance: none;\r\n    -moz-appearance: none;\r\n    appearance: none;\r\n    padding: 15px;\r\n    font-size: 15px;\r\n    line-height: 15px;\r\n    color: #000;\r\n}\r\n.form-control:focus {\r\n    border-color: rgba(117,194,204,1);\r\n    box-shadow: 0 1px 1px rgba(117,194,204,0.75) inset, 0 0 8px rgba(134,215,225,1);\r\n    outline: 0 none;\r\n}\r\n.form-control::-webkit-input-placeholder { color: #a1a1a1; }\r\n.form-control:-moz-placeholder { color: #a1a1a1; }\r\n.form-control::-moz-placeholder { color: #a1a1a1; }\r\n.form-control:-ms-input-placeholder { color: #a1a1a1; }\r\n.btn {\r\n    width: 100%;\r\n    color: rgba(255,255,255,1);\r\n    font-size: 19px;\r\n    background-image: -webkit-linear-gradient(top, rgba(134,215,225,1), rgba(117,194,204,1));\r\n    padding: 11px;\r\n    border-radius: 0px;\r\n    border: transparent;\r\n    box-shadow: none;\r\n}\r\n.btn:focus, .btn:hover, input.btn:active {\r\n    background-image: -webkit-linear-gradient(bottom, rgba(134,215,225,1), rgba(117,194,204,1));\r\n    color: rgba(255, 255, 255, 1);\r\n    box-shadow: none !important;\r\n    outline: 0 none !important;\r\n    border-color: transparent;\r\n}\r\n', 1, 1, 1576185890, 1576185890);
INSERT INTO `theme` VALUES (4, 'Light Gray', 'Light gray form over dark gray body, big fields with a green button.', '#a9a9a9', '\r\n@import url(https://fonts.googleapis.com/css?family=PT+Sans:400);\r\n@import url(https://fonts.googleapis.com/css?family=Oswald:400);\r\nbody {\r\n    font-family: \"PT Sans\", sans-serif;\r\n    padding: 0;\r\n}\r\n/* Small devices (tablets, 768px and up) */\r\n@media (min-width: 768px) {\r\n    body {\r\n        padding: 60px 25%;\r\n        background-color: #a9a9a9;\r\n    }\r\n}\r\nform {\r\n    padding: 35px;\r\n    background-color: #f3f3f3;\r\n    border: 1px solid rgba(0, 0, 0, 0.34);\r\n    -webkit-box-shadow: 0 3px 9px rgba(0, 0, 0, 0.1);\r\n    -moz-box-shadow: 0 3px 9px rgba(0, 0, 0, 0.1);\r\n    box-shadow: 0 3px 9px rgba(0, 0, 0, 0.1);\r\n    border-radius: 10px;\r\n    color: #555 !important;\r\n}\r\nh3, p {\r\n    text-align: center;\r\n    font-size: 16px;\r\n}\r\nh3 {\r\n    margin: 5px;\r\n    padding: 10px 0 0 0;\r\n    font-size: 28px;\r\n    font-family: \"Oswald\", sans-serif;\r\n    text-shadow: 2px 2px 3px rgba(255,255,255,0.1);\r\n}\r\np.description {\r\n    padding: 5px 0 24px 0;\r\n}\r\n.note {\r\n    padding: 24px;\r\n    margin: 10px 0;\r\n}\r\n.form-group {\r\n    margin-bottom: 1px;\r\n    position: relative;\r\n}\r\n.form-action {\r\n    margin-top: 25px;\r\n}\r\n.control-label {\r\n    font-size: 16px;\r\n    margin: 15px 0 0 0;\r\n}\r\n.btn {\r\n    padding: 12px 18px;\r\n    width: 100%;\r\n    border: transparent;\r\n    -webkit-border-radius: 5px;\r\n    -moz-border-radius: 5px;\r\n    border-radius: 5px;\r\n    height: 60px;\r\n    font-size: 20px;\r\n    text-shadow: 0 0 #000;\r\n    -webkit-transition: background-color .1s ease;\r\n    transition: background-color .1s ease;\r\n}\r\n.btn-primary {\r\n    background-color: #1ec185;\r\n}\r\n.btn-primary:focus, .btn-primary:active, .btn-primary:hover {\r\n    background-color: #1baf79 !important;\r\n    border-color: transparent;\r\n    color: #fff;\r\n}\r\n.form-control {\r\n    font-size: 16px;\r\n    color: #6f6f6f;\r\n    border: 2px solid #FFFFFF;\r\n    height: 52px;\r\n}\r\n.form-control:focus {\r\n    border: 2px solid rgb(30, 193, 133);\r\n    border: 2px solid rgba(30, 193, 133, 0.8);\r\n    box-shadow: none;\r\n    outline: 0 none;\r\n}\r\n.form-group-icon:before {\r\n    position: absolute;\r\n    font-family: \"Glyphicons Regular\";\r\n    font-size: 36px;\r\n    color: darkgray;\r\n    top: 38px;\r\n    left: 10px;\r\n}\r\n.form-group-icon .form-control {\r\n    padding: 15px 12px 12px 52px;\r\n}\r\n.user-icon:before {\r\n    content: \"\\e004\";\r\n}\r\n.email-icon:before {\r\n    content: \"\\2709\";\r\n}\r\n.phone-icon:before {\r\n    content: \"\\e164\";\r\n}\r\n', 1, 1, 1576185890, 1576185890);
INSERT INTO `theme` VALUES (5, 'Flower Shop', 'Yellow form over Green texture. Orange header and button.', '#FBEFBF', '\r\n@import url(https://fonts.googleapis.com/css?family=Source+Sans+Pro:400,700);\r\n\r\nbody {\r\n    font-family: \"Source Sans Pro\", sans-serif;\r\n    font-size: 16px;\r\n    padding: 0;\r\n}\r\n/* Small devices (tablets, 768px and up) */\r\n@media (min-width: 768px) {\r\n    body {\r\n        padding: 50px 25%;\r\n        background: url(\"../static_files/images/themes/flower-shop.jpg\") repeat #AFC86A;\r\n    }\r\n}\r\nform {\r\n    background-color: rgb(251, 239, 191);\r\n    padding-bottom: 50px;\r\n}\r\n/* Small devices (tablets, 768px and up) */\r\n@media (min-width: 768px) {\r\n    form {\r\n        -webkit-box-shadow: 1px 0 11px rgba(50,50,50,0.74);\r\n        -moz-box-shadow: 1px 0 11px rgba(50,50,50,0.74);\r\n        box-shadow: 1px 0 11px rgba(50,50,50,0.74);\r\n    }\r\n}\r\n.legend {\r\n    font-size: 33px;\r\n    margin: 0 0 25px 0;\r\n    padding: 15px 0;\r\n    text-align: center;\r\n    background-color: rgba(251, 89, 39, 0.9);\r\n    color: white;\r\n    font-weight: 700;\r\n    text-shadow: -1px -1px 0 rgba(184, 60, 42, 0.5),\r\n    -2px -2px 1px rgba(184, 60, 42, 0.5);\r\n}\r\np {\r\n    margin: 0 15%;\r\n}\r\n.form-group, .form-action {\r\n    margin: 0 15%;\r\n}\r\n.form-control {\r\n    height: 42px;\r\n    border: 3px solid rgb(236, 217, 142);\r\n}\r\n.form-control:focus {\r\n    border-color: rgb(253, 186, 144);\r\n    box-shadow: 0 1px 1px rgba(253, 186, 144, 0.75) inset, 0 0 8px rgba(253, 186, 144, 1);\r\n    outline: 0 none;\r\n}\r\n.form-control::-webkit-input-placeholder { color: #313941; color: rgba(49, 57, 65, 0.72); }\r\n.form-control:-moz-placeholder { color: #313941; color: rgba(49, 57, 65, 0.72); }\r\n.form-control::-moz-placeholder { color: #313941; color: rgba(49, 57, 65, 0.72); }\r\n.form-control:-ms-input-placeholder { color: #313941; color: rgba(49, 57, 65, 0.72); }\r\n.control-label {\r\n    font-weight: bold;\r\n    margin-top: 15px;\r\n}\r\n.btn {\r\n    background-color: rgb(251, 89, 39);\r\n    border: transparent;\r\n    width: 100%;\r\n    margin-top: 15px;\r\n    font-size: 22px;\r\n    padding: 8px 0 8px 0;\r\n    -webkit-border-radius: 3px;\r\n    -moz-border-radius: 3px;\r\n    border-radius: 3px;\r\n    text-shadow: -1px -1px 0 rgba(184, 60, 42, 0.5),\r\n    -2px -2px 1px rgba(184, 60, 42, 0.5);\r\n}\r\n.btn:focus, .btn:active, .btn:focus:active {\r\n    outline: none;\r\n    background-color:#f14c26 !important;\r\n    box-shadow: 0 1px 1px rgba(253, 186, 144, 0.75) inset, 0 0 8px rgba(253, 186, 144, 1);\r\n}\r\n.btn:hover{\r\n    background-color:#fe6a48 !important;\r\n}\r\n', 1, 1, 1576185890, 1576185890);
INSERT INTO `theme` VALUES (6, 'White Smoke', 'Clean design for multiple purposes. Wide fields with a blue button and without shadows.', '#2B8DD6', '\r\n@import url(https://fonts.googleapis.com/css?family=Open+Sans:400,600);\r\n@import url(https://fonts.googleapis.com/css?family=Raleway:400,600);\r\nbody {\r\n    background-color: #fbfcfd;\r\n    padding: 20px;\r\n    font-family: \"Open Sans\", Helvetica, Arial, sans-serif;\r\n}\r\n.legend {\r\n    font-family: \"Raleway\", \"Helvetica Neue\", Helvetica, Arial, sans-serif;\r\n    font-size: 20px;\r\n    font-weight: 600;\r\n    color: #515151;\r\n}\r\n.form-control {\r\n    font-family: \"Open Sans\", \"Helvetica Neue\", Helvetica, Arial, sans-serif;\r\n    font-weight: 400;\r\n    height:55px;\r\n	border-radius:3px;\r\n	border-color:#d3d3d3;\r\n}\r\n.form-control:focus {\r\n    border:1px solid #2b8dd6;\r\n    box-shadow: none;\r\n    outline: 0 none;\r\n}\r\n.form-control::-webkit-input-placeholder { color: #797979; }\r\n.form-control:-moz-placeholder { color: #797979; }\r\n.form-control::-moz-placeholder { color: #797979; }\r\n.form-control:-ms-input-placeholder { color: #797979; }\r\n.control-label {\r\n	font-weight: 600;\r\n}\r\n.btn {\r\n    background-color: #2b8dd6;\r\n    box-sizing: border-box !important;\r\n    border: 0 !important;\r\n    border-bottom: 3px solid rgba(0, 0, 0, 0.1) !important;\r\n    font-family: \"Open Sans\", \"Helvetica Neue\", Helvetica, Arial, sans-serif;\r\n    font-weight: 600;\r\n    box-shadow: 0 0 0 !important;\r\n    padding: 16px 32px;\r\n}\r\n.btn:hover, .btn:active, .btn:focus {\r\n    background-color: #2b8dd6;\r\n    opacity:0.85;\r\n	border:0 !important;\r\n	border-bottom:3px solid rgba(0, 0, 0, 0.1) !important;\r\n}\r\n', 1, 1, 1576185890, 1576185890);
INSERT INTO `theme` VALUES (7, 'Habitat', 'Beauty gradient with a semi-transparent text.', '#1274a3', '\r\n@import url(https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700);\r\n@import url(https://fonts.googleapis.com/css?family=Raleway:400,700);\r\n/**\r\n * Design inspired in https://habitat.inkling.com/signup\r\n */\r\nbody {\r\n    background: linear-gradient(135deg, #1274a3 0%,#68ad74 100%);\r\n    padding: 20px;\r\n    font-family: \"Open Sans\", Helvetica, Arial, sans-serif;\r\n    color: rgb(255, 255, 255);\r\n    color: rgba(255, 255, 255, 0.75098);\r\n}\r\n.legend {\r\n    font-family: \"Raleway\", \"Helvetica Neue\", Helvetica, Arial, sans-serif;\r\n    font-size: 26px;\r\n    font-weight: 400;\r\n    color: #FFFFFF;\r\n    color: rgb(255, 255, 255);\r\n}\r\np, .checkbox-inline, .radio-inline {\r\n    font-weight: 300;\r\n}\r\n.form-control {\r\n    font-family: \"Open Sans\", \"Helvetica Neue\", Helvetica, Arial, sans-serif;\r\n    font-weight: 400;\r\n    transition: box-shadow 150ms ease-in-out;\r\n    background-color: rgb(10,13,25);\r\n    background-color: rgba(10,13,25,0.1);\r\n    border-radius: 3px;\r\n    outline: solid 2px rgba(255,255,255,0);\r\n    border-color: transparent;\r\n    box-shadow: inset 0 1px 1px rgba(10,13,25,0.15),0 1px 0 rgba(255,255,255,0.1);\r\n    box-sizing: border-box;\r\n    font-family: inherit;\r\n    font-size: 16px;\r\n    height: 45px;\r\n    width: 100%;\r\n    color: #FFFFFF;\r\n    color: rgba(255, 255, 255, 0.92098);\r\n}\r\n.form-control:focus {\r\n    box-shadow: inset 0 0 0 1px #fff,inset 0 1px 2px rgba(10,13,25,0.15),0 0 8px rgba(255,255,255,0.5),0 1px 0 rgba(255,255,255,0.1);\r\n    transition: none;\r\n}\r\n.form-control option {\r\n    background-color: #1274a3;\r\n}\r\n.form-control::-webkit-input-placeholder {\r\n    color: #FFFFFF;\r\n    color: rgba(255,255,255,0.35);\r\n}\r\n.form-control:-moz-placeholder {\r\n    color: #FFFFFF;\r\n    color: rgba(255,255,255,0.35);\r\n}\r\n.form-control::-moz-placeholder {\r\n    color: #FFFFFF;\r\n    color: rgba(255,255,255,0.35);\r\n}\r\n.form-control:-ms-input-placeholder {\r\n    color: #FFFFFF;\r\n    color: rgba(255,255,255,0.35);\r\n}\r\n.control-label {\r\n	font-weight: 600;\r\n}\r\n.required-control .control-label:after {\r\n    color: rgb(255, 255, 255) !important;\r\n    color: rgba(255, 255, 255, 0.75098) !important;\r\n}\r\n.btn {\r\n    box-sizing: border-box !important;\r\n    border: 0 !important;\r\n    border-bottom: 3px solid rgba(0, 0, 0, 0.1) !important;\r\n    font-family: \"Open Sans\", \"Helvetica Neue\", Helvetica, Arial, sans-serif;\r\n    font-weight: 600;\r\n    text-shadow: 0 -1px 0 rgba(255,255,255,0.1);\r\n    padding: 16px 32px;\r\n}\r\n.btn-primary {\r\n    background-color: rgb(110,238,215);\r\n    background-color: rgba(110,238,215,0.65);\r\n    box-shadow: inset 0 -2px 0 rgba(0,0,0,0.3),inset 0 1px 0 rgba(255,255,255,0.07),0 1px 1px rgba(10,13,25,0.5);\r\n}\r\n.btn-primary:hover, .btn-primary:active, .btn-primary:focus {\r\n    background-color: rgb(110,238,215) !important;\r\n    background-color: rgba(110,238,215,0.45) !important;\r\n    box-shadow: inset 0 -2px 0 rgba(0,0,0,0.3),inset 0 1px 0 rgba(255,255,255,0.07),0 1px 1px rgba(10,13,25,0.5) !important;\r\n    outline: 0 none !important;\r\n}\r\n/**\r\n * Alerts\r\n */\r\n.alert-success {\r\n    background-color: #68ad74;\r\n    border-color: #1274a3;\r\n}\r\n.alert-danger {\r\n    background-color: #ff7332;\r\n    border-color: #1274a3;\r\n}\r\n.has-error .help-block, .has-error .control-label, .has-error .radio, .has-error .checkbox,\r\n.has-error .radio-inline, .has-error .checkbox-inline, .has-error.radio label,\r\n.has-error.checkbox label, .has-error.radio-inline label, .has-error.checkbox-inline label {\r\n    color: #FFFFFF;\r\n}\r\n.has-error .help-block {\r\n    margin: 0;\r\n    padding: 5px 10px;\r\n    color: #FFF;\r\n}\r\n.has-error .form-control {\r\n    border-color: #ff7332;\r\n}\r\n', 1, 1, 1576185890, 1576185890);
INSERT INTO `theme` VALUES (8, 'Blue Dress', 'A beauty dark theme with subtle shadow, green button and and active fields.', '#374151', '\r\n@import url(https://fonts.googleapis.com/css?family=Open+Sans:400,600);\r\n@import url(https://fonts.googleapis.com/css?family=Raleway:400,600);\r\nbody {\r\n    background-color: #374151;\r\n    padding: 20px;\r\n    font-family: \"Open Sans\", Helvetica, Arial, sans-serif;\r\n    color: #FBFEFB;\r\n    color: rgba(255, 255, 255, 0.82098);\r\n}\r\n.legend {\r\n    font-family: \"Raleway\", \"Helvetica Neue\", Helvetica, Arial, sans-serif;\r\n    font-size: 28px;\r\n    font-weight: 400;\r\n    margin-bottom: 25px;\r\n    color: #FBFEFB;\r\n}\r\n.form-control {\r\n    font-family: \"Open Sans\", \"Helvetica Neue\", Helvetica, Arial, sans-serif;\r\n    font-weight: 400;\r\n    transition: box-shadow 150ms ease-in-out;\r\n    background-color: rgba(10,13,25,0.1);\r\n    border-radius: 5px;\r\n    outline: solid 2px rgba(255,255,255,0);\r\n    border: 2px solid transparent;\r\n    box-shadow: inset 0 1px 1px rgba(10,13,25,0.15),0 1px 0 rgba(255,255,255,0.1);\r\n    box-sizing: border-box;\r\n    font-family: inherit;\r\n    font-size: 16px;\r\n    height: 43px;\r\n    width: 100%;\r\n    color: #FFFFFF;\r\n    color: rgba(255, 255, 255, 0.82098);\r\n}\r\n.form-control:focus {\r\n    border:2px solid #95B366;\r\n    box-shadow: none;\r\n    outline: 0 none;\r\n}\r\n.form-control option {\r\n    background-color: #374151;\r\n}\r\n.form-control::-webkit-input-placeholder { color: #4A566A; }\r\n.form-control:-moz-placeholder { color: #4A566A; }\r\n.form-control::-moz-placeholder { color: #4A566A; }\r\n.form-control:-ms-input-placeholder { color: #4A566A; }\r\n.control-label {\r\n    color: #FBFEFB;\r\n	font-weight: 600;\r\n}\r\n.btn {\r\n    box-sizing: border-box !important;\r\n    border: 0 !important;\r\n    border-bottom: 3px solid rgba(0, 0, 0, 0.1) !important;\r\n    font-weight: 600;\r\n    padding: 9px 32px;\r\n    font-family: \"Open Sans\", \"Helvetica Neue\", Helvetica, Arial, sans-serif;\r\n}\r\n.btn-primary {\r\n    background-color: #95B366;\r\n}\r\n.btn-primary:hover, .btn-primary:active, .btn-primary:focus {\r\n    background-color: #95B366 !important;\r\n    opacity:0.85;\r\n	box-shadow: none;\r\n    outline: 0 none;\r\n}\r\n', 1, 1, 1576185890, 1576185890);
INSERT INTO `theme` VALUES (9, 'Tea Time', 'Beautiful theme inspired by a cup of tea. With strong contrasts, a transparent black background and white letters, you can see a picture.', '#000000', '\r\n@import url(https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700);\r\n@import url(https://fonts.googleapis.com/css?family=Raleway:400,600);\r\nbody {\r\n    background-color: transparent;\r\n    background: url(\"http://demo.easyforms.baluart.com/static_files/images/themes/tea-time.jpg\") no-repeat center center fixed;\r\n    -webkit-background-size: cover;\r\n    -moz-background-size: cover;\r\n    -o-background-size: cover;\r\n    background-size: cover;\r\n    font-family: \"Open Sans\", Helvetica, Arial, sans-serif;\r\n    color: #FFFFFF;\r\n}\r\nform {\r\n    background-color: rgb(0, 0, 0);\r\n    background-color: rgba(0, 0, 0, 0.75);\r\n    padding: 20px;\r\n}\r\n/* Small devices (tablets, 768px and up) */\r\n@media (min-width: 768px) {\r\n    /* Hide background image of the body in embed view */\r\n    .app-embed {\r\n        background: transparent;\r\n    }\r\n    form {\r\n        padding: 40px;\r\n        border-radius: 10px;\r\n    }\r\n}\r\n.legend {\r\n    font-family: \"Raleway\", \"Helvetica Neue\", Helvetica, Arial, sans-serif;\r\n    font-size: 28px;\r\n    font-weight: 600;\r\n    margin: 0 0 20px 0;\r\n}\r\np, .checkbox-inline, .radio-inline {\r\n    font-weight: 300;\r\n}\r\n.form-group, .form-action {\r\n    margin-bottom: 25px;\r\n}\r\n.form-control {\r\n    font-family: \"Open Sans\", \"Helvetica Neue\", Helvetica, Arial, sans-serif;\r\n    color: #FFFFFF;\r\n    border: 1px solid #FFFFFF;\r\n    background-color: #000000;\r\n    background-color: rgba(0, 0, 0, 0);\r\n    height: 42px;\r\n}\r\n.form-control:focus {\r\n    border-color: #F9690E;\r\n    box-shadow: none;\r\n    outline: 0 none;\r\n    transition: none;\r\n}\r\n.form-control option {\r\n    background-color: #000000;\r\n}\r\n.form-control::-webkit-input-placeholder {\r\n    color: #D2D7D3;\r\n    color: rgba(255,255,255,0.85);\r\n}\r\n.form-control:-moz-placeholder {\r\n    color: #D2D7D3;\r\n    color: rgba(255,255,255,0.65);\r\n}\r\n.form-control::-moz-placeholder {\r\n    color: #D2D7D3;\r\n    color: rgba(255,255,255,0.65);\r\n}\r\n.form-control:-ms-input-placeholder {\r\n    color: #D2D7D3;\r\n    color: rgba(255,255,255,0.65);\r\n}\r\n.control-label {\r\n	font-weight: 600;\r\n}\r\n.btn {\r\n    border-radius: 26px;\r\n    font-family: \"Open Sans\", \"Helvetica Neue\", Helvetica, Arial, sans-serif;\r\n    font-weight: 600;\r\n    padding: 12px 42px;\r\n}\r\n.btn-primary {\r\n    border-color: transparent;\r\n    background-color: #F9690E;\r\n}\r\n.btn-primary:hover, .btn-primary:active, .btn-primary:focus {\r\n    border-color: transparent !important;\r\n    background-color: #fa7d2e !important;\r\n    box-shadow: none !important;\r\n    outline: 0 none !important;\r\n}\r\n/**\r\n * Alerts\r\n */\r\n.alert-success {\r\n    background-color: #018930;\r\n    background-color: rgba(1,137,48,0.75);\r\n    border-color: #018930;\r\n}\r\n.alert-danger {\r\n    background-color: #FF0000;\r\n    background-color: rgba(255, 0, 0, 0.75);\r\n    border-color: #FF0000;\r\n}\r\n', 1, 1, 1576185890, 1576185890);
INSERT INTO `theme` VALUES (10, 'Purple Bay', 'A purple translucent theme with white fields and blue button.', '#2b2c4e', '\r\n@import url(https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700);\r\n@import url(https://fonts.googleapis.com/css?family=Raleway:300,400);\r\nbody {\r\n    padding: 20px;\r\n    background-color: transparent;\r\n    background: url(\"http://demo.easyforms.baluart.com/static_files/images/themes/purple-bay.jpg\") no-repeat center center fixed;\r\n    -webkit-background-size: cover;\r\n    -moz-background-size: cover;\r\n    -o-background-size: cover;\r\n    background-size: cover;\r\n    font-family: \"Open Sans\", Helvetica, Arial, sans-serif;\r\n    color: #cdcdcd;\r\n    color: rgba(255,255,255,0.80);\r\n}\r\n/* Small devices (tablets, 768px and up) */\r\n@media (min-width: 768px) {\r\n    /* Hide background image of the body in embed view */\r\n    .app-embed {\r\n        background: transparent;\r\n        padding: 50px 25%;\r\n    }\r\n}\r\n.legend {\r\n    display: inline-block;\r\n    font-family: \"Raleway\", \"Helvetica Neue\", Helvetica, Arial, sans-serif;\r\n    font-size: 24px;\r\n    font-weight: 300;\r\n    text-transform: uppercase;\r\n    padding-bottom: 3px;\r\n    border-bottom: 2px solid #1762ee;\r\n    margin: 0 0 20px 0;\r\n    color: #ffffff;\r\n}\r\n/* Small devices (tablets, 768px and up) */\r\n@media (min-width: 768px) {\r\n    .legend {\r\n        font-size: 28px;\r\n    }\r\n}\r\np {\r\n    font-weight: 300;\r\n}\r\n.form-group, .form-action {\r\n    margin-bottom: 25px;\r\n}\r\n.form-control {\r\n    font-family: \"Open Sans\", \"Helvetica Neue\", Helvetica, Arial, sans-serif;\r\n    color: #FFFFFF;\r\n    border-color: transparent;\r\n    background-color: #000000;\r\n    background-color: rgba(255, 255, 255, 0.15);\r\n    height: 42px;\r\n}\r\n.form-control:focus {\r\n    border-color: #ffffff;\r\n    border-color: rgba(255, 255, 255, 0.30);\r\n    box-shadow: none;\r\n    outline: 0 none;\r\n    transition: none;\r\n}\r\n.form-control option {\r\n    background-color: #000000;\r\n}\r\n.form-control::-webkit-input-placeholder {\r\n    color: #D2D7D3;\r\n    color: rgba(255,255,255,0.85);\r\n}\r\n.form-control:-moz-placeholder {\r\n    color: #D2D7D3;\r\n    color: rgba(255,255,255,0.65);\r\n}\r\n.form-control::-moz-placeholder {\r\n    color: #D2D7D3;\r\n    color: rgba(255,255,255,0.65);\r\n}\r\n.form-control:-ms-input-placeholder {\r\n    color: #D2D7D3;\r\n    color: rgba(255,255,255,0.65);\r\n}\r\n.control-label, .checkbox-inline, .radio-inline {\r\n    color: #cdcdcd;\r\n    color: rgba(255,255,255,0.80);\r\n	font-weight: 400;\r\n}\r\n.control-label {\r\n	text-transform: uppercase;\r\n}\r\n.btn {\r\n    font-family: \"Open Sans\", \"Helvetica Neue\", Helvetica, Arial, sans-serif;\r\n    font-weight: 600;\r\n    padding: 12px 42px;\r\n}\r\n.btn-primary {\r\n    border-color: transparent;\r\n    background-color: #1762ee;\r\n}\r\n.btn-primary:hover, .btn-primary:active, .btn-primary:focus {\r\n    border-color: transparent !important;\r\n    background-color: #3375f0 !important;\r\n    box-shadow: none !important;\r\n    outline: 0 none !important;\r\n}\r\n/**\r\n * Alerts\r\n */\r\n.alert-success {\r\n    background-color: #018930;\r\n    background-color: rgba(1,137,48,0.75);\r\n    border-color: #018930;\r\n}\r\n.alert-danger {\r\n    background-color: #FF0000;\r\n    background-color: rgba(255, 0, 0, 0.75);\r\n    border-color: #FF0000;\r\n}\r\n', 1, 1, 1576185890, 1576185890);

-- ----------------------------
-- Table structure for user
-- ----------------------------
DROP TABLE IF EXISTS `user`;
CREATE TABLE `user`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role_id` int(11) NOT NULL,
  `status` smallint(6) NOT NULL,
  `email` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `username` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `password` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `auth_key` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `access_token` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `logged_in_ip` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `logged_in_at` timestamp(0) NULL DEFAULT NULL,
  `created_ip` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `created_at` timestamp(0) NULL DEFAULT NULL,
  `updated_at` timestamp(0) NULL DEFAULT NULL,
  `banned_at` timestamp(0) NULL DEFAULT NULL,
  `banned_reason` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `preferences` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `user_email`(`email`) USING BTREE,
  UNIQUE INDEX `user_username`(`username`) USING BTREE,
  INDEX `user_role_id`(`role_id`) USING BTREE,
  CONSTRAINT `user_role_id` FOREIGN KEY (`role_id`) REFERENCES `role` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for user_auth
-- ----------------------------
DROP TABLE IF EXISTS `user_auth`;
CREATE TABLE `user_auth`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `provider` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `provider_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `provider_attributes` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `created_at` timestamp(0) NULL DEFAULT NULL,
  `updated_at` timestamp(0) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `user_auth_provider_id`(`provider_id`) USING BTREE,
  INDEX `user_auth_user_id`(`user_id`) USING BTREE,
  CONSTRAINT `user_auth_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for user_token
-- ----------------------------
DROP TABLE IF EXISTS `user_token`;
CREATE TABLE `user_token`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NULL DEFAULT NULL,
  `type` smallint(6) NOT NULL,
  `token` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `data` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `created_at` timestamp(0) NULL DEFAULT NULL,
  `expired_at` timestamp(0) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `user_key_key`(`token`) USING BTREE,
  INDEX `user_key_user_id`(`user_id`) USING BTREE,
  CONSTRAINT `user_key_user_id` FOREIGN KEY (`user_id`) REFERENCES `user` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

SET FOREIGN_KEY_CHECKS = 1;
