<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Balu
 * @copyright Copyright (c) 2015 - 2019 Baluart.COM
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link http://easyforms.baluart.com/ Easy Forms
 */

namespace app\components\analytics\helpers;

use DeviceDetector\DeviceDetector;

/**
 * Class UAHelper
 * @package app\components\analytics\helpers
 */
class UAHelper
{
    private static $deviceDetector;

    public static function getInstance($ua)
    {
        if (null === static::$deviceDetector) {
            static::$deviceDetector = new DeviceDetector($ua);
        }

        return static::$deviceDetector;
    }



    /**
     * Protected constructor to prevent creating a new instance of the
     * *Singleton* via the `new` operator from outside of this class.
     */
    protected function __construct()
    {
    }

    /**
     * Private clone method to prevent cloning of the instance of the
     * *Singleton* instance.
     *
     * @return void
     */
    private function __clone()
    {
    }

    /**
     * Private unserialize method to prevent unserializing of the *Singleton*
     * instance.
     *
     * @return void
     */
    private function __wakeup()
    {
    }
}
